/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.io.util.ImageUtil;

public class DrawableTransferable
implements Transferable {
    private static List<DataFlavor> flavorList;
    private static DataFlavor[] flavors;
    private Drawable drawable;
    private BufferedImage image;

    public DrawableTransferable(Drawable d) {
        this.drawable = d;
        this.image = ImageUtil.snapshot(this.drawable);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.image;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavorList.contains(flavor);
    }

    static {
        flavors = new DataFlavor[]{DataFlavor.imageFlavor};
        flavorList = Arrays.asList(flavors);
    }
}

