/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.event.EventListenerList;
import org.broadinstitute.genee.gui.ActionListenerHelper;
import org.broadinstitute.genee.gui.UIUtil;
import org.jdesktop.swingx.util.OS;

public class EditColorButton
extends JButton {
    private Color color;
    private EventListenerList actionListeners = new EventListenerList();

    public EditColorButton(Color color) {
        super("   ");
        this.color = color;
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = UIUtil.showColorDialog(UIUtil.getWindowForComponent(EditColorButton.this), "Choose Color", EditColorButton.this.color);
                if (c != null) {
                    EditColorButton.this.setColor(c);
                    EditColorButton.this.repaint();
                    ActionListenerHelper.fireActionPerformed(EditColorButton.this.actionListeners, EditColorButton.this, e);
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = 60;
        return d;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionListeners.add(ActionListener.class, l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(ActionListener.class, l);
    }

    @Override
    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.actionListeners.getListeners(ActionListener.class);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        int btnWidth = width / 2;
        int xoffset = (width - btnWidth) / 2;
        int yoffset = 8;
        if (this.isEnabled()) {
            g.setColor(this.color);
            g.fillRect(xoffset, yoffset, btnWidth, height - 2 * yoffset - (OS.isMacOSX() ? 1 : 0));
        }
        g.setColor(Color.BLACK);
        g.drawRect(xoffset, yoffset, btnWidth, height - 2 * yoffset - (OS.isMacOSX() ? 2 : 0));
    }
}

