/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.TitledSeparator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.broadinstitute.genee.gui.UIUtil;

public class FormBuilder {
    private CellConstraints cc = new CellConstraints();
    private FormLayout formLayout;
    private JPanel panel;
    private int labelColumn = 1;
    public static final String SMALL_ROW_SPACER = "6px";
    public static final String ROW_SPACER = "8px";
    public static final String COLUMN_SPACER = "6px";

    public FormBuilder() {
        this(new JPanel());
    }

    public FormBuilder(JPanel panel) {
        this(panel, 1);
    }

    public FormBuilder(JPanel panel, int columns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < columns; ++i) {
            if (i > 0) {
                sb.append(", 8px, ");
            }
            sb.append(UIUtil.createColumnStringForTwoColumnFormLayout(false));
        }
        this.formLayout = new FormLayout(sb.toString(), "");
        panel.setLayout((LayoutManager)this.formLayout);
        this.cc.hAlign = CellConstraints.RIGHT;
        this.panel = panel;
    }

    public FormBuilder add(Component c) {
        this.panel.add(c, this.cc.xy(this.labelColumn + 2, this.formLayout.getRowCount()));
        return this;
    }

    public FormBuilder addFirstColumn(Component c) {
        this.panel.add(c, new CellConstraints(this.labelColumn, this.formLayout.getRowCount(), CellConstraints.LEFT, CellConstraints.DEFAULT));
        return this;
    }

    public void addFullSpanned(Component c, int column) {
        this.panel.add(c, this.cc.xyw(column, this.formLayout.getRowCount(), this.formLayout.getColumnCount() - column + 1));
    }

    public JLabel addLabel(String label) {
        JLabel l = new JLabel(label);
        this.panel.add((Component)l, this.cc.xy(this.labelColumn, this.formLayout.getRowCount()));
        return l;
    }

    public FormBuilder addLabel2(String label) {
        JLabel l = new JLabel(label);
        this.panel.add((Component)l, this.cc.xy(this.labelColumn, this.formLayout.getRowCount()));
        return this;
    }

    public Component addSeparator() {
        if (this.formLayout.getRowCount() > 0) {
            this.formLayout.appendRow(UIUtil.decodeRowSpec(ROW_SPACER));
        }
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        JSeparator sep = new JSeparator();
        this.panel.add((Component)sep, this.cc.xyw(this.labelColumn, this.formLayout.getRowCount(), 3));
        this.formLayout.appendRow(UIUtil.decodeRowSpec(ROW_SPACER));
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        return sep;
    }

    public Component addSeparator(String title) {
        if (this.formLayout.getRowCount() > 0) {
            this.formLayout.appendRow(UIUtil.decodeRowSpec(ROW_SPACER));
        }
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        JLabel label = new JLabel(title);
        label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() + 2.0f));
        TitledSeparator sep = new TitledSeparator((JComponent)label, 2);
        this.panel.add((Component)sep, this.cc.xyw(this.labelColumn, this.formLayout.getRowCount(), 3));
        this.formLayout.appendRow(UIUtil.decodeRowSpec(ROW_SPACER));
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        return sep;
    }

    public void addSpanned(Component c) {
        this.panel.add(c, this.cc.xyw(this.labelColumn, this.formLayout.getRowCount(), this.formLayout.getColumnCount()));
    }

    public CellConstraints getCellConstraints() {
        return (CellConstraints)this.cc.clone();
    }

    public int getLabelColumn() {
        return this.labelColumn;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void nextColumn() {
        this.labelColumn += 4;
    }

    public FormBuilder nextRow() {
        this.formLayout.appendRow(UIUtil.decodeRowSpec(ROW_SPACER));
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        return this;
    }

    public FormBuilder nextRowNoSpace() {
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        return this;
    }

    public FormBuilder nextSmallRow() {
        if (this.formLayout.getRowCount() > 0) {
            this.formLayout.appendRow(UIUtil.decodeRowSpec("6px"));
        }
        this.formLayout.appendRow(UIUtil.decodeRowSpec("p"));
        return this;
    }

    public void previousColumn() {
        this.labelColumn -= 4;
    }

    public FormBuilder setIndentedBorder() {
        this.setIndentedBorder(1);
        return this;
    }

    public FormBuilder setIndentedBorder(int level) {
        this.getPanel().setBorder(FormBuilder.createIndentedBorder(level));
        return this;
    }

    public static void setToMaxWidth(FormBuilder ... formBuilders) {
        Dimension size;
        CellConstraints con;
        Component c;
        int i;
        int count;
        int maxWidth = 0;
        for (FormBuilder builder : formBuilders) {
            count = builder.panel.getComponentCount();
            for (i = 0; i < count; ++i) {
                c = builder.panel.getComponent(i);
                con = builder.formLayout.getConstraints(c);
                if (con == null || con.gridX != 1 || con.gridWidth != 1) continue;
                size = c.getPreferredSize();
                if (size.width <= maxWidth) continue;
                maxWidth = size.width;
            }
        }
        for (FormBuilder builder : formBuilders) {
            count = builder.panel.getComponentCount();
            for (i = 0; i < count; ++i) {
                c = builder.panel.getComponent(i);
                con = builder.formLayout.getConstraints(c);
                if (con == null || con.gridX != 1 || con.gridWidth != 1) continue;
                size = c.getPreferredSize();
                if (size.width >= maxWidth) continue;
                size.width = maxWidth;
                c.setPreferredSize(size);
            }
        }
    }

    public static Border createIndentedBorder(int level) {
        return BorderFactory.createEmptyBorder(0, level * 24, 0, 0);
    }
}

