/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.DockableFrameWindow;
import org.broadinstitute.genee.application.GENEEWindow;

public class GENEEToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private static GENEEToolTipManager manager;
    private GENEEWindow window;
    private FocusListener focusChangeListener;
    private JToolTip tip = new JToolTip();
    private boolean initted;

    GENEEToolTipManager() {
        this.tip.setBackground(Color.WHITE);
        if (!GraphicsEnvironment.isHeadless()) {
            this.window = Application.getWindowManager().createToolWindow("Info", 4, 1);
            this.focusChangeListener = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent evt) {
                    JComponent c = (JComponent)evt.getSource();
                    c.removeFocusListener(GENEEToolTipManager.this.focusChangeListener);
                    c.removeMouseMotionListener(GENEEToolTipManager.this);
                    GENEEToolTipManager.this.setToolTipText(null);
                }
            };
            if (this.window != null) {
                this.window.getContentPane().add(this.tip);
                ((Component)((Object)this.window)).addKeyListener(new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (!e.isConsumed() && e.getKeyChar() == 'i' && e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                            if (!GENEEToolTipManager.sharedInstance().isShowing()) {
                                GENEEToolTipManager.sharedInstance().show();
                            } else {
                                GENEEToolTipManager.sharedInstance().hide();
                            }
                            e.consume();
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                });
            }
        }
    }

    public GENEEWindow getWindow() {
        return this.window;
    }

    public void hide() {
        this.window.setVisible(false);
    }

    public boolean isShowing() {
        return ((Component)((Object)this.window)).isShowing();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.initiateToolTip(event);
    }

    @Override
    public void mouseExited(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this);
        component.removeFocusListener(this.focusChangeListener);
        this.setToolTipText(null);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        String toolTipText = component.getToolTipText(event);
        this.setToolTipText(toolTipText);
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    public void registerComponent(JComponent component) {
        component.removeMouseListener(this);
        component.addMouseListener(this);
    }

    public void show() {
        if (this.window != null) {
            this.window.activate();
            if (!this.initted) {
                ((DockableFrameWindow)this.window).revalidate();
                this.initted = true;
            }
        }
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeFocusListener(this.focusChangeListener);
    }

    private void initiateToolTip(MouseEvent event) {
        JComponent component = (JComponent)event.getSource();
        component.removeMouseMotionListener(this);
        component.addMouseMotionListener(this);
        component.removeFocusListener(this.focusChangeListener);
        component.addFocusListener(this.focusChangeListener);
    }

    private void setToolTipText(String text) {
        if (text != null && !text.startsWith("<html>")) {
            text = "<html><p>" + text;
        }
        this.tip.setTipText(text);
        if (text == null) {
            this.tip.repaint();
        }
    }

    public static GENEEToolTipManager sharedInstance() {
        if (manager == null) {
            manager = new GENEEToolTipManager();
        }
        return manager;
    }
}

