/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.chart.BarRenderer;
import org.broadinstitute.genee.chart.DefaultHistogramChartSeries;
import org.broadinstitute.genee.chart.DefaultXYChartDataset;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.LinkageMethod;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.CityBlock;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Correlation;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Euclidean;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Kendall;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Spearman;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.SplitEvent;
import org.broadinstitute.genee.gui.SplitListener;
import org.broadinstitute.genee.gui.Splittable;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.broadinstitute.genee.math.adjust.LogScale;
import org.broadinstitute.genee.matrix.RowMajorArray2DDataset;

public class GapMapOptions
extends JPanel {
    private Splittable splittable;
    private JComboBox distanceMetricComboBox;
    private boolean drawingImage;
    private Image distributionImage;
    private JPanel distributionPanel;
    private JComboBox linkageComboBox;
    private JRadioButton log2Button;
    private JRadioButton noneButton;
    private JSlider totalSplitPixelsSlider;
    private SplitListener splitListener = new SplitListener(){

        @Override
        public void splitChanged(SplitEvent e) {
            GapMapOptions.this.updateImage();
        }
    };
    private boolean splitListenerAdded = false;
    private JCheckBox scaleSplitsToDistanceCheckBox;
    private JLabel distanceMetricLabel;
    private JLabel linkageMethodLabel;
    private JLabel totalSplitSizeLabel;
    private JLabel splitDistanceDistLabel;
    private JLabel transformDistLabel;

    public GapMapOptions(boolean row) {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (GapMapOptions.this.splittable != null && !GapMapOptions.this.splitListenerAdded) {
                    GapMapOptions.this.splittable.addSplitListener(GapMapOptions.this.splitListener);
                    GapMapOptions.this.splitListenerAdded = true;
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (GapMapOptions.this.splittable != null) {
                    GapMapOptions.this.splittable.removeSplitListener(GapMapOptions.this.splitListener);
                    GapMapOptions.this.splitListenerAdded = false;
                }
            }
        });
        FormBuilder formBuilder = new FormBuilder(this);
        formBuilder.addSeparator((row ? "Row" : "Column") + " Dendrogram Gap Map Settings");
        formBuilder.nextRow();
        this.scaleSplitsToDistanceCheckBox = new JCheckBox("Scale gaps to distance", false);
        this.scaleSplitsToDistanceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean scale = GapMapOptions.this.scaleSplitsToDistanceCheckBox.isSelected();
                GapMapOptions.this.setScaleSplitsEnabled(scale);
                GapMapOptions.this.splittable.setScaleSplitsToDistance(scale);
                GapMapOptions.this.splittable.split();
            }
        });
        formBuilder.addSpanned(this.scaleSplitsToDistanceCheckBox);
        formBuilder.nextRow();
        this.distanceMetricComboBox = UIUtil.createComboBox(new DefaultComboBoxModel<DistanceFunction>(new DistanceFunction[]{new CityBlock(), new Euclidean(), new Kendall(), new Correlation(), new Spearman()}));
        this.distanceMetricLabel = formBuilder.addLabel("Distance metric:");
        formBuilder.add(this.distanceMetricComboBox);
        this.distanceMetricComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GapMapOptions.this.splittable.setDistanceFunction((DistanceFunction)GapMapOptions.this.distanceMetricComboBox.getSelectedItem());
                GapMapOptions.this.splittable.split();
            }
        });
        this.linkageComboBox = UIUtil.createComboBox(new DefaultComboBoxModel<LinkageMethod>(new LinkageMethod[]{LinkageMethod.AVERAGE_LINKAGE, LinkageMethod.COMPLETE_LINKAGE, LinkageMethod.SINGLE_LINKAGE}));
        formBuilder.nextRow();
        this.linkageMethodLabel = formBuilder.addLabel("Method to calculate distance between clusters:");
        formBuilder.add(this.linkageComboBox);
        this.linkageComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GapMapOptions.this.splittable.setLinkageMethod((LinkageMethod)((Object)GapMapOptions.this.linkageComboBox.getSelectedItem()));
                GapMapOptions.this.splittable.split();
            }
        });
        this.totalSplitPixelsSlider = new JSlider();
        this.totalSplitPixelsSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                int value = GapMapOptions.this.totalSplitPixelsSlider.getValue();
                GapMapOptions.this.splittable.setSplitPixelSize(value);
                GapMapOptions.this.splittable.split();
            }
        });
        formBuilder.nextRow();
        this.totalSplitSizeLabel = formBuilder.addLabel("Total gap size:");
        formBuilder.add(this.totalSplitPixelsSlider);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.noneButton = new JRadioButton("None", true);
        this.log2Button = new JRadioButton("Log 2");
        buttonGroup1.add(this.noneButton);
        buttonGroup1.add(this.log2Button);
        formBuilder.nextRow();
        this.transformDistLabel = formBuilder.addLabel("Transform distance:");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == GapMapOptions.this.noneButton) {
                    GapMapOptions.this.splittable.setAdjustDistancesFunction(null);
                } else if (e.getSource() == GapMapOptions.this.log2Button) {
                    GapMapOptions.this.splittable.setAdjustDistancesFunction(new LogScale());
                }
                GapMapOptions.this.splittable.split();
            }
        };
        this.noneButton.addActionListener(l);
        this.log2Button.addActionListener(l);
        formBuilder.add(this.noneButton);
        formBuilder.nextSmallRow();
        formBuilder.add(this.log2Button);
        this.distributionPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.isEnabled()) {
                    if (GapMapOptions.this.distributionImage != null) {
                        g.drawImage(GapMapOptions.this.distributionImage, 0, 0, null);
                    } else if (GapMapOptions.this.drawingImage) {
                        String s = "Drawing...";
                        g.drawString(s, this.getWidth() / 2 - g.getFontMetrics().stringWidth(s) / 2, this.getHeight() / 2 + g.getFontMetrics().getAscent() / 2);
                    }
                }
            }
        };
        this.distributionPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.distributionPanel.setPreferredSize(new Dimension(100, 50));
        formBuilder.nextRow();
        this.splitDistanceDistLabel = formBuilder.addLabel("Gap distance distribution:");
        formBuilder.add(this.distributionPanel);
        this.setScaleSplitsEnabled(false);
    }

    public void configureValues() {
        this.distributionPanel.repaint();
        this.updateImage();
    }

    public void setSplittable(Splittable spittable) {
        if (this.splittable != null) {
            this.splittable.removeSplitListener(this.splitListener);
        }
        this.splittable = spittable;
        if (this.splittable != null) {
            this.splittable.addSplitListener(this.splitListener);
            this.splitListenerAdded = true;
            this.linkageComboBox.setSelectedItem((Object)spittable.getLinkageMethod());
            DistanceFunction distanceFunction = spittable.getDistanceFunction();
            int index = 0;
            int size = this.distanceMetricComboBox.getItemCount();
            for (int i = 0; i < size; ++i) {
                if (!this.distanceMetricComboBox.getItemAt(i).toString().equals(distanceFunction.toString())) continue;
                index = i;
                break;
            }
            this.distanceMetricComboBox.setSelectedIndex(index);
            this.updateImage();
            this.totalSplitPixelsSlider.setMinimum(10);
            this.totalSplitPixelsSlider.setMaximum(1000);
            this.totalSplitPixelsSlider.setValue(spittable.getSplitPixelSize());
        }
    }

    private Image createImage() {
        if (this.splittable == null) {
            return null;
        }
        float[][] array = new float[][]{this.splittable.getSplitDistances()};
        if (array[0] == null) {
            return null;
        }
        BufferedImage image = new BufferedImage(100, 50, 5);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2.setColor(Color.BLACK);
        WorldCoordinateMapper coordinateMapper = new WorldCoordinateMapper();
        DefaultHistogramChartSeries chartSeries = DefaultHistogramChartSeries.createInstance(new RowMajorArray2DDataset("", array), 10, Float.NaN, Float.NaN);
        DefaultXYChartDataset chartDataset = new DefaultXYChartDataset(chartSeries);
        float xmax = chartDataset.getXMax();
        float xmin = chartDataset.getXMin();
        if (xmin == xmax) {
            xmin -= 0.05f * xmin;
            xmax += 0.05f * xmax;
        }
        coordinateMapper.setXMax(xmax);
        coordinateMapper.setXMin(xmin);
        coordinateMapper.setYMax(chartDataset.getYMax());
        coordinateMapper.setYMin(chartDataset.getYMin());
        coordinateMapper.setXPixelScale(100.0f);
        coordinateMapper.setYPixelScale(50.0f);
        BarRenderer histogramPainter = new BarRenderer(false);
        histogramPainter.paint(chartDataset, 0, g2, coordinateMapper);
        g2.dispose();
        return image;
    }

    private void setScaleSplitsEnabled(boolean enabled) {
        this.distanceMetricLabel.setEnabled(enabled);
        this.linkageMethodLabel.setEnabled(enabled);
        this.linkageComboBox.setEnabled(enabled);
        this.totalSplitSizeLabel.setEnabled(enabled);
        this.totalSplitPixelsSlider.setEnabled(enabled);
        this.log2Button.setEnabled(enabled);
        this.noneButton.setEnabled(enabled);
        this.splitDistanceDistLabel.setEnabled(enabled);
        this.transformDistLabel.setEnabled(enabled);
        this.distanceMetricComboBox.setEnabled(enabled);
        this.distanceMetricLabel.setEnabled(enabled);
        this.distributionPanel.setEnabled(enabled);
    }

    private void updateImage() {
        if (this.drawingImage) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                GapMapOptions.this.drawingImage = true;
                GapMapOptions.this.distributionImage = GapMapOptions.this.createImage();
                GapMapOptions.this.distributionPanel.repaint();
                GapMapOptions.this.drawingImage = false;
            }
        }.start();
    }
}

