/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

public class Interpolation {
    private float[] fractions;
    private int[] start;
    private int[] end;
    private int index;
    private int[] cur;

    public Interpolation(int[] start, int[] end) {
        this(start, end, new float[]{0.25f, 0.5f, 0.75f, 1.0f});
    }

    public Interpolation(int[] start, int[] end, float[] fractions) {
        this.start = start;
        this.end = end;
        this.cur = new int[start.length];
        this.fractions = fractions;
    }

    public int[] getNextState() {
        this.interpolate();
        return this.cur;
    }

    public boolean isComplete() {
        return this.index >= this.fractions.length;
    }

    public float getFraction() {
        return this.fractions[this.index - 1];
    }

    public static void interpolate(float fraction, int[] start, int[] end, int[] cur) {
        int length = start.length;
        for (int i = 0; i < length; ++i) {
            cur[i] = Math.round((float)start[i] + fraction * (float)(end[i] - start[i]));
        }
    }

    public static float interpolate(float fraction, float start, float end) {
        return start + fraction * (end - start);
    }

    public static void interpolate(float fraction, float[] start, float[] end, float[] cur) {
        int length = start.length;
        for (int i = 0; i < length; ++i) {
            cur[i] = start[i] + fraction * (end[i] - start[i]);
        }
    }

    private void interpolate() {
        float fraction = this.fractions[this.index];
        int length = this.start.length;
        for (int i = 0; i < length; ++i) {
            this.cur[i] = Math.round((float)this.start[i] + fraction * (float)(this.end[i] - this.start[i]));
        }
        ++this.index;
    }
}

