/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jidesoft.swing.JideSplitPane;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class JideSplitPaneSynchronizer
implements PropertyChangeListener {
    private static final String DIVIDER_LOCATION = "dividerLocation";
    private static final String proportionsProperty = "proportions";
    private ArrayList<JideSplitPane> splitPanes = new ArrayList();
    private ArrayList<JideSplitPane> noListenSplitPanes = new ArrayList();
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public JideSplitPaneSynchronizer(JideSplitPane ... splitPanes) {
        for (JideSplitPane splitPane : splitPanes) {
            this.addSplitPane(splitPane);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void addSplitPane(JideSplitPane splitPane) {
        splitPane.addPropertyChangeListener(DIVIDER_LOCATION, (PropertyChangeListener)this);
        this.splitPanes.add(splitPane);
    }

    public void addSplitPaneNoListen(JideSplitPane splitPane) {
        this.noListenSplitPanes.add(splitPane);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JideSplitPane source = (JideSplitPane)e.getSource();
        for (JideSplitPane splitPane : this.splitPanes) {
            splitPane.removePropertyChangeListener(DIVIDER_LOCATION, (PropertyChangeListener)this);
        }
        int[] locations = source.getDividerLocations();
        for (JideSplitPane splitPane : this.splitPanes) {
            if (splitPane == source) continue;
            splitPane.setDividerLocations(locations);
        }
        for (JideSplitPane splitPane : this.noListenSplitPanes) {
            splitPane.setDividerLocations(locations);
        }
        for (JideSplitPane splitPane : this.splitPanes) {
            splitPane.addPropertyChangeListener(DIVIDER_LOCATION, (PropertyChangeListener)this);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    public void removeSplitPane(JideSplitPane splitPane) {
        splitPane.removePropertyChangeListener(DIVIDER_LOCATION, (PropertyChangeListener)this);
        this.splitPanes.remove(splitPane);
    }
}

