/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ProgressPanel;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public abstract class MovieControlPanel
extends JPanel {
    private JButton playPauseButton;
    private ProgressPanel progressPanel;
    private JSlider animationSpeedSlider;
    private TimingTarget internalTimingTarget;
    private int frameIndex = -1;
    private List<TimingTarget> timingTargets = new ArrayList<TimingTarget>();
    private int transitionTime = 1000;
    private Animator animator;
    private JComboBox availableFramesComboBox = UIUtil.createComboBox();
    private int minTransitionTime = 100;
    private int maxTransitionTime = 2000;
    private int nframes;

    public MovieControlPanel() {
        this.internalTimingTarget = new TimingTarget(){

            @Override
            public void begin() {
                MovieControlPanel.this.begin();
                this.repeat();
            }

            @Override
            public void end() {
                MovieControlPanel.this.end();
                MovieControlPanel.this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
            }

            @Override
            public void repeat() {
                MovieControlPanel.this.setFrame(MovieControlPanel.this.frameIndex + 1);
            }

            @Override
            public void timingEvent(float fraction) {
                MovieControlPanel.this.timingEvent(fraction);
            }
        };
        this.progressPanel = new ProgressPanel();
        this.playPauseButton = new JButton();
        this.playPauseButton.setPreferredSize(new Dimension(16, 16));
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
        this.playPauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MovieControlPanel.this.animator == null || !MovieControlPanel.this.animator.isRunning()) {
                    MovieControlPanel.this.start();
                } else {
                    MovieControlPanel.this.stop();
                }
            }
        });
        this.progressPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                MovieControlPanel.this.update(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.progressPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MovieControlPanel.this.update(e);
            }
        });
        this.setLayout((LayoutManager)new FormLayout("p:g", "p, 6px, p, 6px, p, p:g"));
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)new FormLayout("2px, left:p, 2px, p, 6px, p", "p, 2px, p"));
        p.add((Component)this.playPauseButton, cc.xy(2, 1));
        p.add((Component)this.progressPanel, cc.xy(4, 1));
        p.add((Component)this.availableFramesComboBox, cc.xy(6, 1));
        this.add((Component)p, cc.xy(1, 5));
        this.animationSpeedSlider = new JSlider(0, 1, 100, 50);
        this.animationSpeedSlider.setPaintLabels(true);
        this.animationSpeedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!MovieControlPanel.this.animationSpeedSlider.getValueIsAdjusting()) {
                    int value = MovieControlPanel.this.animationSpeedSlider.getValue();
                    WorldCoordinateMapper mapper = new WorldCoordinateMapper();
                    mapper.setLeftGutter(MovieControlPanel.this.minTransitionTime);
                    mapper.setRightGutter(0.0f);
                    mapper.setXMin(1.0f);
                    mapper.setXMax(100.0f);
                    mapper.setXPixelScale(MovieControlPanel.this.maxTransitionTime + 1);
                    MovieControlPanel.this.transitionTime = (int)mapper.xToPix(value);
                    if (MovieControlPanel.this.animator != null) {
                        MovieControlPanel.this.stop();
                        MovieControlPanel.this.animator.setDuration(MovieControlPanel.this.transitionTime);
                    }
                }
            }
        });
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(this.animationSpeedSlider.getMinimum(), new JLabel("Slow"));
        labelTable.put(this.animationSpeedSlider.getMaximum(), new JLabel("Fast"));
        this.animationSpeedSlider.setLabelTable(labelTable);
        JPanel tmp = new JPanel((LayoutManager)new FormLayout("p, 6px, p, 12px, p", "p:g"));
        tmp.add((Component)this.animationSpeedSlider, cc.xy(3, 1));
        this.add((Component)tmp, cc.xy(1, 6));
        this.setEnabled(false);
    }

    public void addTimingTarget(TimingTarget t) {
        this.timingTargets.add(t);
    }

    public abstract void begin();

    public abstract void end();

    public JComboBox getAvailableFramesComboBox() {
        return this.availableFramesComboBox;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.playPauseButton.setEnabled(enabled);
        this.progressPanel.setEnabled(enabled);
        this.animationSpeedSlider.setEnabled(enabled);
        if (!enabled) {
            this.progressPanel.setValue(0.0f);
        }
    }

    public void setFrame(int frameIndex) {
        if (frameIndex < this.nframes) {
            this.frameIndex = frameIndex;
            this.progressPanel.setValue(frameIndex);
            this.goToFrame(frameIndex);
        }
    }

    public void setNumberOfFrame(int frames) {
        this.stop();
        this.nframes = frames;
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
        this.progressPanel.setMaxValue(frames - 1);
        this.progressPanel.setValue(0.0f);
        this.frameIndex = -1;
    }

    public void start() {
        this.stop();
        if (this.frameIndex == this.nframes - 1) {
            this.frameIndex = -1;
        }
        int repeats = Math.max(1, this.nframes - this.frameIndex - 1);
        this.animator = new Animator(this.transitionTime, repeats, Animator.RepeatBehavior.LOOP, this.internalTimingTarget);
        for (TimingTarget t : this.timingTargets) {
            this.animator.addTarget(t);
        }
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11089.breakplayingblue_16.png"));
        this.animator.start();
    }

    public void stop() {
        this.playPauseButton.setIcon(IconManager.loadIcon("16x16/11062.playblue_16.png"));
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.stop();
        }
    }

    public abstract void timingEvent(float var1);

    protected abstract void goToFrame(int var1);

    private void update(MouseEvent e) {
        if (this.progressPanel.isEnabled()) {
            float frameIndex = this.progressPanel.getValue(e);
            int intFrame = Math.round(frameIndex);
            this.stop();
            this.setFrame(intFrame);
        }
    }
}

