/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.NullProgressNotifier;
import org.broadinstitute.genee.gui.ThreeListsComponent;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.FileInputParameter;
import org.broadinstitute.genee.heatmap.OpenPlateFiles;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.excel.ExcelReaderContentHandler;
import org.broadinstitute.genee.io.excel.HeaderContentHandler;
import org.broadinstitute.genee.io.matrix.dchip.AbstractSampleInfoFile;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.PlateUtil;

public class OpenPlateFilesWizard {
    private OpenPlateFiles.PlateHeatMapDisplay heatMapDisplay;
    private String[] plateFiles;
    private File[] wellMappingFiles = new File[0];
    private Set<String> mappingFileHeaders = new HashSet<String>();
    private List<String> heatMapRows;
    private List<String> heatMapColumns;
    private GENEEWindow dialog;
    private JButton okButton;
    private ActionListener okActionListener;
    private ActionListener finishedActionListener;
    private MatchWellMappingFileToPlateFile matchWellMappingFileToPlateFile;

    public OpenPlateFilesWizard(String title, String[] plateFiles) {
        this.plateFiles = plateFiles;
        this.dialog = Application.createDialog("Import " + title + (plateFiles.length == 1 ? " File" : " Files"));
    }

    public Map<String, AbstractSampleInfoFile> createFileToSampleInfo() {
        return this.matchWellMappingFileToPlateFile.createFileToSampleInfo();
    }

    public OpenPlateFiles.PlateHeatMapDisplay getDisplay() {
        return this.heatMapDisplay;
    }

    public List<String> getHeatMapColumns() {
        return this.heatMapColumns;
    }

    public OpenPlateFiles.PlateHeatMapDisplay getHeatMapDisplay() {
        return this.heatMapDisplay;
    }

    public List<String> getHeatMapRows() {
        return this.heatMapRows;
    }

    public String[] getPlateFiles() {
        return this.plateFiles;
    }

    public void showGui(ActionListener finishedActionListener) {
        this.finishedActionListener = finishedActionListener;
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenPlateFilesWizard.this.okActionListener.actionPerformed(e);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenPlateFilesWizard.this.dialog.dispose();
            }
        });
        this.dialog.getContentPane().add((Component)UIUtil.buildOKCancelBar(this.okButton, cancelButton), "South");
        this.dialog.getRootPane().setDefaultButton(this.okButton);
        new OrganizeHeatMapAndMappings();
    }

    static /* synthetic */ File[] access$402(OpenPlateFilesWizard x0, File[] x1) {
        x0.wellMappingFiles = x1;
        return x1;
    }

    private class MatchWellMappingFileToPlateFile {
        private JComboBox[] mappingFileComboBox;
        private JComboBox[] worksheetComboBox;
        private JPanel panel = new JPanel();

        public MatchWellMappingFileToPlateFile() {
            this.panel.setLayout((LayoutManager)new FormLayout("p, 8px, p, 8px, p", UIUtil.createRowStringForFormLayout(OpenPlateFilesWizard.this.plateFiles.length + 1)));
            OpenPlateFilesWizard.this.okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenPlateFilesWizard.this.mappingFileHeaders = MatchWellMappingFileToPlateFile.this.getMappingFileHeaders();
                }
            };
            this.rebuild();
            OpenPlateFilesWizard.this.dialog.getContentPane().add(this.panel);
            OpenPlateFilesWizard.this.dialog.pack();
        }

        public Map<String, AbstractSampleInfoFile> createFileToSampleInfo() {
            HashMap<String, AbstractSampleInfoFile> map = new HashMap<String, AbstractSampleInfoFile>();
            HashMap<String, AbstractSampleInfoFile> cache = new HashMap<String, AbstractSampleInfoFile>();
            if (this.mappingFileComboBox == null) {
                return map;
            }
            for (int i = 0; i < this.mappingFileComboBox.length; ++i) {
                File mappingFile = (File)this.mappingFileComboBox[i].getSelectedItem();
                String wk = (String)this.worksheetComboBox[i].getSelectedItem();
                AbstractSampleInfoFile sampleInfo = (AbstractSampleInfoFile)cache.get(mappingFile + wk);
                if (sampleInfo == null) {
                    try {
                        sampleInfo = PlateUtil.createPlateAndWellSampleInfoFile(new NullProgressNotifier(), IOUtil.getPath(mappingFile), wk);
                        cache.put(mappingFile + wk, sampleInfo);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                map.put(OpenPlateFilesWizard.this.plateFiles[i], sampleInfo);
            }
            return map;
        }

        private Set<String> getMappingFileHeaders() {
            HashSet<String> fields = new HashSet<String>();
            HashMap<String, String[]> cache = new HashMap<String, String[]>();
            for (int i = 0; i < this.mappingFileComboBox.length; ++i) {
                File mappingFile = (File)this.mappingFileComboBox[i].getSelectedItem();
                String wk = (String)this.worksheetComboBox[i].getSelectedItem();
                String[] names = (String[])cache.get(mappingFile + wk);
                if (names == null) {
                    try {
                        names = ((HeaderContentHandler)new ExcelReader(IOUtil.getPath(mappingFile), wk, (ExcelReaderContentHandler)new HeaderContentHandler()).getContentHandler()).getColumnNames();
                        cache.put(mappingFile + wk, names);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                fields.addAll(Arrays.asList(names));
            }
            return fields;
        }

        private void rebuild() {
            this.panel.removeAll();
            CellConstraints cc = new CellConstraints();
            JLabel l = new JLabel("Plate File");
            l.setFont(l.getFont().deriveFont(1));
            this.panel.add((Component)l, cc.xy(1, 1));
            l = new JLabel("Well Mapping File");
            l.setFont(l.getFont().deriveFont(1));
            this.panel.add((Component)l, cc.xy(3, 1));
            l = new JLabel("Worksheet");
            l.setFont(l.getFont().deriveFont(1));
            this.panel.add((Component)l, cc.xy(5, 1));
            this.mappingFileComboBox = new JComboBox[OpenPlateFilesWizard.this.plateFiles.length];
            this.worksheetComboBox = new JComboBox[OpenPlateFilesWizard.this.plateFiles.length];
            final HashMap<File, String[]> fileToWorksheets = new HashMap<File, String[]>();
            for (File mappingFile : OpenPlateFilesWizard.this.wellMappingFiles) {
                String[] sheetNames = ExcelReader.getSheetNames(IOUtil.getPath(mappingFile));
                fileToWorksheets.put(mappingFile, sheetNames);
            }
            int i = 0;
            int row = 3;
            while (i < OpenPlateFilesWizard.this.plateFiles.length) {
                this.panel.add((Component)new JLabel(new File(OpenPlateFilesWizard.this.plateFiles[i]).getName()), cc.xy(1, row));
                this.mappingFileComboBox[i] = UIUtil.createComboBox(OpenPlateFilesWizard.this.wellMappingFiles);
                final int index = i;
                this.worksheetComboBox[i] = UIUtil.createComboBox();
                this.panel.add((Component)this.mappingFileComboBox[i], cc.xy(3, row));
                this.panel.add((Component)this.worksheetComboBox[i], cc.xy(5, row));
                this.mappingFileComboBox[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MatchWellMappingFileToPlateFile.this.worksheetComboBox[index].removeAllItems();
                        File selection = (File)MatchWellMappingFileToPlateFile.this.mappingFileComboBox[index].getSelectedItem();
                        String[] sheets = (String[])fileToWorksheets.get(selection);
                        MatchWellMappingFileToPlateFile.this.worksheetComboBox[index].setEnabled(sheets.length > 1);
                        for (String sheet : sheets) {
                            MatchWellMappingFileToPlateFile.this.worksheetComboBox[index].addItem(sheet);
                        }
                    }
                });
                if (this.mappingFileComboBox[i].getItemCount() > 0) {
                    this.mappingFileComboBox[i].setSelectedIndex(0);
                }
                ++i;
                row += 2;
            }
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    private class HeatMapLayout {
        private ThreeListsComponent labeledThreeListsPanel = new ThreeListsComponent("Heat map rows", "", "Heat map columns", false);

        public HeatMapLayout() {
            this.labeledThreeListsPanel.setLeftListName("heat map rows");
            this.labeledThreeListsPanel.setRightListName("heat map columns");
            OpenPlateFilesWizard.this.okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenPlateFilesWizard.this.heatMapRows = HeatMapLayout.this.labeledThreeListsPanel.getLeftItems();
                    OpenPlateFilesWizard.this.heatMapColumns = HeatMapLayout.this.labeledThreeListsPanel.getRightItems();
                }
            };
            this.labeledThreeListsPanel.setItems(new ArrayList<String>(), new ArrayList<String>(OpenPlateFilesWizard.this.mappingFileHeaders), new ArrayList<String>());
        }
    }

    public class OrganizeHeatMapAndMappings {
        JRadioButton mapWells;
        JRadioButton byColumn;
        JRadioButton byRow;
        JRadioButton byPlate;
        FileInputParameter wellMappingFileInputPanel;
        JLabel wellMappingLabel;

        public OrganizeHeatMapAndMappings() {
            FormBuilder formBuilder = new FormBuilder();
            formBuilder.nextRow();
            formBuilder.addLabel("Organize heat map:");
            ButtonGroupHelper bg = new ButtonGroupHelper();
            this.byColumn = bg.createRadioButton("by plate, column by column", true);
            this.byRow = bg.createRadioButton("by plate, row by row");
            this.byPlate = bg.createRadioButton("in plate format");
            this.mapWells = bg.createRadioButton("by well contents");
            bg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenPlateFilesWizard.this.heatMapDisplay = OrganizeHeatMapAndMappings.this.getHeatMapDisplay();
                    OrganizeHeatMapAndMappings.this.wellMappingLabel.setEnabled(OpenPlateFilesWizard.this.heatMapDisplay.equals((Object)OpenPlateFiles.PlateHeatMapDisplay.WELL_CONTENTS));
                    UIUtil.setChildrenEnabledRecursively(OrganizeHeatMapAndMappings.this.wellMappingFileInputPanel, OpenPlateFilesWizard.this.heatMapDisplay.equals((Object)OpenPlateFiles.PlateHeatMapDisplay.WELL_CONTENTS));
                }
            });
            OpenPlateFilesWizard.this.heatMapDisplay = this.getHeatMapDisplay();
            formBuilder.add(this.mapWells);
            formBuilder.nextSmallRow();
            formBuilder.add(this.byColumn);
            formBuilder.nextSmallRow();
            formBuilder.add(this.byRow);
            formBuilder.nextSmallRow();
            formBuilder.add(this.byPlate);
            formBuilder.nextRow();
            this.wellMappingLabel = formBuilder.addLabel("Well Mapping File:");
            this.wellMappingFileInputPanel = new FileInputParameter(null, OpenPlateFilesWizard.this.plateFiles.length == 0 ? FileInputParameter.OPEN_FILE : FileInputParameter.OPEN_FILES);
            formBuilder.add(this.wellMappingFileInputPanel);
            this.wellMappingLabel.setEnabled(false);
            UIUtil.setChildrenEnabledRecursively(this.wellMappingFileInputPanel, OpenPlateFilesWizard.this.heatMapDisplay.equals((Object)OpenPlateFiles.PlateHeatMapDisplay.WELL_CONTENTS));
            this.wellMappingFileInputPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenPlateFilesWizard.access$402(OpenPlateFilesWizard.this, OrganizeHeatMapAndMappings.this.wellMappingFileInputPanel.getFiles());
                    OrganizeHeatMapAndMappings.this.setEnabled();
                }
            });
            OpenPlateFilesWizard.this.okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OpenPlateFilesWizard.this.heatMapDisplay.equals((Object)OpenPlateFiles.PlateHeatMapDisplay.WELL_CONTENTS)) {
                        OpenPlateFilesWizard.this.matchWellMappingFileToPlateFile = new MatchWellMappingFileToPlateFile();
                    } else {
                        OpenPlateFilesWizard.this.dialog.dispose();
                        OpenPlateFilesWizard.this.finishedActionListener.actionPerformed(e);
                    }
                }
            };
            this.setEnabled();
            OpenPlateFilesWizard.this.dialog.getContentPane().add(formBuilder.getPanel());
            OpenPlateFilesWizard.this.dialog.pack();
            OpenPlateFilesWizard.this.dialog.setVisible(true);
        }

        public OpenPlateFiles.PlateHeatMapDisplay getHeatMapDisplay() {
            if (this.mapWells.isSelected()) {
                return OpenPlateFiles.PlateHeatMapDisplay.WELL_CONTENTS;
            }
            if (this.byColumn.isSelected()) {
                return OpenPlateFiles.PlateHeatMapDisplay.PLATE_COLUMN;
            }
            if (this.byRow.isSelected()) {
                return OpenPlateFiles.PlateHeatMapDisplay.PLATE_ROW;
            }
            return OpenPlateFiles.PlateHeatMapDisplay.PLATE_LAYOUT;
        }

        private void setEnabled() {
            if (OpenPlateFilesWizard.this.wellMappingFiles.length > 0) {
                OpenPlateFilesWizard.this.okButton.setEnabled(true);
            } else if (OpenPlateFilesWizard.this.heatMapDisplay.equals((Object)OpenPlateFiles.PlateHeatMapDisplay.WELL_CONTENTS)) {
                OpenPlateFilesWizard.this.okButton.setEnabled(false);
            } else {
                OpenPlateFilesWizard.this.okButton.setEnabled(true);
            }
        }
    }
}

