/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.IconManager;

public class ProgressDialog {
    private GENEEWindow dialog;
    private JLabel label;
    private JPanel panel;
    private JProgressBar progressBar;
    private JButton stopButton;

    public ProgressDialog(String title, boolean blocking) {
        this(title, blocking, true);
    }

    public ProgressDialog(String title, boolean blocking, boolean showStopButton) {
        this(title, blocking, showStopButton, Application.getWindowManager().createInputWindow(title, null));
    }

    public ProgressDialog(String title, boolean blocking, boolean showStopButton, GENEEWindow dialog) {
        this.dialog = dialog;
        if (dialog instanceof Dialog) {
            ((Dialog)((Object)dialog)).setModal(blocking);
            ((Dialog)((Object)dialog)).setResizable(false);
        }
        if (dialog instanceof JDialog) {
            ((JDialog)((Object)dialog)).setDefaultCloseOperation(0);
        }
        this.panel = new JPanel((LayoutManager)new FormLayout("p, 4px, p, 4px, p", "p"));
        this.label = new JLabel("", IconManager.loadIcon("heatmap-32.gif"), 2);
        this.panel.add((Component)this.label, CC.xy((int)1, (int)1));
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.panel.add((Component)this.progressBar, CC.xy((int)3, (int)1));
        this.stopButton = new JButton("Stop");
        if (showStopButton) {
            this.panel.add((Component)this.stopButton, CC.xy((int)5, (int)1));
        }
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this.panel, "North");
        dialog.pack();
    }

    public void addStopActionListener(ActionListener l) {
        this.stopButton.addActionListener(l);
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public void setMessage(String message) {
        this.progressBar.setString(message);
    }

    public void setPercentComplete(float percent) {
    }

    public void setTitle(String title) {
        ((Dialog)((Object)this.dialog)).setTitle(title);
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
    }
}

