/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import javax.swing.JTextField;
import org.broadinstitute.genee.gui.TextComponentListener;

public abstract class TimerTextField
extends JTextField {
    public static final int DELAY_LONG = 500;
    public static final int DELAY_SHORT = 200;
    public static final int DELAY_VERY_LONG = 1000;
    private String last;
    private TextComponentListener textFieldListener;

    public TimerTextField() {
        this("");
    }

    public TimerTextField(int delay) {
        this("", delay);
    }

    public TimerTextField(String text) {
        this(text, 200);
    }

    public TimerTextField(String text, int delay) {
        super(text, 20);
        this.textFieldListener = new TextComponentListener(this, delay){

            @Override
            protected void update() {
                TimerTextField.this._update();
            }
        };
    }

    public void setTextNoUpdate(String text) {
        this.textFieldListener.setTextNoUpdate(text);
    }

    public abstract void update();

    private void _update() {
        String text = this.getText();
        if (text != null) {
            text = text.trim();
        }
        if (this.last == null || !this.last.equals(text)) {
            this.last = text;
            this.update();
        }
    }
}

