/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class TransferableObject<T>
implements Transferable {
    private static DataFlavor localObjectMimeType;
    private T data;
    private DataFlavor[] flavors;

    public TransferableObject(T data) {
        this.data = data;
        this.flavors = new DataFlavor[]{localObjectMimeType};
    }

    public T getData() {
        return this.data;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this.data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : this.flavors) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            localObjectMimeType = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException e) {
            System.err.println("javaJVMLocalObjectMimeType not found");
        }
    }
}

