/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.Zoomable;

public class ZoomOutAction
extends AbstractAction {
    public static final KeyStroke ZOOM_OUT_KEY_STROKE = KeyStroke.getKeyStroke(45, UIUtil.getMenuShortcutKeyMask());
    private Zoomable zoomable;

    public ZoomOutAction() {
        this("Zoom Out", "Zoom out");
    }

    public ZoomOutAction(String text, String description) {
        super(text);
        this.putValue("ShortDescription", description);
        this.putValue("AcceleratorKey", ZOOM_OUT_KEY_STROKE);
        this.setEnabled(false);
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/26688.sc_zoomminus.png"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.zoomable.zoomOut();
    }

    public Zoomable getZoomable() {
        return this.zoomable;
    }

    public void setZoomable(Zoomable zoomable) {
        this.zoomable = zoomable;
        this.setEnabled(zoomable != null);
    }
}

