/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gsea.ChipFileInput;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.actions.AnnotateAction;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.AddToMetadataContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.VectorUtil;

public class AnnotateRowsFromWebsite
extends AbstractAction {
    private GENEEWindow dialog;
    private ChipFileInput chipFileInput;

    public AnnotateRowsFromWebsite() {
        super("Annotate Rows From FTP site\u2026");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        if (this.dialog == null) {
            this.chipFileInput = new ChipFileInput(false);
            this.chipFileInput.init();
            try {
                this.dialog = Application.createDialog("Select Chip");
                JPanel okCancelPanel = UIUtil.buildOKCancelBar(this.dialog, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnnotateRowsFromWebsite.this.dialog.setVisible(false);
                        final Project project = Application.getProject();
                        final Dataset fullDataset = project.getOriginalDataset();
                        final String datasetMetadataName = AnnotateAction.getDatasetMetadataNameToMatchOn(fullDataset.getRowMetadata(), null);
                        if (datasetMetadataName == null) {
                            return;
                        }
                        final File file = AnnotateRowsFromWebsite.this.chipFileInput.getParameterValue();
                        if (file != null) {
                            new BackgroundTask<Void>("Load Annotations"){

                                @Override
                                protected Void doInBackground() throws Exception {
                                    try {
                                        Map<String, TIntArrayList> keyToIndices = VectorUtil.createStringValueToIndicesMap(fullDataset.getRowMetadata().get(datasetMetadataName));
                                        new ExcelReader(IOUtil.getPath(file), new AddToMetadataContentHandler(fullDataset.getRowMetadata(), null, null, keyToIndices, true));
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "Unable to connect to website");
                                    }
                                    UIUtil.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            project.fireRowMetadataChanged();
                                        }
                                    });
                                    return null;
                                }
                            }.execute();
                        }
                    }
                });
                this.dialog.getContentPane().add(this.chipFileInput.getJComponent());
                this.dialog.getContentPane().add((Component)okCancelPanel, "South");
                this.dialog.pack();
                this.dialog.setVisible(true);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            this.dialog.setVisible(true);
        }
    }
}

