/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.clustering.cc.ClusteringAlgorithm;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.CityBlock;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Correlation;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.DistanceFunction;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Euclidean;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Kendall;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.Spearman;
import org.broadinstitute.genee.clustering.hierarchical.algorithm.metrics.molecule.AbstractMoleculeDistanceFunction;
import org.broadinstitute.genee.compound.MoleculeUtil;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.BasicMapEntry;
import org.broadinstitute.genee.gui.parameters.CheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.DefaultInputLabel;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataModel;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.Vector;

public class ClusteringActionUtil {
    public static final BasicMapEntry<DistanceFunction> CITY_BLOCK = new BasicMapEntry<CityBlock>("City-block distance", new CityBlock());
    public static final BasicMapEntry<DistanceFunction> EUCLIDEAN = new BasicMapEntry<Euclidean>("Euclidean distance", new Euclidean());
    public static final BasicMapEntry<DistanceFunction> KENDALLS_TAU = new BasicMapEntry<Kendall>("Kendall's tau", new Kendall());
    public static final BasicMapEntry<DistanceFunction> PEARSON = new BasicMapEntry<Correlation>("One minus pearson correlation", new Correlation());
    public static final BasicMapEntry<DistanceFunction> SPEARMAN = new BasicMapEntry<Spearman>("One minus spearman rank correlation", new Spearman());
    public static final BasicMapEntry<DistanceFunction>[] DISTANCE_METRICS = new BasicMapEntry[]{CITY_BLOCK, EUCLIDEAN, KENDALLS_TAU, PEARSON, SPEARMAN};

    private ClusteringActionUtil() {
    }

    public static void clusterRows(ClusteringAlgorithm c, Dataset dataset, int[] numberOfClusters, Map<Identifier, TIntArrayList> groupByToRowIndices) {
        for (int k : numberOfClusters) {
            String name = k + " Clusters";
            MetadataUtil.addColumnVector(dataset.getRowMetadata(), name, String.class);
            c.setNumberOfClusters(k);
            if (groupByToRowIndices == null) {
                c.setDataset(dataset);
                c.execute();
                Vector v = dataset.getRowMetadata().get(name);
                for (int i = 0; i < k; ++i) {
                    int[] indexes;
                    for (int idx : indexes = c.getIndices(i)) {
                        v.setValue(idx, String.valueOf(i));
                    }
                }
                continue;
            }
            for (Identifier group : groupByToRowIndices.keySet()) {
                String groupString = Formatter.toString(group);
                TIntArrayList indices = groupByToRowIndices.get(group);
                Dataset slice = DatasetUtil.sliceView(dataset, indices.toArray(), null);
                c.setDataset(slice);
                c.execute();
                Vector v = slice.getRowMetadata().get(name);
                for (int i = 0; i < k; ++i) {
                    int[] indexes;
                    for (int idx : indexes = c.getIndices(i)) {
                        v.setValue(idx, groupString + "_" + String.valueOf(i));
                    }
                }
            }
        }
    }

    public static CheckBoxListParameter addClusterOptionsParameters(final AbstractInputAction action, String groupByEnabledName, String groupByName, String clusterSelectedOnlyName, String clusterInSpaceOfName, final String distanceParameterName, final JCheckBox clusteringEnabledCheckBox, final String ... additionalParameters) {
        final CheckBoxParameter clusterSelectedOnlyCheckBox = new CheckBoxParameter(clusterSelectedOnlyName, false);
        action.addParameter(new HiddenInputLabel(clusterSelectedOnlyName), clusterSelectedOnlyCheckBox, false);
        final CheckBoxParameter clusterInSpaceOfCheckBox = new CheckBoxParameter(clusterInSpaceOfName, false);
        action.addParameter(new HiddenInputLabel(clusterInSpaceOfName), clusterInSpaceOfCheckBox, false);
        final CheckBoxParameter groupByCheckBox = new CheckBoxParameter(groupByEnabledName);
        action.addParameter(new HiddenInputLabel(groupByEnabledName), groupByCheckBox, false);
        final CheckBoxListParameter checkBoxList = new CheckBoxListParameter();
        final DefaultInputLabel groupByLabel = new DefaultInputLabel(groupByName);
        action.addParameter(groupByLabel, checkBoxList, false);
        groupByLabel.setEnabled(false);
        clusteringEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.updateEnabled();
            }

            private void updateEnabled() {
                boolean cluster = clusteringEnabledCheckBox.isSelected();
                groupByCheckBox.setEnabled(cluster);
                action.getInputPanelBuilder().setEnabled(distanceParameterName, cluster);
                groupByLabel.setEnabled(groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
                clusterSelectedOnlyCheckBox.setEnabled(groupByCheckBox.isEnabled());
                clusterInSpaceOfCheckBox.setEnabled(groupByCheckBox.isEnabled());
                UIUtil.setChildrenEnabledRecursively(checkBoxList.getJComponent(), groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
                checkBoxList.getJComponent().setEnabled(groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
                if (additionalParameters != null) {
                    for (String name : additionalParameters) {
                        action.getInputPanelBuilder().setEnabled(name, cluster);
                    }
                }
            }
        });
        if (additionalParameters != null) {
            for (String name : additionalParameters) {
                action.getInputPanelBuilder().setEnabled(name, clusteringEnabledCheckBox.isSelected());
            }
        }
        groupByCheckBox.setEnabled(clusteringEnabledCheckBox.isSelected());
        action.getInputPanelBuilder().setEnabled(distanceParameterName, clusteringEnabledCheckBox.isSelected());
        groupByLabel.setEnabled(groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
        clusterSelectedOnlyCheckBox.setEnabled(groupByCheckBox.isEnabled());
        clusterInSpaceOfCheckBox.setEnabled(groupByCheckBox.isEnabled());
        checkBoxList.getJComponent().setEnabled(groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
        UIUtil.setChildrenEnabledRecursively(checkBoxList.getJComponent(), groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
        clusterSelectedOnlyCheckBox.setEnabled(clusteringEnabledCheckBox.isSelected());
        groupByCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                checkBoxList.getJComponent().setEnabled(groupByCheckBox.isSelected());
                UIUtil.setChildrenEnabledRecursively(checkBoxList.getJComponent(), groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
                groupByLabel.setEnabled(groupByCheckBox.isSelected());
            }
        });
        groupByCheckBox.setEnabled(clusterSelectedOnlyCheckBox.isEnabled());
        UIUtil.setChildrenEnabledRecursively(checkBoxList.getJComponent(), groupByCheckBox.isEnabled() && groupByCheckBox.isSelected());
        checkBoxList.getJComponent().setEnabled(false);
        return checkBoxList;
    }

    public static void addMoleculeMetrics(JComboBox cb, MetadataModel model) {
        List<String> rowMetadataNames = MetadataUtil.getColumnNames(model, MoleculeUtil.getMoleculeClass());
        if (rowMetadataNames.size() > 0) {
            for (int i = 0; i < cb.getItemCount(); ++i) {
                Object item = cb.getItemAt(i);
                if (!(item instanceof BasicMapEntry) || !(((BasicMapEntry)item).getValue() instanceof AbstractMoleculeDistanceFunction)) continue;
                cb.removeItemAt(i);
                --i;
            }
            List<AbstractMoleculeDistanceFunction> functions = AbstractMoleculeDistanceFunction.getFunctions(rowMetadataNames.get(0));
            for (AbstractMoleculeDistanceFunction f : functions) {
                cb.addItem(new BasicMapEntry<AbstractMoleculeDistanceFunction>(f.toString(), f));
            }
        }
    }

    public static ComponentCustomizer createComponentCustomizer(final Map<Identifier, TIntArrayList> groupByToRowIndices, final Map<Identifier, TIntArrayList> groupByToColumnIndices) {
        return new ComponentCustomizer(){

            @Override
            public void customize(Component c) {
                TIntArrayList indicesForGroup;
                int index;
                float[] spaces;
                HeatMapPanel p = (HeatMapPanel)c;
                if (groupByToRowIndices != null) {
                    SizesAndPositions rowSizes = p.getRowSizesAndPositions();
                    spaces = new float[rowSizes.getLength()];
                    index = 0;
                    for (Identifier group : groupByToRowIndices.keySet()) {
                        indicesForGroup = (TIntArrayList)groupByToRowIndices.get(group);
                        spaces[(index += indicesForGroup.size()) - 1] = 10.0f;
                    }
                    rowSizes.setSpaceSizes(spaces);
                }
                if (groupByToColumnIndices != null) {
                    SizesAndPositions columnSizes = p.getColumnSizesAndPositions();
                    spaces = new float[columnSizes.getLength()];
                    index = 0;
                    for (Identifier group : groupByToColumnIndices.keySet()) {
                        indicesForGroup = (TIntArrayList)groupByToColumnIndices.get(group);
                        spaces[(index += indicesForGroup.size()) - 1] = 10.0f;
                    }
                    columnSizes.setSpaceSizes(spaces);
                    columnSizes.notifyListeners(2);
                }
            }

            @Override
            public boolean inherits() {
                return false;
            }
        };
    }
}

