/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.actions.CollapseDatasetUI;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.math.stat.CollapseDataset;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class CollapseDatasetAction
extends AbstractInputAction {
    private CollapseDatasetUI ui = new CollapseDatasetUI(this);

    public CollapseDatasetAction() {
        super("Collapse");
    }

    @Override
    public boolean beforeWindowShown() {
        this.ui.updateChoices();
        return true;
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        Dataset dataset = (Dataset)map.get("dataset");
        Project project = (Project)map.get("project");
        CollapseDataset c = CollapseDatasetUI.getCollapseDataset(map);
        boolean collapseRows = "rows".equalsIgnoreCase((String)map.get("Collapse"));
        c.setDataset(collapseRows ? dataset : DatasetUtil.transposeView(dataset));
        History history = this.getHistory(map);
        Dataset d = c.execute();
        d = collapseRows ? d : DatasetUtil.transposeView(d);
        DefaultProject newProject = new DefaultProject(d, project);
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode(newProject, history);
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

