/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class NewHeatMapAction
extends AbstractInputAction {
    public NewHeatMapAction() {
        super("New Heat Map");
        this.setShowSelectedAndMasked(true);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, UIUtil.getMenuShortcutKeyMask()));
        this.putValue("ShortDescription", "Create a new heat map");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/16172.newdoc.png"));
        this.setRunInBackground(false);
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        Dataset dataset = (Dataset)map.get("dataset");
        Project project = (Project)map.get("project");
        History history = this.getHistory(map);
        DefaultProject newProject = new DefaultProject(DatasetUtil.shallowCopy(dataset), project);
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode(newProject, history);
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

