/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.ComponentCustomizer;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.ViewableGENEETreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.gui.actions.SynergyCalculator;
import org.broadinstitute.genee.gui.actions.SynergyCompoundHeatMaps;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.gui.parameters.ComboBoxParameter;
import org.broadinstitute.genee.gui.parameters.HiddenInputLabel;
import org.broadinstitute.genee.gui.parameters.MetadataCheckBoxListParameter;
import org.broadinstitute.genee.gui.parameters.MetadataComboBoxInputParameter;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.GENEEResultNodeGroup;
import org.broadinstitute.genee.heatmap.HeatMapColorSchemeOptionsPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.HeatMapToolBar;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SortKeys;
import org.broadinstitute.genee.heatmap.SortOrder;
import org.broadinstitute.genee.math.stat.function.Mean;
import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;
import org.broadinstitute.genee.matrix.Dataset;

public class SynergyAction
extends AbstractInputAction {
    private static final String COMPOUND1_FIELD = "Compound one field";
    private static final String COMPOUND2_FIELD = "Compound two field";
    private static final String CONC1_FIELD = "Concentration one field";
    private static final String CONC2_FIELD = "Concentration two field";
    private static final String COMPUTE_SYNERGY = "Additional fields that identify a treament";
    private static final String COMPUTE_SYNERGY_DESC = "In addition to the compound and concentration fields, additional fields that uniquely identify a treatment combination.";
    private static final String[] INPUT_VALUE_OPTIONS = new String[]{"Inhibition (0-100)", "% Inhibition (0-1)", "Viability (0-100)", "% Viability (0-1)"};
    private static final String BLISS_MODEL = "Bliss independence model";
    private static final String INPUT_VALUES = "Input values are";

    public SynergyAction() {
        super("Synergy");
        this.addParameter(INPUT_VALUES, new ComboBoxParameter((Object[])INPUT_VALUE_OPTIONS, 2), true);
        this.addParameter(COMPOUND1_FIELD, new MetadataComboBoxInputParameter(true), true);
        this.addParameter(COMPOUND2_FIELD, new MetadataComboBoxInputParameter(true), true);
        this.addParameter(CONC1_FIELD, new MetadataComboBoxInputParameter(true, Number.class), true);
        this.addParameter(CONC2_FIELD, new MetadataComboBoxInputParameter(true, Number.class), true);
        this.addParameter(COMPUTE_SYNERGY, new MetadataCheckBoxListParameter(true, null), COMPUTE_SYNERGY_DESC, true);
        this.addParameter(new HiddenInputLabel(BLISS_MODEL), new CheckBoxParameter(BLISS_MODEL), true);
    }

    @Override
    public boolean beforeWindowShown() {
        Project p = Application.getProject();
        if (p != null) {
            this.getInputPanelBuilder().getInputParameter(COMPOUND1_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(COMPOUND2_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(CONC1_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(CONC2_FIELD).init(p);
            this.getInputPanelBuilder().getInputParameter(COMPUTE_SYNERGY).init(p);
        }
        return true;
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        History history = this.getHistory(map);
        Dataset filteredSortedDataset = (Dataset)map.get("dataset");
        String concentration1Field = (String)map.get(CONC1_FIELD);
        String concentration2Field = (String)map.get(CONC2_FIELD);
        String compound1Field = (String)map.get(COMPOUND1_FIELD);
        String compound2Field = (String)map.get(COMPOUND2_FIELD);
        boolean bliss = (Boolean)map.get(BLISS_MODEL);
        HashSet<Object> additionalFieldsSet = new HashSet<Object>(Arrays.asList((Object[])map.get(COMPUTE_SYNERGY)));
        additionalFieldsSet.remove(concentration1Field);
        additionalFieldsSet.remove(concentration2Field);
        additionalFieldsSet.remove(compound1Field);
        additionalFieldsSet.remove(compound2Field);
        String[] additionalFields = additionalFieldsSet.toArray(new String[0]);
        String inputValue = (String)map.get(INPUT_VALUES);
        UnivariateFloatFunction transformation = inputValue.equals(INPUT_VALUE_OPTIONS[2]) ? new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return (100.0f - x) / 100.0f;
            }
        } : (inputValue.equals(INPUT_VALUE_OPTIONS[3]) ? new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return 100.0f - x;
            }
        } : (inputValue.equals(INPUT_VALUE_OPTIONS[0]) ? new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return x / 100.0f;
            }
        } : new UnivariateFloatFunction(){

            @Override
            public float evaluate(float x) {
                return x;
            }
        }));
        SynergyCalculator calc = new SynergyCalculator(filteredSortedDataset, concentration1Field, concentration2Field, compound1Field, compound2Field, bliss, additionalFields, transformation);
        calc.execute();
        DefaultProject newSynergyProject = new DefaultProject(calc.getSynergy(), (Project)map.get("project"));
        DefaultProject viabilityProject = new DefaultProject(calc.getViability());
        ViewableGENEETreeNode activeNode = (ViewableGENEETreeNode)map.get("active.node");
        SynergyCompoundHeatMaps syn = new SynergyCompoundHeatMaps(concentration1Field, concentration2Field, compound1Field, compound2Field, additionalFields, newSynergyProject, viabilityProject);
        SynergyCustomizer synergyCustomizer = new SynergyCustomizer(syn);
        ProjectGENEEResultTreeNode synergyNode = new ProjectGENEEResultTreeNode((Project)newSynergyProject, history, synergyCustomizer);
        ProjectGENEEResultTreeNode viabilityNode = new ProjectGENEEResultTreeNode(viabilityProject, history);
        HeatMapPanel synergyHeatMapPanel = (HeatMapPanel)synergyNode.getDisplayInfo().getComponent();
        HeatMapPanel viabilityHeatMapPanel = (HeatMapPanel)activeNode.getDisplayInfo().getComponent();
        synergyCustomizer.synergyHeatMapPanel = synergyHeatMapPanel;
        synergyCustomizer.viabilityHeatMapPanel = viabilityHeatMapPanel;
        GENEEResultNodeGroup group = new GENEEResultNodeGroup();
        synergyNode.setGroup(group);
        group.setParentNode(synergyNode);
        viabilityNode.setGroup(group);
        group.addChild(viabilityNode);
        ArrayList<SortKeys.VectorSortKey> sortOrder = new ArrayList<SortKeys.VectorSortKey>();
        for (String field : additionalFields) {
            sortOrder.add(new SortKeys.VectorSortKey(field, SortOrder.ASCENDING, true));
        }
        sortOrder.add(new SortKeys.VectorSortKey(concentration1Field, SortOrder.DESCENDING, true));
        sortOrder.add(new SortKeys.VectorSortKey(concentration2Field, SortOrder.DESCENDING, true));
        newSynergyProject.setRowSortOrder(sortOrder);
        ProjectGENEEResultTreeNode scoreNode = new ProjectGENEEResultTreeNode((Project)new DefaultProject(calc.createSynergyScoreMatrix(new Mean())), history, new ComponentCustomizer(){

            @Override
            public boolean inherits() {
                return false;
            }

            @Override
            public void customize(Component c) {
                HeatMapPanel p = (HeatMapPanel)c;
                p.getColorScheme().setRelative(false);
                p.getColorScheme().setGlobalMinMode(2, 0.0f);
            }
        });
        GENEEFolderNode folder = new GENEEFolderNode((String)map.get("Operation"), history, synergyNode, viabilityNode, scoreNode);
        return folder;
    }

    private static class SynergyCustomizer
    implements ComponentCustomizer {
        public HeatMapPanel viabilityHeatMapPanel;
        public HeatMapPanel synergyHeatMapPanel;
        private SynergyCompoundHeatMaps syn;

        public SynergyCustomizer(SynergyCompoundHeatMaps syn) {
            this.syn = syn;
        }

        @Override
        public boolean inherits() {
            return false;
        }

        @Override
        public void customize(Component c) {
            final HeatMapPanel p = (HeatMapPanel)c;
            HeatMapColorSchemeOptionsPanel.loadPredefinedColorScheme(p.getColorScheme(), "synergy");
            HeatMapToolBar toolBar = p.getToolBar();
            JButton synergyButtton = new JButton("C\u00b2D\u00b2");
            synergyButtton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Project project = p.getProject();
                    List<Dataset[]> datasets = SynergyCustomizer.this.syn.createSynergyAndViabilityDatasets(project.getModelRowIndices(true, false), project.getModelColumnIndices(true, false));
                    for (Dataset[] pair : datasets) {
                        Dataset s = pair[0];
                        Dataset v = pair[1];
                        SynergyCustomizer.this.syn.createHeatMap(SynergyCustomizer.this.synergyHeatMapPanel, SynergyCustomizer.this.viabilityHeatMapPanel, s, v);
                    }
                }
            });
            HeatMapToolBar.configure(synergyButtton);
            toolBar.add((Component)synergyButtton, toolBar.getSearchComponentIndex() - 1);
        }
    }
}

