/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.actions;

import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.AbstractInputAction;
import org.broadinstitute.genee.gui.ProgressNotifier;
import org.broadinstitute.genee.heatmap.DefaultProject;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class TransposeAction
extends AbstractInputAction {
    public TransposeAction() {
        super("Transpose");
        this.setShowSelectedAndMasked(true);
        this.setRunInBackground(false);
    }

    @Override
    protected MutableTreeNode execute(Map<String, Object> map, ProgressNotifier status) throws Exception {
        Project project = (Project)map.get("project");
        Dataset dataset = (Dataset)map.get("dataset");
        History history = this.getHistory(map);
        Dataset d = DatasetUtil.shallowCopy(DatasetUtil.transposeView(dataset));
        DefaultProject newProject = new DefaultProject(d, project);
        newProject.setRowDendrogram(project.getColumnDendrogram());
        newProject.setColumnDendrogram(project.getRowDendrogram());
        ProjectGENEEResultTreeNode resultNode = new ProjectGENEEResultTreeNode(newProject, history);
        return new GENEEFolderNode((String)map.get("Operation"), history, resultNode);
    }
}

