/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.dnd;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.dnd.DndUtil;
import org.broadinstitute.genee.gui.dnd.DragGhostImage;
import org.broadinstitute.genee.gui.dnd.PatchedTransferHandler;
import org.jdesktop.swingx.event.WeakEventListenerList;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class DragHandler
implements DragGestureListener,
DragSourceListener {
    private Point imageOffset = new Point();
    private boolean scrolls;
    private static final boolean DRAG_IMAGE_SUPPORTED = DragSource.isDragImageSupported();
    private WeakEventListenerList listenerList;

    public void addDragSourceListenerWeakly(DragSourceListener l) {
        if (this.listenerList == null) {
            this.listenerList = new WeakEventListenerList();
        }
        this.listenerList.add(DragSourceListener.class, (EventListener)l);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        DragSourceContext dsc = dsde.getDragSourceContext();
        JComponent c = (JComponent)dsc.getComponent();
        PatchedTransferHandler th = (PatchedTransferHandler)c.getTransferHandler();
        if (dsde.getDropSuccess()) {
            th.exportDone(c, dsc.getTransferable(), dsde.getDropAction());
        } else {
            th.exportDone(c, dsc.getTransferable(), 0);
        }
        c.setAutoscrolls(this.scrolls);
        if (DndUtil.dialog != null) {
            DndUtil.dialog.hide();
        }
        for (DragSourceListener l : this.getDragSourceListeners()) {
            l.dragDropEnd(dsde);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        for (DragSourceListener l : this.getDragSourceListeners()) {
            l.dragEnter(dsde);
        }
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
        for (DragSourceListener l : this.getDragSourceListeners()) {
            l.dragExit(dsde);
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        block13: {
            JComponent c = (JComponent)dge.getComponent();
            PatchedTransferHandler th = (PatchedTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    Image dragImage = null;
                    if (DRAG_IMAGE_SUPPORTED || DndUtil.showTranslucentDialog) {
                        Icon icon = th.getVisualRepresentation(t);
                        if (icon instanceof ImageIcon) {
                            dragImage = ((ImageIcon)icon).getImage();
                        } else if (icon == null) {
                            if (c instanceof DragGhostImage) {
                                dragImage = ((DragGhostImage)((Object)c)).getDragImage();
                            } else {
                                dragImage = GraphicsUtilities.createCompatibleTranslucentImage((int)c.getWidth(), (int)c.getHeight());
                                Graphics2D g = (Graphics2D)dragImage.getGraphics();
                                c.paint(g);
                                g.dispose();
                            }
                        } else {
                            dragImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                            Graphics2D g = ((BufferedImage)dragImage).createGraphics();
                            icon.paintIcon(c, g, 0, 0);
                            g.dispose();
                        }
                    }
                    if (DRAG_IMAGE_SUPPORTED) {
                        dge.startDrag(null, dragImage, this.imageOffset, t, this);
                        break block13;
                    }
                    if (DndUtil.showTranslucentDialog) {
                        DndUtil.maybeInitDrag();
                        DndUtil.dialog.setImage(dragImage);
                        Point p = (Point)dge.getDragOrigin().clone();
                        DndUtil.dialog.setDialogLocation(p);
                        dge.startDrag(null, t, this);
                        break block13;
                    }
                    dge.startDrag(null, t, this);
                }
                catch (Exception x) {
                    c.setAutoscrolls(this.scrolls);
                }
            } else {
                th.exportDone(c, t, 0);
            }
        }
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        for (DragSourceListener l : this.getDragSourceListeners()) {
            l.dragOver(dsde);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        for (DragSourceListener l : this.getDragSourceListeners()) {
            l.dropActionChanged(dsde);
        }
    }

    private Collection<DragSourceListener> getDragSourceListeners() {
        if (this.listenerList == null) {
            return Collections.EMPTY_LIST;
        }
        Object[] listeners = this.listenerList.getListenerList();
        ArrayList<DragSourceListener> tmp = new ArrayList<DragSourceListener>();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DragSourceListener.class) continue;
            tmp.add((DragSourceListener)listeners[i + 1]);
        }
        return tmp;
    }

    public static BufferedImage createDragImage(JComponent c) {
        if (!c.isShowing()) {
            DrawableWrapper.setPropsToPrint(c, c.getPreferredSize());
        }
        BufferedImage dragImage = GraphicsUtilities.createCompatibleTranslucentImage((int)c.getWidth(), (int)c.getHeight());
        Graphics2D g = (Graphics2D)dragImage.getGraphics();
        c.paint(g);
        g.dispose();
        return dragImage;
    }
}

