/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.dnd;

import java.awt.GraphicsEnvironment;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.dnd.DragHandler;
import org.broadinstitute.genee.gui.dnd.PatchedTransferHandler;

public class DragHelper {
    private DragGestureRecognizer dragGestureRecognizer;
    private DragHandler dragHandler;

    public DragHelper(JComponent c, PatchedTransferHandler transferHandler, int dndConstants) {
        this(c, transferHandler, dndConstants, null);
    }

    public DragHelper(JComponent c, PatchedTransferHandler transferHandler, int dndConstants, DragSourceListener dragSourceListener) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        try {
            Class<?> cl = c.getClass();
            Method m = cl.getMethod("setDragEnabled", Boolean.TYPE);
            m.invoke((Object)c, true);
        }
        catch (Exception x) {
            // empty catch block
        }
        this.dragHandler = new DragHandler();
        if (dragSourceListener != null) {
            this.dragHandler.addDragSourceListenerWeakly(dragSourceListener);
        }
        this.dragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(c, dndConstants, this.dragHandler);
        c.setTransferHandler(transferHandler);
    }

    public void dispose() {
        if (this.dragGestureRecognizer != null) {
            this.dragGestureRecognizer.removeDragGestureListener(this.dragHandler);
        }
    }
}

