/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.dnd;

import com.google.common.base.Function;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.dnd.DndUtil;
import org.broadinstitute.genee.gui.grid.DragDropComponent;
import org.broadinstitute.genee.io.util.IOUtil;

public abstract class DropHelper {
    private Class<?>[] acceptDropClasses;
    private boolean allowMultiple;
    private int dragOverIndex = -1;
    private DropTargetListener dropTargetListener;
    private Timer hideDragIndicatorTimer;
    private JComponent dropPanel;
    private boolean vertical;
    private JComponent dragLocationIndicatorPanel;
    private int gap = 2;
    private JComponent[] additionalComponentsToSupportDragOver;

    public DropHelper(Class<?>[] acceptDropClasses, boolean vertical, boolean allowMultiple, JComponent dragLocationIndicatorPanel) {
        this.acceptDropClasses = acceptDropClasses;
        this.vertical = vertical;
        this.allowMultiple = allowMultiple;
        this.dragLocationIndicatorPanel = dragLocationIndicatorPanel;
    }

    public Class<?>[] getAcceptDropClasses() {
        return this.acceptDropClasses;
    }

    public int getDragOverIndex() {
        return this.dragOverIndex;
    }

    public DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    public int getGap() {
        return this.gap;
    }

    public void hideDragIndicator() {
        if (!this.allowMultiple) {
            UIUtil.applyRecursively(this.dropPanel, (Function<? super Component, Void>)new Function<Component, Void>(){

                public Void apply(Component c) {
                    c.setBackground(null);
                    return null;
                }
            });
        } else {
            this.dropPanel.remove(this.dragLocationIndicatorPanel);
            this.dragOverIndex = -1;
        }
        this.dropPanel.revalidate();
        this.dropPanel.repaint();
    }

    public void init(JComponent dropPanel, JComponent[] additionalComponentsToSupportDragOver) {
        if (dropPanel == null) {
            throw new NullPointerException();
        }
        this.dropPanel = dropPanel;
        this.additionalComponentsToSupportDragOver = additionalComponentsToSupportDragOver;
        this._init();
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    protected abstract boolean drop(Object var1);

    private void _init() {
        this.hideDragIndicatorTimer = new Timer(60, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DropHelper.this.hideDragIndicator();
            }
        });
        this.hideDragIndicatorTimer.setInitialDelay(60);
        this.hideDragIndicatorTimer.setRepeats(false);
        this.hideDragIndicatorTimer.setCoalesce(true);
        this.dropTargetListener = new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                DropHelper.this.hideDragIndicatorTimer.stop();
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                if (!DropHelper.this.hideDragIndicatorTimer.isRunning()) {
                    DropHelper.this.hideDragIndicatorTimer.start();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
                Class<?> cl;
                Object transferData = null;
                try {
                    transferData = e.getTransferable().getTransferData(new DataFlavor("application/x-java-jvm-local-objectref"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                int oldDragOverIndex = DropHelper.this.dragOverIndex;
                Class<?> clazz = cl = transferData instanceof DragDropComponent ? ((DragDropComponent)transferData).getData().getClass() : transferData.getClass();
                if (IOUtil.isAssignableFrom(DropHelper.this.acceptDropClasses, cl)) {
                    Point location = e.getLocation();
                    if (DropHelper.this.vertical) {
                        if (DropHelper.this.dropPanel.getComponentCount() > 0) {
                            boolean found = false;
                            Point point = SwingUtilities.convertPoint(e.getDropTargetContext().getComponent(), location, DropHelper.this.dropPanel);
                            int y1 = 0;
                            int index = 0;
                            int cc = DropHelper.this.dropPanel.getComponentCount();
                            for (int i = 0; i < cc && !found; ++i) {
                                Component m = DropHelper.this.dropPanel.getComponent(i);
                                int height = m.getPreferredSize().height;
                                int y2 = y1 + height + DropHelper.this.gap / 2;
                                if (point.y >= y1 && point.y < y2) {
                                    DropHelper.this.dragOverIndex = index;
                                    found = true;
                                }
                                if (m != DropHelper.this.dragLocationIndicatorPanel) {
                                    ++index;
                                }
                                y1 = y2;
                            }
                            if (!found) {
                                DropHelper.this.dragOverIndex = index;
                            }
                        }
                    } else if (DropHelper.this.dropPanel.getComponentCount() > 0) {
                        boolean found = false;
                        Point point = SwingUtilities.convertPoint(e.getDropTargetContext().getComponent(), location, DropHelper.this.dropPanel);
                        int x1 = 0;
                        int index = 0;
                        int cc = DropHelper.this.dropPanel.getComponentCount();
                        for (int i = 0; i < cc && !found; ++i) {
                            Component c = DropHelper.this.dropPanel.getComponent(i);
                            int width = c.getPreferredSize().width;
                            int x2 = x1 + width + DropHelper.this.gap / 2;
                            if (point.x >= x1 && point.x < x2) {
                                DropHelper.this.dragOverIndex = index;
                                found = true;
                            }
                            if (c != DropHelper.this.dragLocationIndicatorPanel) {
                                ++index;
                            }
                            x1 = x2;
                        }
                        if (!found) {
                            DropHelper.this.dragOverIndex = index;
                        }
                    } else {
                        DropHelper.this.dragOverIndex = 0;
                    }
                    if (DropHelper.this.dragOverIndex < 0) {
                        DropHelper.this.dragOverIndex = 0;
                    }
                    e.acceptDrag(2);
                    if (!DropHelper.this.allowMultiple) {
                        UIUtil.applyRecursively(DropHelper.this.dropPanel, (Function<? super Component, Void>)new Function<Component, Void>(){

                            public Void apply(Component c) {
                                c.setBackground(UIUtil.DRAG_OVER_COLOR);
                                return null;
                            }
                        });
                    } else if (DropHelper.this.dragOverIndex != -1 && oldDragOverIndex != DropHelper.this.dragOverIndex) {
                        DropHelper.this.dropPanel.remove(DropHelper.this.dragLocationIndicatorPanel);
                        if (DropHelper.this.dragOverIndex > DropHelper.this.dropPanel.getComponentCount()) {
                            DropHelper.this.dragOverIndex = DropHelper.this.dropPanel.getComponentCount();
                        }
                        DropHelper.this.dropPanel.add((Component)DropHelper.this.dragLocationIndicatorPanel, DropHelper.this.dragOverIndex);
                        DropHelper.this.dropPanel.revalidate();
                    }
                } else {
                    DropHelper.this.hideDragIndicator();
                    e.rejectDrag();
                }
                DropHelper.this.dropPanel.repaint();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void drop(DropTargetDropEvent e) {
                DropHelper.this.dragOverIndex = Math.min(DropHelper.this.dropPanel.getComponentCount(), DropHelper.this.dragOverIndex);
                try {
                    Object transferData = e.getTransferable().getTransferData(new DataFlavor("application/x-java-jvm-local-objectref"));
                    if (DropHelper.this.drop(transferData)) {
                        e.acceptDrop(2);
                        e.dropComplete(true);
                    } else {
                        System.out.println("Drop failed");
                        e.dropComplete(false);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    e.dropComplete(false);
                }
                finally {
                    DropHelper.this.hideDragIndicator();
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }
        };
        if (this.additionalComponentsToSupportDragOver != null) {
            for (JComponent c : this.additionalComponentsToSupportDragOver) {
                DndUtil.setDropEnabled(c, this.acceptDropClasses, 2, this.dropTargetListener);
            }
        }
        DndUtil.setDropEnabled(this.dropPanel, this.acceptDropClasses, 2, this.dropTargetListener);
    }
}

