/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.grid;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolderPanel;
import com.jidesoft.docking.DockingManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.grid.AttributesVerticalDragComponent;
import org.broadinstitute.genee.gui.grid.DragDropButton;
import org.broadinstitute.genee.gui.grid.DragDropComponent;
import org.broadinstitute.genee.gui.grid.DragOwner;
import org.broadinstitute.genee.gui.grid.DropListPanel;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Vector;

public abstract class AttributesDragAndDropComponent {
    public static final String COLUMNS_DRAG_OWNER_NAME = "Columns";
    public static final String ROWS_DRAG_OWNER_NAME = "Rows";
    public static final Class<?>[] ACCEPT_DROP_TYPES = new Class[]{DragDropComponent.class, Vector.class};
    private DropListPanel columnsDropListPanel;
    private DropListPanel rowsDropListPanel;
    private AttributesVerticalDragComponent columnAnnotationsDragPanel;
    private AttributesVerticalDragComponent rowAnnotationsDragPanel;
    private DropListPanel[] additionalDropListPanels = new DropListPanel[0];
    private JComponent[] legends = new JComponent[0];
    private Component bottomLeftComponent;
    private DockableHolderPanel dockableHolderPanel;
    private DockingManager dockingManager;
    private String[] legendNames;
    private JLabel[] additionalDropListPanelLabels;
    private ArrayList<DropListPanel> dropListPanels;
    private DockableFrame[] legendFrames;
    private boolean rowsDropListPanelVisible = true;
    private boolean columnsDropListPanelVisible = true;
    private DockableFrame columnAnnotationsDragWindow;
    private DockableFrame rowAnnotationsDragWindow;
    private String bottomLeftTitle;
    private JLabel[] dropListPanelLabels;
    private FormBuilder dropListPanelFormBuilder;

    public AttributesDragAndDropComponent(Class<?>[] acceptDropTypes) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.dockableHolderPanel = new DockableHolderPanel();
            this.dockableHolderPanel.setMinimumSize(new Dimension());
            this.dockingManager = this.dockableHolderPanel.getDockingManager();
            AttributesDragAndDropComponent.configureDockingManager(this.dockingManager);
        }
        this.rowsDropListPanel = new DropListPanel(acceptDropTypes, false, true, null, ROWS_DRAG_OWNER_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                AttributesDragAndDropComponent.this.notifyGroupRowsByChanged(sourceOwnerName, destOwnerName);
            }

            @Override
            public void setOwner(DragDropComponent dragDropButton, DragOwner owner) {
                dragDropButton.setOwner(dragDropButton.getData(), owner, dragDropButton.getMenuCustomizer());
            }

            @Override
            protected DragDropComponent createDragDropComponent(Object transferData, DragOwner dragOwner, boolean interactive) {
                return new DragDropButton(transferData, dragOwner, null);
            }
        };
        this.columnsDropListPanel = new DropListPanel(acceptDropTypes, false, true, null, COLUMNS_DRAG_OWNER_NAME){

            @Override
            public void notifyChanged(String sourceOwnerName, String destOwnerName) {
                AttributesDragAndDropComponent.this.notifyGroupColumnsByChanged(sourceOwnerName, destOwnerName);
            }

            @Override
            public void setOwner(DragDropComponent dragDropButton, DragOwner owner) {
                dragDropButton.setOwner(dragDropButton.getData(), owner, dragDropButton.getMenuCustomizer());
            }

            @Override
            protected DragDropComponent createDragDropComponent(Object transferData, DragOwner dragOwner, boolean interactive) {
                return new DragDropButton(transferData, dragOwner, null);
            }
        };
        this.columnAnnotationsDragPanel = new AttributesVerticalDragComponent(false);
        this.rowAnnotationsDragPanel = new AttributesVerticalDragComponent(true);
        this.columnAnnotationsDragWindow = AttributesDragAndDropComponent.createDockableFrame(8, 0, "Column Annotations", this.columnAnnotationsDragPanel.getComponent());
        this.rowAnnotationsDragWindow = AttributesDragAndDropComponent.createDockableFrame(8, 1, "Row Annotations", this.rowAnnotationsDragPanel.getComponent());
        if (this.dockingManager != null) {
            this.dockingManager.addFrame(this.columnAnnotationsDragWindow);
            this.dockingManager.addFrame(this.rowAnnotationsDragWindow);
        }
    }

    public void buildUI() {
        int i;
        this.dropListPanels = new ArrayList();
        this.dropListPanels.add(this.columnsDropListPanel);
        this.columnsDropListPanel.getComponent().setVisible(this.columnsDropListPanelVisible);
        this.dropListPanels.add(this.rowsDropListPanel);
        this.rowsDropListPanel.getComponent().setVisible(this.rowsDropListPanelVisible);
        this.dropListPanels.addAll(Arrays.asList(this.additionalDropListPanels));
        this.dropListPanelLabels = new JLabel[this.dropListPanels.size()];
        int nlabels = this.dropListPanels.size();
        for (i = 0; i < nlabels; ++i) {
            this.dropListPanelLabels[i] = new JLabel(this.dropListPanels.get(i).getDragOwnerName() + ":");
        }
        this.additionalDropListPanelLabels = new JLabel[this.additionalDropListPanels.length];
        nlabels = this.dropListPanels.size();
        for (i = 2; i < nlabels; ++i) {
            this.additionalDropListPanelLabels[i - 2] = this.dropListPanelLabels[i];
        }
        this.dropListPanelFormBuilder = new FormBuilder();
        nlabels = this.dropListPanels.size();
        for (i = 0; i < nlabels; ++i) {
            this.dropListPanelFormBuilder.nextRowNoSpace();
            this.dropListPanelFormBuilder.addFirstColumn(this.dropListPanelLabels[i]);
            Component c = this.dropListPanels.get(i).getComponent();
            this.dropListPanelLabels[i].setLabelFor(c);
            this.dropListPanelFormBuilder.add(c);
        }
        if (this.dockingManager != null) {
            this.dockingManager.addFrame(AttributesDragAndDropComponent.createDockableFrame(4, 0, "View", UIUtil.createNoBorderScrollPane(this.dropListPanelFormBuilder.getPanel())));
        }
        this.dropListPanelFormBuilder.getPanel().setMinimumSize(new Dimension());
        this.legendFrames = new DockableFrame[0];
        if (this.legends.length > 0) {
            this.legendFrames = new DockableFrame[this.legends.length];
            for (i = 0; i < this.legends.length; ++i) {
                JComponent legend = this.legends[i];
                if (legend == null || this.dockingManager == null) continue;
                DockableFrame frame = AttributesDragAndDropComponent.createDockableFrame(4, i + 1, this.legendNames[i], null);
                JScrollPane sp = AttributesDragAndDropComponent.createScrollPane(legend, frame);
                frame.getContentPane().add(sp);
                this.dockingManager.addFrame(frame);
                this.legendFrames[i] = frame;
            }
        }
        if (this.bottomLeftComponent != null && this.dockingManager != null) {
            DockableFrame f = AttributesDragAndDropComponent.createDockableFrame(2, 0, this.bottomLeftTitle, this.bottomLeftComponent);
            this.dockingManager.addFrame(f);
        }
        if (this.dockingManager != null) {
            this.dockingManager.loadLayoutData();
            for (int i2 = 0; i2 < this.legends.length; ++i2) {
                if (this.legendFrames[i2] == null) continue;
                this.legendFrames[i2].getDockingManager().hideFrame(this.legendFrames[i2].getKey());
            }
        }
    }

    public void dispose() {
        if (this.dockingManager != null) {
            this.dockingManager.removeAllFrames();
            this.dockingManager.dispose();
        }
    }

    public Component getComponent() {
        return this.dockableHolderPanel;
    }

    public List<Object> getDroppedGroupColumnsByData() {
        return this.columnsDropListPanel.getComponent().isVisible() ? this.columnsDropListPanel.getDroppedData() : Collections.emptyList();
    }

    public List<Object> getDroppedGroupRowsByData() {
        return this.rowsDropListPanel.getComponent().isVisible() ? this.rowsDropListPanel.getDroppedData() : Collections.emptyList();
    }

    public void setAdditionalDropListPanels(DropListPanel[] additionalDropListPanels) {
        if (additionalDropListPanels == null) {
            additionalDropListPanels = new DropListPanel[]{};
        }
        this.additionalDropListPanels = additionalDropListPanels;
    }

    public void setAdditionalDropListPanelVisible(int index, boolean visible) {
        boolean legendVisible;
        this.additionalDropListPanels[index].getComponent().setVisible(visible);
        this.additionalDropListPanelLabels[index].setVisible(visible);
        DockableFrame legendFrame = this.legendFrames[index];
        if (legendFrame == null) {
            return;
        }
        boolean bl = legendVisible = visible && this.legends[index].isVisible();
        if (legendVisible) {
            legendFrame.getDockingManager().showFrame(legendFrame.getKey());
        } else {
            legendFrame.getDockingManager().hideFrame(legendFrame.getKey());
        }
    }

    public void setBottomLeftComponent(Component c, String title) {
        this.bottomLeftComponent = c;
        this.bottomLeftTitle = title;
    }

    public void setBottomLeftComponentVisible(boolean visible) {
        if (this.bottomLeftTitle != null) {
            if (visible) {
                this.dockingManager.showFrame(this.bottomLeftTitle);
            } else {
                this.dockingManager.hideFrame(this.bottomLeftTitle);
            }
        }
    }

    public void setColumnAnnotationsDragPanelVisible(boolean visible) {
        if (visible) {
            this.columnAnnotationsDragWindow.getDockingManager().showFrame(this.columnAnnotationsDragWindow.getKey());
        } else {
            this.columnAnnotationsDragWindow.getDockingManager().hideFrame(this.columnAnnotationsDragWindow.getKey());
        }
    }

    public void setColumnsDropListPanelVisible(boolean visible) {
        this.columnsDropListPanelVisible = visible;
        if (this.columnsDropListPanel != null) {
            this.columnsDropListPanel.getComponent().setVisible(visible);
            this.dropListPanelLabels[0].setVisible(visible);
        }
    }

    public void setDataset(Dataset dataset) {
        this.columnAnnotationsDragPanel.setDataset(dataset);
        this.rowAnnotationsDragPanel.setDataset(dataset);
    }

    public void setLegends(JComponent[] legends, String[] legendNames) {
        if (legends == null) {
            legends = new JComponent[]{};
        }
        this.legends = legends;
        this.legendNames = legendNames;
    }

    public void setRowAnnotationsDragPanelVisible(boolean visible) {
        if (visible) {
            this.rowAnnotationsDragWindow.getDockingManager().showFrame(this.rowAnnotationsDragWindow.getKey());
        } else {
            this.rowAnnotationsDragWindow.getDockingManager().hideFrame(this.rowAnnotationsDragWindow.getKey());
        }
    }

    public void setRowsDropListPanelVisible(boolean visible) {
        this.rowsDropListPanelVisible = visible;
        if (this.rowsDropListPanel != null) {
            this.rowsDropListPanel.getComponent().setVisible(visible);
            this.dropListPanelLabels[1].setVisible(visible);
        }
    }

    protected abstract void notifyGroupColumnsByChanged(String var1, String var2);

    protected abstract void notifyGroupRowsByChanged(String var1, String var2);

    public static void configureDockingManager(DockingManager dockingManager) {
        dockingManager.setRearrangable(true);
        dockingManager.setCrossDraggingAllowed(false);
        dockingManager.setCrossDroppingAllowed(false);
        dockingManager.setFloatable(false);
        dockingManager.setTabDockAllowed(false);
        dockingManager.setShowWorkspace(false);
        dockingManager.setNestedFloatingAllowed(false);
        dockingManager.setInitEastSplit(0);
        dockingManager.setInitWestSplit(0);
        dockingManager.setInitCenterSplit(0);
    }

    public static DockableFrame createDockableFrame(int side, int index, String title, Component c) {
        DockableFrame frame = new DockableFrame(title);
        frame.setTitle(title);
        frame.getContext().setInitSide(side);
        frame.getContext().setInitMode(4);
        frame.getContext().setInitIndex(index);
        if (c != null) {
            frame.getContentPane().add(c);
        }
        frame.setDockedHeight(100);
        frame.setDockedWidth(80);
        frame.setTabDockAllowed(false);
        frame.setMaximizable(false);
        frame.setAutohidable(false);
        frame.setAvailableButtons(2);
        return frame;
    }

    public static JScrollPane createScrollPane(final JComponent c, final DockableFrame frame) {
        JScrollPane sp = new JScrollPane(c){

            @Override
            protected JViewport createViewport() {
                return new JViewport(){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension d = super.getPreferredSize();
                        d.height = 150;
                        return d;
                    }
                };
            }
        };
        sp.setMinimumSize(new Dimension());
        c.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                frame.getDockingManager().hideFrame(frame.getKey());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                frame.getDockingManager().showFrame(frame.getKey());
                c.revalidate();
                c.repaint();
            }
        });
        return sp;
    }

    public FormBuilder getDropListPanelFormBuilder() {
        return this.dropListPanelFormBuilder;
    }
}

