/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.grid;

import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.broadinstitute.genee.gui.DragImageJideSplitButton;
import org.broadinstitute.genee.gui.TransferableObject;
import org.broadinstitute.genee.gui.dnd.DndUtil;
import org.broadinstitute.genee.gui.dnd.DragHelper;
import org.broadinstitute.genee.gui.dnd.PatchedTransferHandler;
import org.broadinstitute.genee.gui.grid.DragDropComponent;
import org.broadinstitute.genee.gui.grid.DragOwner;
import org.broadinstitute.genee.io.util.Formatter;

public class DragDropButton
implements DragDropComponent {
    private Object data;
    private DragOwner owner;
    private DragImageJideSplitButton button;
    private PopupMenuCustomizer popupMenuCustomizer;
    private boolean enabled = true;
    private JCheckBoxMenuItem enabledMenuItem;
    private DragSourceListener dragSourceListener;

    public DragDropButton(Object data, DragOwner owner, PopupMenuCustomizer popupMenuCustomizer) {
        this.button = new DragImageJideSplitButton(Formatter.toString(data));
        this.setOwner(data, owner, popupMenuCustomizer);
        this.dragSourceListener = new DragSourceListener(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                if (!dsde.getDropSuccess()) {
                    DragDropButton.this.removeButton(true);
                }
            }

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
            }
        };
        new DragHelper((JComponent)((Object)this.button), new PatchedTransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new TransferableObject<DragDropButton>(DragDropButton.this);
            }
        }, 2, this.dragSourceListener);
    }

    @Override
    public JComponent getComponent() {
        return this.button;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public PopupMenuCustomizer getMenuCustomizer() {
        return this.popupMenuCustomizer;
    }

    @Override
    public DragOwner getOwner() {
        return this.owner;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.button.setForegroundOfState(0, enabled ? Color.BLACK : Color.GRAY);
        this.owner.notifyChanged(this.getOwner().getDragOwnerName(), enabled ? this.getOwner().getDragOwnerName() : null);
    }

    @Override
    public void setOwner(Object data, DragOwner owner, PopupMenuCustomizer popupMenuCustomizer) {
        this.data = data;
        this.removeButton(false);
        this.owner = owner;
        DndUtil.setDropEnabled((JComponent)((Object)this.button), owner.getAcceptDropClasses(), 2, owner.getDropTargetListener());
        this.popupMenuCustomizer = popupMenuCustomizer;
        this.addPopups();
    }

    public String toString() {
        return Formatter.toString(this.data);
    }

    private void addPopups() {
        this.button.removeAll();
        if (this.popupMenuCustomizer != null) {
            this.popupMenuCustomizer.customize((JMenu)((Object)this.button), this.data);
        }
        this.enabledMenuItem = new JCheckBoxMenuItem("Enabled", true);
        this.enabledMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DragDropButton.this.setEnabled(DragDropButton.this.enabledMenuItem.isSelected());
            }
        });
        this.button.add(this.enabledMenuItem);
        this.button.addSeparator();
        this.button.add(new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DragDropButton.this.removeButton(true);
            }
        });
    }

    private void removeButton(boolean notify) {
        if (this.owner != null) {
            this.owner.removeDragDropComponent(this, notify);
        }
    }

    public static interface PopupMenuCustomizer {
        public void customize(JMenu var1, Object var2);
    }
}

