/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.grid;

import com.google.common.base.Function;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.DragImageJideSplitButton;
import org.broadinstitute.genee.gui.DrawableWrapper;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.dnd.DropHelper;
import org.broadinstitute.genee.gui.grid.DownArrowPanel;
import org.broadinstitute.genee.gui.grid.DragDropButton;
import org.broadinstitute.genee.gui.grid.DragDropComponent;
import org.broadinstitute.genee.gui.grid.DragOwner;
import org.broadinstitute.genee.gui.grid.RightArrowPanel;
import org.broadinstitute.genee.io.util.IOUtil;
import org.jdesktop.swingx.HorizontalLayout;
import org.jdesktop.swingx.VerticalLayout;

public abstract class DropListPanel
implements DragOwner {
    private JPanel dropPanel;
    private JComponent emptyComponent;
    private String name;
    private DropHelper dropHelper;
    public static final String DRAG_DROP_COMPONENT = "drop.data";
    private String dropHintText;

    public DropListPanel(Class<?>[] acceptDropClasses, boolean vertical, boolean allowMultiple, JComponent emptyComponent, String name) {
        this.dropHelper = new DropHelper(acceptDropClasses, vertical, allowMultiple, vertical ? new RightArrowPanel() : new DownArrowPanel()){

            @Override
            protected boolean drop(Object transferData) {
                DragDropComponent dragDropComponent = DropListPanel.this.drop(transferData, true);
                return dragDropComponent != null;
            }
        };
        this.dropHintText = " Drop " + (this.dropHelper.isAllowMultiple() ? "annotations" : "annotation") + " here";
        this.emptyComponent = emptyComponent;
        this.name = name;
        this.init();
        this.dropHelper.init(this.dropPanel, null);
    }

    public void clear() {
        List<DragDropComponent> dragDropComponents = this.getDragDropComponents();
        for (DragDropComponent c : dragDropComponents) {
            this.removeDragDropComponent(c, true);
        }
        this.updateEmptyComponent();
        this.notifyChanged(this.name, null);
    }

    public final DragDropComponent drop(Object transferData, boolean interactive) {
        int dragOverIndex = this.dropHelper.getDragOverIndex();
        if (!this.dropHelper.isAllowMultiple()) {
            dragOverIndex = 0;
            this.dropPanel.removeAll();
        }
        DragDropComponent dragDropComponent = null;
        if (transferData instanceof DragDropComponent && IOUtil.isAssignableFrom(this.dropHelper.getAcceptDropClasses(), ((DragDropComponent)transferData).getData().getClass())) {
            dragDropComponent = (DragDropComponent)transferData;
            String sourceOwnerName = dragDropComponent.getOwner().getDragOwnerName();
            this.setOwner(dragDropComponent, this);
            String destOwnerName = dragDropComponent.getOwner().getDragOwnerName();
            this.dropPanel.add(dragDropComponent.getComponent(), null, dragOverIndex);
            int cc = this.dropPanel.getComponentCount();
            for (int i = 0; i < cc; ++i) {
                Component c = this.dropPanel.getComponent(i);
                if (!(c instanceof DragImageJideSplitButton)) continue;
                DragImageJideSplitButton btn = (DragImageJideSplitButton)((Object)c);
                btn.dropFocus();
            }
            dragDropComponent.getComponent().grabFocus();
            this.dropPanel.revalidate();
            this.notifyChanged(sourceOwnerName, destOwnerName);
        } else if (IOUtil.isAssignableFrom(this.dropHelper.getAcceptDropClasses(), transferData.getClass())) {
            dragDropComponent = this.createDragDropComponent(transferData, this, interactive);
            dragDropComponent.getComponent().putClientProperty(DRAG_DROP_COMPONENT, dragDropComponent);
            this.dropPanel.add(dragDropComponent.getComponent(), null, dragOverIndex);
            int cc = this.dropPanel.getComponentCount();
            for (int i = 0; i < cc; ++i) {
                Component c = this.dropPanel.getComponent(i);
                if (!(c instanceof DragImageJideSplitButton)) continue;
                DragImageJideSplitButton btn = (DragImageJideSplitButton)((Object)c);
                btn.dropFocus();
            }
            dragDropComponent.getComponent().grabFocus();
            this.dropPanel.revalidate();
            this.notifyChanged(null, this.getDragOwnerName());
        }
        if (this.emptyComponent != null && this.emptyComponent.isShowing()) {
            this.dropPanel.remove(this.emptyComponent);
        }
        return dragDropComponent;
    }

    @Override
    public Class<?>[] getAcceptDropClasses() {
        return this.dropHelper.getAcceptDropClasses();
    }

    public Component getComponent() {
        return this.dropPanel;
    }

    public List<DragDropComponent> getDragDropComponents() {
        ArrayList<DragDropComponent> list = new ArrayList<DragDropComponent>();
        int cc = this.dropPanel.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            DragDropComponent dragDropComponent;
            Component c = this.dropPanel.getComponent(i);
            if (!(c instanceof JComponent) || (dragDropComponent = (DragDropComponent)((JComponent)c).getClientProperty(DRAG_DROP_COMPONENT)) == null) continue;
            list.add(dragDropComponent);
        }
        return list;
    }

    public List<DragDropComponent> getDragDropComponents(boolean includeDisabled) {
        ArrayList<DragDropComponent> list = new ArrayList<DragDropComponent>();
        int cc = this.dropPanel.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            DragDropComponent dragDropComponent;
            Component c = this.dropPanel.getComponent(i);
            if (!(c instanceof JComponent) || (dragDropComponent = (DragDropComponent)((JComponent)c).getClientProperty(DRAG_DROP_COMPONENT)) == null || !dragDropComponent.isEnabled() && (!includeDisabled || dragDropComponent.isEnabled())) continue;
            list.add(dragDropComponent);
        }
        return list;
    }

    @Override
    public String getDragOwnerName() {
        return this.name;
    }

    public List<Object> getDroppedData() {
        List<DragDropComponent> components = this.getDragDropComponents(false);
        ArrayList<Object> list = new ArrayList<Object>();
        for (DragDropComponent c : components) {
            list.add(c.getData());
        }
        return list;
    }

    @Override
    public DropTargetListener getDropTargetListener() {
        return this.dropHelper.getDropTargetListener();
    }

    @Override
    public void removeDragDropComponent(DragDropComponent dragDropButton, boolean notify) {
        this.dropPanel.remove(dragDropButton.getComponent());
        this.dropPanel.revalidate();
        this.dropPanel.repaint();
        this.updateEmptyComponent();
        if (notify) {
            this.notifyChanged(dragDropButton.getOwner().getDragOwnerName(), null);
        }
    }

    @Override
    public void setOwner(DragDropComponent dragDropComponent, DragOwner owner) {
        dragDropComponent.setOwner(dragDropComponent.getData(), owner, dragDropComponent.getMenuCustomizer());
    }

    protected DragDropComponent createDragDropComponent(Object transferData, DragOwner dragOwner, boolean interactive) {
        return new DragDropButton(transferData, dragOwner, null);
    }

    private void init() {
        this.dropPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                boolean paint = false;
                if (DropListPanel.this.dropHelper.isAllowMultiple()) {
                    paint = this.getComponentCount() == 0;
                } else if (this.getComponentCount() == 0 && !this.isBackgroundSet()) {
                    paint = true;
                }
                if (paint) {
                    JLabel label = new JLabel(DropListPanel.this.dropHintText);
                    label.setEnabled(false);
                    DrawableWrapper.setPropsToPrint(label, new Dimension(this.getWidth(), this.getHeight()));
                    label.print(g);
                }
            }
        };
        if (this.dropHelper.isVertical()) {
            this.dropPanel.setLayout((LayoutManager)new VerticalLayout(this.dropHelper.getGap()){

                public void layoutContainer(Container parent) {
                    Insets insets = parent.getInsets();
                    Dimension size = parent.getSize();
                    int fullWidth = size.width - insets.left - insets.right;
                    int height = insets.top;
                    int c = parent.getComponentCount();
                    for (int i = 0; i < c; ++i) {
                        Component m = parent.getComponent(i);
                        if (!m.isVisible()) continue;
                        m.setBounds(insets.left, height, !DropListPanel.this.dropHelper.isAllowMultiple() ? fullWidth : m.getPreferredSize().width, m.getPreferredSize().height);
                        height += m.getSize().height + DropListPanel.this.dropHelper.getGap();
                    }
                }

                public Dimension minimumLayoutSize(Container parent) {
                    return this.preferredLayoutSize(parent);
                }

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension d = super.preferredLayoutSize(parent);
                    d.width = Math.max(d.width, 250);
                    d.height = Math.max(d.height, DragImageJideSplitButton.getPreferredHeight() + 2 * DropListPanel.this.dropHelper.getGap());
                    return d;
                }
            });
        } else {
            this.dropPanel.setLayout((LayoutManager)new HorizontalLayout(this.dropHelper.getGap()){

                public Dimension minimumLayoutSize(Container parent) {
                    return new Dimension();
                }

                public Dimension preferredLayoutSize(Container parent) {
                    Dimension d = super.preferredLayoutSize(parent);
                    d.width = Math.max(d.width, 250);
                    d.height = Math.max(d.height, DragImageJideSplitButton.getPreferredHeight() + 2 * DropListPanel.this.dropHelper.getGap());
                    return d;
                }
            });
        }
        if (this.emptyComponent != null) {
            this.dropPanel.add(this.emptyComponent);
        }
        this.dropPanel.setBackground(null);
        this.dropPanel.setBorder(BorderFactory.createEtchedBorder());
    }

    private void updateEmptyComponent() {
        if (this.emptyComponent != null) {
            UIUtil.applyRecursively(this.emptyComponent, (Function<? super Component, Void>)new Function<Component, Void>(){

                public Void apply(Component c) {
                    c.setBackground(null);
                    return null;
                }
            });
        }
        if (this.emptyComponent != null && this.dropPanel.getComponentCount() == 0) {
            this.dropPanel.add(this.emptyComponent);
        }
    }
}

