/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import com.jidesoft.swing.CheckBoxList;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.io.util.Formatter;

public class CheckBoxListParameter
implements InputParameter<Object[]> {
    private CheckBoxList checkBoxList;
    private JScrollPane sp;

    public CheckBoxListParameter() {
        this.checkBoxList = new CheckBoxList();
        this.checkBoxList.setPrototypeCellValue((Object)"AAAAAAAAAAAA");
        this.sp = UIUtil.createNoBorderScrollPane((Component)this.checkBoxList);
    }

    public CheckBoxListParameter(Object[] values) {
        this.init(values);
    }

    @Override
    public JComponent getJComponent() {
        return this.sp;
    }

    @Override
    public Object[] getParameterValue() {
        return this.checkBoxList.getCheckBoxListSelectedValues();
    }

    @Override
    public Class<?> getValueClass() {
        return Object[].class;
    }

    @Override
    public void init(Object value) {
        Object[] selectedValues = this.checkBoxList.getCheckBoxListSelectedValues();
        Object[] array = (Object[])value;
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (Object s : array) {
            model.addElement(s);
        }
        this.checkBoxList.setModel(model);
        if (selectedValues != null) {
            this.checkBoxList.setSelectedObjects(selectedValues);
        } else {
            this.checkBoxList.selectAll();
        }
    }

    public void setSelection(Object[] values) {
        this.checkBoxList.setSelectedObjects(values);
    }

    public boolean isSelectionEmpty() {
        return this.checkBoxList.getCheckBoxListSelectedValues().length == 0;
    }

    @Override
    public void setValueFromString(String string) {
        this.setValueFromString(string, true);
    }

    public void setValueFromString(String string, boolean matchCase) {
        String[] tokenArray = string.split(", ");
        if (!matchCase) {
            for (int i = 0; i < tokenArray.length; ++i) {
                tokenArray[i] = tokenArray[i].toLowerCase();
            }
        }
        HashSet<String> tokens = new HashSet<String>(Arrays.asList(tokenArray));
        this.checkBoxList.getSelectionModel().setValueIsAdjusting(true);
        int cc = this.checkBoxList.getModel().getSize();
        for (int i = 0; i < cc; ++i) {
            String itemText = Formatter.toString(this.checkBoxList.getModel().getElementAt(i));
            if (!matchCase) {
                itemText = itemText.toLowerCase();
            }
            if (!tokens.contains(itemText)) continue;
            this.checkBoxList.getCheckBoxListSelectionModel().addSelectionInterval(i, i);
        }
        this.checkBoxList.getSelectionModel().setValueIsAdjusting(false);
    }
}

