/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.hints.FileIntelliHints;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.broadinstitute.genee.gui.ActionListenerHelper;
import org.broadinstitute.genee.gui.FileChooserUtil;
import org.broadinstitute.genee.gui.dnd.FileDrop;
import org.broadinstitute.genee.gui.parameters.InputParameter;
import org.broadinstitute.genee.io.util.IOUtil;

public class FileInputParameter
extends JPanel
implements InputParameter<File[]> {
    public static int OPEN_DIRECTORY = 1;
    public static int OPEN_FILE = 0;
    public static int OPEN_FILES = 3;
    public static int SAVE = 2;
    private JButton browseBtn;
    private int mode;
    private final JTextField textField;

    public FileInputParameter(int mode) {
        this("", mode, 20);
    }

    public FileInputParameter(String defaultText, int mode) {
        this(defaultText, mode, 20);
    }

    public FileInputParameter(String defaultText, final int mode, int columns) {
        this.mode = mode;
        FormLayout formLayout = new FormLayout("pref, 4dlu, pref", "pref");
        formLayout.setRowGroups((int[][])new int[][]{{1}});
        this.setLayout((LayoutManager)formLayout);
        CellConstraints cc = new CellConstraints();
        this.textField = new JTextField(20);
        if (defaultText != null) {
            this.textField.setText(defaultText);
        }
        if (mode != SAVE) {
            FileIntelliHints hints = new FileIntelliHints((JTextComponent)this.textField);
            hints.setFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.charAt(0) != '.';
                }
            });
            hints.setFolderOnly(mode == OPEN_DIRECTORY);
            if (!GraphicsEnvironment.isHeadless()) {
                new FileDrop(this.textField, new FileDrop.Listener(){

                    @Override
                    public void filesDropped(File[] files) {
                        if (mode == OPEN_FILES) {
                            StringBuilder sb = new StringBuilder();
                            int length = files.length;
                            for (int i = 0; i < length; ++i) {
                                if (sb.length() > 0) {
                                    sb.append(", ");
                                }
                                if (!files[i].isFile()) continue;
                                sb.append(IOUtil.getPath(files[i]));
                            }
                            FileInputParameter.this.textField.setText(sb.toString());
                        } else if (mode == OPEN_FILE) {
                            if (files[0].isFile()) {
                                FileInputParameter.this.textField.setText(IOUtil.getPath(files[0]));
                            }
                        } else if (mode == OPEN_DIRECTORY && files[0].isDirectory()) {
                            FileInputParameter.this.textField.setText(IOUtil.getPath(files[0]));
                        }
                    }
                });
            }
        }
        this.browseBtn = this.createBrowseButton();
        this.browseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] selectedFiles;
                if (mode == SAVE) {
                    selectedFiles = new File[]{FileChooserUtil.showSaveDialog(FileInputParameter.this.getTopLevelAncestor())};
                } else if (mode == OPEN_FILE) {
                    selectedFiles = new File[]{FileChooserUtil.showOpenDialog(FileInputParameter.this.getTopLevelAncestor())};
                } else if (mode == OPEN_DIRECTORY) {
                    selectedFiles = new File[]{FileChooserUtil.showSelectDirectoryDialog(FileInputParameter.this.getTopLevelAncestor(), null)};
                } else if (mode == OPEN_FILES) {
                    selectedFiles = FileChooserUtil.showMultiSelectOpenDialog(FileInputParameter.this.getTopLevelAncestor(), null);
                } else {
                    throw new IllegalArgumentException();
                }
                if (selectedFiles != null) {
                    StringBuilder sb = new StringBuilder();
                    int length = selectedFiles.length;
                    for (int i = 0; i < length; ++i) {
                        if (selectedFiles[i] == null) continue;
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(IOUtil.getPath(selectedFiles[i]));
                    }
                    if (sb.length() > 0) {
                        FileInputParameter.this.textField.setText(sb.toString());
                        ActionListenerHelper.fireActionPerformed(FileInputParameter.this.listenerList, e);
                    }
                }
            }
        });
        this.add((Component)this.textField, cc.xy(1, 1));
        this.add((Component)this.browseBtn, cc.xy(3, 1));
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
        this.textField.addActionListener(l);
    }

    public void addBrowseButtonActionListener(ActionListener l) {
        this.browseBtn.addActionListener(l);
    }

    public File getFile() {
        return new File(this.getText().trim());
    }

    public File[] getFiles() {
        String[] files = this.getText().split(",");
        ArrayList<File> list = new ArrayList<File>();
        for (String file : files) {
            if ((file = file.trim()).equals("")) continue;
            list.add(new File(file));
        }
        return list.toArray(new File[0]);
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public File[] getParameterValue() {
        return this.getFiles();
    }

    public String getText() {
        return this.textField.getText().trim();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    @Override
    public Class<?> getValueClass() {
        return File[].class;
    }

    @Override
    public void init(Object value) {
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setValueFromString(String s) {
        this.textField.setText(s);
    }

    protected JButton createBrowseButton() {
        return new JButton("Browse\u2026");
    }
}

