/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.gui.parameters.CheckBoxParameter;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;

public class IncludeSelectedColumnsCheckBox
extends CheckBoxParameter {
    private SelectionListener columnSelectionListener = new SelectionListener(){

        @Override
        public void valueChanged(SelectionEvent e) {
            IncludeSelectedColumnsCheckBox.this.updateSelectedColumnsText();
        }
    };
    private Project project;

    public IncludeSelectedColumnsCheckBox(String text, boolean selected) {
        super(text, selected);
    }

    public void notifyHidden() {
        if (this.project != null) {
            this.project.removeColumnSelectionListener(this.columnSelectionListener);
        }
    }

    public void notifyShowing() {
        this.updateSelectedColumnsText();
        this.project = Application.getProject();
        this.project.addColumnSelectionListener(this.columnSelectionListener);
    }

    private void updateSelectedColumnsText() {
        Project project = Application.getProject();
        int count = project == null ? 0 : project.getColumnSelectionModel().getSelectionCount();
        this.setEnabled(count > 0);
    }
}

