/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.parameters;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.parameters.InputParameter;

public class RadioButtonParameter
extends JPanel
implements InputParameter<Object> {
    private JRadioButton[] buttons;
    private ButtonGroupHelper helper = new ButtonGroupHelper();
    private Object[] items;

    public RadioButtonParameter(Object[] items, int selectedIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append(", 6px, ");
            }
            sb.append("top:p");
        }
        this.setLayout((LayoutManager)new FormLayout("p", sb.toString()));
        CellConstraints cc = new CellConstraints();
        this.buttons = new JRadioButton[items.length];
        int i = 0;
        int rowIndex = 1;
        int length = items.length;
        while (i < length) {
            this.buttons[i] = this.helper.createRadioButton(items[i]);
            this.add((Component)this.buttons[i], cc.xy(1, rowIndex));
            ++i;
            rowIndex += 2;
        }
        this.buttons[selectedIndex].setSelected(true);
        this.items = items;
    }

    public ButtonGroupHelper getButtonGroupHelper() {
        return this.helper;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public Object getParameterValue() {
        return this.items[this.getSelectedIndex()];
    }

    public int getSelectedIndex() {
        int length = this.buttons.length;
        for (int i = 0; i < length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getValueClass() {
        return String.class;
    }

    @Override
    public void init(Object value) {
    }

    @Override
    public void setValueFromString(String s) {
        int length = this.buttons.length;
        for (int i = 0; i < length; ++i) {
            if (!this.buttons[i].getText().equals(s)) continue;
            this.buttons[i].setSelected(true);
            break;
        }
    }
}

