/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.scroll;

import java.awt.event.MouseEvent;
import java.util.List;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.heatmap.SizesAndPositions;

public class ScrollMouseHelper {
    private ScrollMouseHelper() {
    }

    public static int binarySearch(List<Node> highlightedNodes, float key, float tolerance) {
        int low = 0;
        if (highlightedNodes == null) {
            return -1;
        }
        int high = highlightedNodes.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            float midVal = highlightedNodes.get(mid).getPosition();
            int cmp = 0;
            if (Math.abs(midVal - key) <= tolerance) {
                cmp = 0;
            } else if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(SizesAndPositions sizesAndPositions, int[] indices, float key, float tolerance) {
        int low = 0;
        if (indices == null) {
            return -1;
        }
        int high = indices.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            float midVal = sizesAndPositions.getPosition(indices[mid]);
            int cmp = 0;
            if (Math.abs(midVal - key) <= tolerance) {
                cmp = 0;
            } else if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static float getLowerPositionForHorizontalScroll(MouseEvent e, float scale, float offset) {
        float pos1 = ((float)e.getX() - offset - 1.0f) / scale;
        return pos1;
    }

    public static float getPositionForHorizontalScroll(MouseEvent e, float scale, float offset) {
        float pos1 = ((float)e.getX() - offset) / scale;
        return pos1;
    }

    public static float getUpperPositionForHorizontalScroll(MouseEvent e, float scale, float offset) {
        float pos2 = ((float)e.getX() - offset + 1.0f) / scale;
        return pos2;
    }

    public static float getLowerPositionForVerticalScroll(MouseEvent e, float scale, float offset) {
        float pos1 = ((float)e.getY() - offset - 1.0f) / scale;
        return pos1;
    }

    public static float getPositionForVerticalScroll(MouseEvent e, float scale, float offset) {
        float pos1 = ((float)e.getY() - offset) / scale;
        return pos1;
    }

    public static float getUpperPositionForVerticalScroll(MouseEvent e, float scale, float offset) {
        float pos2 = ((float)e.getY() - offset + 1.0f) / scale;
        return pos2;
    }
}

