/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.scroll;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ScrollBarUI;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.scroll.BasicSearchScrollBarUI;
import org.broadinstitute.genee.gui.scroll.ScrollBarUIHelper;
import org.broadinstitute.genee.gui.scroll.ScrollMouseHelper;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.QuickFilter;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.matrix.DatasetUtil;

public class VerticalScrollBarUIHelper
implements ScrollBarUIHelper {
    private List<Node> highlightedNodes;
    private int[] highlightedRowIndices;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private int offset;
    private Project project;
    private float scale;
    private JScrollBar scrollbar;
    private int[] selectedRowIndices;
    private SelectionListener selectionListener;
    private SizesAndPositions sizesAndPositions;
    private ActionListener actionListener;
    private QuickFilter quickRowSearch;

    public VerticalScrollBarUIHelper(QuickFilter quickFilter, SizesAndPositions sizesAndPositions) {
        this.quickRowSearch = quickFilter;
        this.sizesAndPositions = sizesAndPositions;
    }

    @Override
    public void draw(Graphics g, int width, int height, int offset) {
        Graphics2D g2 = (Graphics2D)g;
        width -= 2;
        AffineTransform transform = g2.getTransform();
        g2.translate(1, 0);
        this.scale = (float)height / this.sizesAndPositions.getPosition(this.sizesAndPositions.getLength() - 1);
        this.offset = offset;
        if (this.selectedRowIndices != null) {
            this.draw(g2, UIUtil.SELECTION_COLOR, this.selectedRowIndices, width);
        }
        if (this.highlightedRowIndices != null) {
            this.draw(g2, UIUtil.HIGHLIGHT_COLOR, this.highlightedRowIndices, width);
        }
        this.drawHighlightedNodes((Graphics2D)g, width);
        g2.setTransform(transform);
    }

    public String getToolTipText(MouseEvent e) {
        float pos1 = ScrollMouseHelper.getLowerPositionForVerticalScroll(e, this.scale, this.offset);
        float pos2 = ScrollMouseHelper.getUpperPositionForVerticalScroll(e, this.scale, this.offset);
        int[] indices = this.highlightedRowIndices;
        String tooltip = null;
        int index = ScrollMouseHelper.binarySearch(this.sizesAndPositions, this.highlightedRowIndices, pos1, pos2 - pos1);
        if (index < 0) {
            index = ScrollMouseHelper.binarySearch(this.sizesAndPositions, this.selectedRowIndices, pos1, pos2 - pos1);
            indices = this.selectedRowIndices;
        }
        if (index < 0) {
            index = ScrollMouseHelper.binarySearch(this.highlightedNodes, pos1, pos2 - pos1);
            if (index >= 0) {
                tooltip = this.highlightedNodes.get(index).getId();
            }
        } else {
            tooltip = DatasetUtil.getToolTipText(this.project.getSortedFilteredDataset(), indices[index], -1, null, null);
        }
        return tooltip;
    }

    @Override
    public void install(final JScrollBar scrollbar) {
        this.project = this.quickRowSearch.getProject();
        this.scrollbar = scrollbar;
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerticalScrollBarUIHelper.this.project.getRowSelectionModel().removeSelectionListener(VerticalScrollBarUIHelper.this.selectionListener);
                VerticalScrollBarUIHelper.this.project = VerticalScrollBarUIHelper.this.quickRowSearch.getProject();
                VerticalScrollBarUIHelper.this.project.getRowSelectionModel().addSelectionListener(VerticalScrollBarUIHelper.this.selectionListener);
                VerticalScrollBarUIHelper.access$302(VerticalScrollBarUIHelper.this, VerticalScrollBarUIHelper.this.quickRowSearch.getHighlightedIndices());
                VerticalScrollBarUIHelper.this.highlightedNodes = VerticalScrollBarUIHelper.this.project.getHighlightedRowDendrogramNodes();
                VerticalScrollBarUIHelper.access$502(VerticalScrollBarUIHelper.this, VerticalScrollBarUIHelper.this.project.getRowSelectionModel().getSelectedViewIndices());
                scrollbar.repaint();
            }
        };
        this.quickRowSearch.addActionListener(this.actionListener);
        this.mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JScrollPane sp;
                float pos1 = ScrollMouseHelper.getLowerPositionForVerticalScroll(e, VerticalScrollBarUIHelper.this.scale, VerticalScrollBarUIHelper.this.offset);
                float pos2 = ScrollMouseHelper.getUpperPositionForVerticalScroll(e, VerticalScrollBarUIHelper.this.scale, VerticalScrollBarUIHelper.this.offset);
                int index = ScrollMouseHelper.binarySearch(VerticalScrollBarUIHelper.this.sizesAndPositions, VerticalScrollBarUIHelper.this.highlightedRowIndices, pos1, pos2 - pos1);
                int[] indices = VerticalScrollBarUIHelper.this.highlightedRowIndices;
                if (index < 0) {
                    index = ScrollMouseHelper.binarySearch(VerticalScrollBarUIHelper.this.sizesAndPositions, VerticalScrollBarUIHelper.this.selectedRowIndices, pos1, pos2 - pos1);
                    indices = VerticalScrollBarUIHelper.this.selectedRowIndices;
                }
                if (index < 0) {
                    index = ScrollMouseHelper.binarySearch(VerticalScrollBarUIHelper.this.highlightedNodes, pos1, pos2 - pos1);
                    indices = null;
                }
                if (index >= 0 && (sp = UIUtil.getScrollPane(scrollbar)) != null) {
                    int position = indices == null ? (int)(((Node)VerticalScrollBarUIHelper.this.highlightedNodes.get(index)).getPosition() - VerticalScrollBarUIHelper.this.sizesAndPositions.getSize()) : (int)VerticalScrollBarUIHelper.this.sizesAndPositions.getPosition(indices[index]);
                    position = Math.max(0, position);
                    sp.getViewport().setViewPosition(new Point(0, position));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        this.mouseMotionListener = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                float pos1 = ScrollMouseHelper.getLowerPositionForVerticalScroll(e, VerticalScrollBarUIHelper.this.scale, VerticalScrollBarUIHelper.this.offset);
                float pos2 = ScrollMouseHelper.getUpperPositionForVerticalScroll(e, VerticalScrollBarUIHelper.this.scale, VerticalScrollBarUIHelper.this.offset);
                int index = ScrollMouseHelper.binarySearch(VerticalScrollBarUIHelper.this.sizesAndPositions, VerticalScrollBarUIHelper.this.highlightedRowIndices, pos1, pos2 - pos1);
                if (index < 0) {
                    index = ScrollMouseHelper.binarySearch(VerticalScrollBarUIHelper.this.sizesAndPositions, VerticalScrollBarUIHelper.this.selectedRowIndices, pos1, pos2 - pos1);
                }
                if (index < 0) {
                    index = ScrollMouseHelper.binarySearch(VerticalScrollBarUIHelper.this.highlightedNodes, pos1, pos2 - pos1);
                }
                if (index >= 0) {
                    scrollbar.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    scrollbar.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        };
        scrollbar.addMouseListener(this.mouseListener);
        scrollbar.addMouseMotionListener(this.mouseMotionListener);
        this.selectionListener = new SelectionListener(){

            @Override
            public void valueChanged(SelectionEvent e) {
                VerticalScrollBarUIHelper.access$502(VerticalScrollBarUIHelper.this, VerticalScrollBarUIHelper.this.project.getRowSelectionModel().getSelectedViewIndices());
                scrollbar.repaint();
            }
        };
        this.project.getRowSelectionModel().addSelectionListener(this.selectionListener);
    }

    @Override
    public void uninstall() {
        this.quickRowSearch.removeActionListener(this.actionListener);
        this.project.getRowSelectionModel().removeSelectionListener(this.selectionListener);
        this.scrollbar.removeMouseListener(this.mouseListener);
        this.scrollbar.removeMouseMotionListener(this.mouseMotionListener);
    }

    protected void drawHighlightedNodes(Graphics2D g2, int width) {
        if (this.highlightedNodes != null) {
            Paint paint = g2.getPaint();
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.width = width;
            rect.height = 1.8f;
            g2.setPaint(UIUtil.HIGHLIGHT_COLOR);
            for (Node node : this.highlightedNodes) {
                float ypix = node.getPosition();
                ypix = this.scale * ypix;
                rect.y = ypix + (float)this.offset - 1.0f;
                g2.fill(rect);
            }
            g2.setPaint(paint);
        }
    }

    private void draw(Graphics2D g2, Color color, int[] indices, int width) {
        Color oldColor = g2.getColor();
        g2.setColor(color);
        Rectangle2D.Float rect = new Rectangle2D.Float();
        rect.width = width;
        rect.height = 1.8f;
        for (int rowIdx : indices) {
            float ypix = this.sizesAndPositions.getPosition(rowIdx);
            ypix = this.scale * ypix;
            rect.y = ypix + (float)this.offset - 1.0f;
            g2.fill(rect);
        }
        g2.setColor(oldColor);
    }

    public static ScrollBarUI createScrollBarUI(QuickFilter quickFilter, SizesAndPositions sizesAndPositions) {
        String lookAndFeelName = UIManager.getLookAndFeel().getID();
        try {
            Class<?> c = Class.forName("org.broadinstitute.genee.gui.scroll." + lookAndFeelName + "SearchScrollBarUI");
            return (ScrollBarUI)c.getConstructor(ScrollBarUIHelper.class).newInstance(new VerticalScrollBarUIHelper(quickFilter, sizesAndPositions));
        }
        catch (Exception x) {
            return new BasicSearchScrollBarUI(new VerticalScrollBarUIHelper(quickFilter, sizesAndPositions));
        }
    }

    static /* synthetic */ int[] access$302(VerticalScrollBarUIHelper x0, int[] x1) {
        x0.highlightedRowIndices = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(VerticalScrollBarUIHelper x0, int[] x1) {
        x0.selectedRowIndices = x1;
        return x1;
    }
}

