/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.venn;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.venn.VennPanel;

public class EditColorDialog {
    private GENEEWindow dialog;
    private VennPanel venn;
    private Action colorSchemeAction;
    private String setAColor = "Set A Color";
    private String setBColor = "Set B Color";
    private String setCColor = "Set C Color";
    private String selectionColor = "Selection Color";
    private EditColorButton setAPanel;
    private EditColorButton setBPanel;
    private EditColorButton setCPanel;
    private EditColorButton selectionColorPanel;
    private JPanel p;

    public EditColorDialog(final VennPanel venn) {
        if (venn == null) {
            throw new NullPointerException();
        }
        this.venn = venn;
        FormLayout layout = new FormLayout("pref, 4dlu, pref", "pref, pref, pref, pref");
        layout.setRowGroups((int[][])new int[][]{{1}, {2}, {3}, {4}});
        CellConstraints cc = new CellConstraints();
        this.p = new JPanel((LayoutManager)layout);
        JLabel labelOne = new JLabel(this.setAColor);
        this.setAPanel = new EditColorButton(Color.RED);
        this.p.add((Component)labelOne, cc.xy(1, 1));
        this.p.add((Component)this.setAPanel, cc.xy(3, 1));
        JLabel labelTwo = new JLabel(this.setBColor);
        this.p.add((Component)labelTwo, cc.xy(1, 2));
        this.setBPanel = new EditColorButton(Color.BLUE);
        this.p.add((Component)this.setBPanel, cc.xy(3, 2));
        if (venn.getCount() == 3) {
            this.setCPanel = new EditColorButton(Color.GREEN);
            JLabel labelThree = new JLabel(this.setCColor);
            this.p.add((Component)labelThree, cc.xy(1, 3));
            this.p.add((Component)this.setCPanel, cc.xy(3, 3));
        }
        JLabel selectionColorLabel = new JLabel(this.selectionColor);
        this.p.add((Component)selectionColorLabel, cc.xy(1, 4));
        this.selectionColorPanel = new EditColorButton(Color.YELLOW);
        this.p.add((Component)this.selectionColorPanel, cc.xy(3, 4));
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditColorButton source = (EditColorButton)e.getSource();
                Color c = source.getColor();
                if (e.getSource() == EditColorDialog.this.selectionColor) {
                    venn.setSelectionColor(c);
                } else {
                    int index = -1;
                    if (source == EditColorDialog.this.setAPanel) {
                        index = 0;
                    } else if (source == EditColorDialog.this.setBPanel) {
                        index = 1;
                    } else if (source == EditColorDialog.this.setCPanel) {
                        index = 2;
                    } else {
                        throw new IllegalArgumentException("Unknown source " + e.getSource().getClass());
                    }
                    venn.setGeneSetColor(index, c);
                }
                venn.repaint();
            }
        };
        this.setAPanel.addActionListener(l);
        if (this.setBPanel != null) {
            this.setBPanel.addActionListener(l);
        }
        if (this.setCPanel != null) {
            this.setCPanel.addActionListener(l);
        }
        this.selectionColorPanel.addActionListener(l);
        this.colorSchemeAction = new AbstractAction("Color Scheme\u2026"){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditColorDialog.this.show();
            }
        };
    }

    public Action getColorSchemeAction() {
        return this.colorSchemeAction;
    }

    public void show() {
        if (this.dialog == null) {
            this.dialog = Application.createDialog(UIUtil.getWindowForComponent(this.venn), "Edit Colors");
            this.dialog.getContentPane().add(this.p);
            this.dialog.pack();
        }
        this.setAPanel.setColor(this.venn.getGeneSetAColor());
        if (this.setBPanel != null) {
            this.setBPanel.setColor(this.venn.getGeneSetBColor());
        }
        if (this.setCPanel != null) {
            this.setCPanel.setColor(this.venn.getGeneSetCColor());
        }
        this.selectionColorPanel.setColor(this.venn.getSelectionColor());
        this.dialog.setVisible(true);
    }
}

