/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.venn;

import com.jidesoft.swing.AutoResizingTextArea;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.ArrayTableModel;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.venn.EditColorDialog;
import org.broadinstitute.genee.gui.venn.VennPanel;
import org.broadinstitute.genee.heatmap.HeatMapToolBar;
import org.broadinstitute.genee.heatmap.menu.CopyImageAction;
import org.broadinstitute.genee.heatmap.menu.SaveImageAction;

public class VennDiagram {
    private final VennPanel vennPanel;
    private ArrayTableModel<String> tableModel;

    public VennDiagram() {
        GENEEWindow dialog = Application.createViewWindow("Venn Diagram");
        this.vennPanel = new VennPanel();
        this.tableModel = new ArrayTableModel();
        this.tableModel.setColumnName("No selection");
        JTable selectionTable = new JTable(this.tableModel);
        this.vennPanel.addSetSelectionListener(new VennPanel.SetSelectionListener(){

            @Override
            public void selectionChanged(VennPanel.SetSelectionEvent e) {
                if (e.getSet() != null) {
                    String name = e.getSet().toString();
                    VennDiagram.this.tableModel.setColumnName(name);
                    VennDiagram.this.tableModel.setArray(e.getSet().toArray(new String[0]));
                } else {
                    VennDiagram.this.tableModel.setColumnName("No selection");
                    VennDiagram.this.tableModel.setArray(null);
                }
            }
        });
        FormBuilder formBuilder = new FormBuilder();
        final AutoResizingTextArea[] textAreas = new AutoResizingTextArea[3];
        String[] names = new String[]{"A", "B", "C"};
        for (int i = 0; i < 3; ++i) {
            AutoResizingTextArea textArea = new AutoResizingTextArea(6, 10, 20);
            DefaultOverlayable overlay = new DefaultOverlayable((JComponent)UIUtil.createNoBorderScrollPane((Component)textArea));
            overlay.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)"{Enter one id per line:f:gray}"));
            formBuilder.nextSmallRow();
            formBuilder.addLabel(names[i] + ":");
            formBuilder.add((Component)overlay);
            textAreas[i] = textArea;
        }
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.add(UIUtil.createNoBorderScrollPane(formBuilder.getPanel()));
        JButton showButton = new JButton("Show");
        inputPanel.add((Component)UIUtil.buildOKBar(showButton), "South");
        showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set[] set = new Set[3];
                for (int i = 0; i < 3; ++i) {
                    HashSet<String> ids;
                    set[i] = ids = new HashSet<String>();
                    AutoResizingTextArea ta = textAreas[i];
                    String text = ta.getText();
                    StringTokenizer st = new StringTokenizer(text, "\n");
                    while (st.hasMoreTokens()) {
                        String s = st.nextToken().trim();
                        if ("".equals(s)) continue;
                        ids.add(s);
                    }
                }
                VennDiagram.this.vennPanel.setABC(set[0], set[1], set[2]);
            }
        });
        inputPanel.setMinimumSize(new Dimension());
        JSplitPane horizontalSplitter = new JSplitPane(1);
        horizontalSplitter.setLeftComponent(UIUtil.createScrollPane(this.vennPanel));
        JSplitPane verticalSplitter = new JSplitPane(0);
        verticalSplitter.setTopComponent(inputPanel);
        verticalSplitter.setBottomComponent(UIUtil.createScrollPane(selectionTable));
        verticalSplitter.setDividerLocation(350);
        horizontalSplitter.setRightComponent(verticalSplitter);
        dialog.getContentPane().add(horizontalSplitter);
        horizontalSplitter.setDividerLocation(this.vennPanel.getPreferredSize().width);
        JToolBar tb = new JToolBar();
        tb.setBorderPainted(false);
        tb.setFloatable(false);
        SaveImageAction saveImageAction = new SaveImageAction();
        saveImageAction.setJComponent(this.vennPanel);
        CopyImageAction copyImageAction = new CopyImageAction();
        copyImageAction.setJComponent(this.vennPanel);
        tb.add(HeatMapToolBar.createButton(saveImageAction));
        tb.add(HeatMapToolBar.createButton(copyImageAction));
        dialog.getContentPane().add((Component)tb, "North");
        dialog.pack();
        dialog.setVisible(true);
    }

    public void showOptionsDialog() {
        EditColorDialog editColorDialog = new EditColorDialog(this.vennPanel);
        editColorDialog.show();
    }
}

