/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.gui.venn;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JPanel;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.UIUtil;

public class VennPanel
extends JPanel
implements Drawable {
    private Area a;
    private String A = "A";
    private Area ab;
    private Area abc;
    private Set<String> abcSet;
    private Set<String> abSet;
    private Area ac;
    private Ellipse2D.Float aCircle;
    private Set<String> acSet;
    private HashMap<Area, Set<String>> area2SetMap;
    private Set<String> aSet;
    private Area b;
    private String B = "B";
    private Area bc;
    private Ellipse2D.Float bCircle;
    private Set<String> bcSet;
    private Set<String> bSet;
    private Area c;
    private String C = "C";
    private Ellipse2D.Float cCircle;
    private Set<String> cSet;
    private int diameter = 200;
    private boolean drawStrings = true;
    private Set<String> geneSetA = Collections.EMPTY_SET;
    private Set<String> geneSetB = Collections.EMPTY_SET;
    private Set<String> geneSetC = Collections.EMPTY_SET;
    private Color geneSetAColor = new Color(Color.RED.getRed(), Color.RED.getGreen(), Color.RED.getBlue(), 100);
    private Color geneSetBColor = new Color(Color.BLUE.getRed(), Color.BLUE.getGreen(), Color.BLUE.getBlue(), 100);
    private Color geneSetCColor = new Color(Color.GREEN.getRed(), Color.GREEN.getGreen(), Color.GREEN.getBlue(), 100);
    private Area selectedArea;
    private Color selectionColor = UIUtil.SELECTION_COLOR;
    private int tx;
    private int ty;
    private float x1;
    private int x2;
    private float x3;

    public VennPanel() {
        this.setBackground(Color.WHITE);
        this.aSet = new HashSet<String>(){

            @Override
            public String toString() {
                return VennPanel.this.A + " - " + VennPanel.this.B + (VennPanel.this.geneSetC != null ? " - " + VennPanel.this.C : "");
            }
        };
        this.abcSet = new HashSet<String>(){

            @Override
            public String toString() {
                return VennPanel.this.A + " \u22c2 " + VennPanel.this.B + (VennPanel.this.geneSetC != null ? " \u22c2 " + VennPanel.this.C : "");
            }
        };
        this.abSet = new HashSet<String>(){

            @Override
            public String toString() {
                return VennPanel.this.A + "  \u22c2 " + VennPanel.this.B + (VennPanel.this.geneSetC != null ? " - " + VennPanel.this.C : "");
            }
        };
        this.cSet = new HashSet<String>(){

            @Override
            public String toString() {
                return (VennPanel.this.geneSetC != null ? VennPanel.this.C + " - " : "") + VennPanel.this.A + " - " + VennPanel.this.B;
            }
        };
        this.acSet = new HashSet<String>(){

            @Override
            public String toString() {
                return VennPanel.this.A + (VennPanel.this.geneSetC != null ? " \u22c2 " + VennPanel.this.C : "") + " - " + VennPanel.this.B;
            }
        };
        this.bSet = new HashSet<String>(){

            @Override
            public String toString() {
                return VennPanel.this.B + " - " + VennPanel.this.A + (VennPanel.this.geneSetC != null ? " - " + VennPanel.this.C : "");
            }
        };
        this.bcSet = new HashSet<String>(){

            @Override
            public String toString() {
                return VennPanel.this.B + (VennPanel.this.geneSetC != null ? " \u22c2 " + VennPanel.this.C : "") + " - " + VennPanel.this.A;
            }
        };
        this.x1 = (float)this.diameter / 2.0f;
        this.aCircle = new Ellipse2D.Float(0.0f, 0.0f, this.diameter, this.diameter);
        this.x2 = this.diameter;
        this.bCircle = new Ellipse2D.Float((float)this.diameter / 2.0f, 0.0f, this.diameter, this.diameter);
        this.x3 = ((float)(this.x2 * this.x2) - this.x1 * this.x1) / ((float)(2 * this.x2) - 2.0f * this.x1);
        this.x3 -= (float)this.diameter / 2.0f;
        if (this.geneSetC != null) {
            this.cCircle = new Ellipse2D.Float(this.x3, (float)this.diameter / 2.0f, this.diameter, this.diameter);
        }
        this.a = new Area(this.aCircle);
        this.b = new Area(this.bCircle);
        if (this.geneSetC != null) {
            this.c = new Area(this.cCircle);
        }
        Area all = new Area();
        all.add(this.a);
        all.add(this.b);
        if (this.geneSetC != null) {
            all.add(this.c);
        }
        this.abc = (Area)all.clone();
        this.abc.intersect(this.a);
        this.abc.intersect(this.b);
        if (this.geneSetC != null) {
            this.abc.intersect(this.c);
        }
        this.ab = (Area)all.clone();
        this.ab.intersect(this.a);
        this.ab.intersect(this.b);
        if (this.geneSetC != null) {
            this.ab.subtract(this.c);
        }
        this.ac = (Area)all.clone();
        this.ac.intersect(this.a);
        if (this.geneSetC != null) {
            this.ac.intersect(this.c);
        }
        this.ac.subtract(this.b);
        this.bc = (Area)all.clone();
        this.bc.intersect(this.b);
        if (this.geneSetC != null) {
            this.bc.intersect(this.c);
        }
        this.bc.subtract(this.a);
        this.a = (Area)this.a.clone();
        this.a.subtract(new Area(this.bCircle));
        if (this.geneSetC != null) {
            this.a.subtract(new Area(this.cCircle));
        }
        this.b = (Area)this.b.clone();
        this.b.subtract(new Area(this.aCircle));
        if (this.geneSetC != null) {
            this.b.subtract(new Area(this.cCircle));
        }
        if (this.geneSetC != null) {
            this.c = (Area)this.c.clone();
            this.c.subtract(new Area(this.aCircle));
            this.c.subtract(new Area(this.bCircle));
        }
        this.setABC(this.geneSetA, this.geneSetB, this.geneSetC);
        if (!GraphicsEnvironment.isHeadless()) {
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    VennPanel.this.selectedArea = VennPanel.this.find(e.getX(), e.getY());
                    VennPanel.this.repaint();
                    VennPanel.this.notifyListeners(VennPanel.this.getSelectedSet());
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
        }
    }

    public void addSetSelectionListener(SetSelectionListener l) {
        this.listenerList.add(SetSelectionListener.class, l);
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(UIUtil.RENDERING_HINTS);
        int width = (int)(this.x1 + (float)this.diameter);
        int height = this.diameter + this.diameter / 2;
        this.tx = ((int)clip.getWidth() - width) / 2;
        this.ty = ((int)clip.getHeight() - height) / 2;
        g.translate(this.tx, this.ty);
        g.setColor(Color.BLACK);
        this.fillSets(g2);
        Composite c1 = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
        this.fillSets(g2);
        g2.setComposite(c1);
        if (this.selectedArea != null) {
            g2.setColor(this.selectionColor);
            g2.fill(this.selectedArea);
        }
        g2.setColor(Color.BLACK);
        if (this.drawStrings) {
            for (Area area : this.area2SetMap.keySet()) {
                Set<String> set = this.area2SetMap.get(area);
                if (set.size() <= 0) continue;
                Rectangle2D bounds = area.getBounds2D();
                String s = "" + set.size();
                int x = (int)(bounds.getCenterX() - (double)(g2.getFontMetrics().stringWidth(s) / 2));
                int y = (int)(bounds.getCenterY() + (double)g2.getFontMetrics().getAscent());
                g2.drawString(s, x, y);
            }
        }
        Font oldFont = g.getFont();
        g.setFont(new Font(oldFont.getName(), 0, 10));
        if (this.drawStrings) {
            String name;
            if (this.geneSetA != null) {
                name = "A";
                g.drawString(name, (int)this.aCircle.getCenterX() - g.getFontMetrics().stringWidth(name), (int)this.aCircle.getMinY() - g.getFontMetrics().getDescent() - 2);
            }
            if (this.geneSetB != null) {
                name = "B";
                g.drawString(name, (int)this.bCircle.getCenterX(), (int)this.bCircle.getMinY() - g.getFontMetrics().getDescent() - 2);
            }
            if (this.geneSetC != null) {
                name = "C";
                g.drawString(name, (int)this.cCircle.getCenterX() - g.getFontMetrics().stringWidth(name) / 2, (int)this.cCircle.getMaxY() + g.getFontMetrics().getAscent() + 2);
            }
        }
        g.setFont(oldFont);
    }

    public int getCount() {
        return this.c != null ? 3 : 2;
    }

    @Override
    public Dimension getDrawableSize() {
        return new Dimension(this.diameter * 2, this.diameter * 2);
    }

    public Color getGeneSetAColor() {
        return this.geneSetAColor;
    }

    public Color getGeneSetBColor() {
        return this.geneSetBColor;
    }

    public Color getGeneSetCColor() {
        return this.geneSetCColor;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.diameter * 2, this.diameter * 2);
    }

    public Set<String> getSelectedSet() {
        return this.area2SetMap.get(this.selectedArea);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void notifyListeners(Set<String> set) {
        SetSelectionEvent e = new SetSelectionEvent(this, set);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SetSelectionListener.class) continue;
            ((SetSelectionListener)listeners[i + 1]).selectionChanged(e);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void removeSetSelectionListener(SetSelectionListener l) {
        this.listenerList.remove(SetSelectionListener.class, l);
    }

    public void setABC(Set<String> set1, Set<String> set2, Set<String> set3) {
        this.geneSetA = set1;
        this.geneSetB = set2;
        this.geneSetC = set3;
        this.aSet.clear();
        this.abcSet.clear();
        this.abSet.clear();
        this.acSet.clear();
        this.bSet.clear();
        this.bcSet.clear();
        this.cSet.clear();
        Set<String> aMembers = set1;
        Set<String> bMembers = set2;
        Set<String> cMembers = set3;
        if (aMembers != null) {
            for (String member : aMembers) {
                if (!bMembers.contains(member) && !cMembers.contains(member)) {
                    this.aSet.add(member);
                    continue;
                }
                if (bMembers.contains(member) && cMembers.contains(member)) {
                    this.abcSet.add(member);
                    continue;
                }
                if (bMembers.contains(member)) {
                    this.abSet.add(member);
                    continue;
                }
                if (!cMembers.contains(member)) continue;
                this.acSet.add(member);
            }
        }
        if (bMembers != null) {
            for (String member : bMembers) {
                if (!aMembers.contains(member) && !cMembers.contains(member)) {
                    this.bSet.add(member);
                    continue;
                }
                if (!cMembers.contains(member) || aMembers.contains(member)) continue;
                this.bcSet.add(member);
            }
        }
        if (cMembers != null) {
            for (String member : cMembers) {
                if (aMembers.contains(member) || bMembers.contains(member)) continue;
                this.cSet.add(member);
            }
        }
        this.area2SetMap = new LinkedHashMap<Area, Set<String>>();
        this.area2SetMap.put(this.ab, this.abSet);
        this.area2SetMap.put(this.a, this.aSet);
        this.area2SetMap.put(this.b, this.bSet);
        if (this.geneSetC != null) {
            this.area2SetMap.put(this.ac, this.acSet);
            this.area2SetMap.put(this.abc, this.abcSet);
            this.area2SetMap.put(this.c, this.cSet);
            this.area2SetMap.put(this.bc, this.bcSet);
        }
        this.repaint();
        this.notifyListeners(this.getSelectedSet());
    }

    public void setGeneSetAColor(Color geneSetAColor) {
        this.geneSetAColor = geneSetAColor;
    }

    public void setGeneSetBColor(Color geneSetBColor) {
        this.geneSetBColor = geneSetBColor;
    }

    public void setGeneSetCColor(Color geneSetCColor) {
        this.geneSetCColor = geneSetCColor;
    }

    public void setGeneSetColor(int index, Color c) {
        switch (index) {
            case 0: {
                this.geneSetAColor = c;
                break;
            }
            case 1: {
                this.geneSetBColor = c;
                break;
            }
            case 2: {
                this.geneSetCColor = c;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown index: " + index);
            }
        }
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    private void fillSets(Graphics2D g2) {
        g2.setColor(this.geneSetAColor);
        g2.fill(this.aCircle);
        g2.setColor(this.geneSetBColor);
        g2.fill(this.bCircle);
        if (this.geneSetC != null) {
            g2.setColor(this.geneSetCColor);
            g2.fill(this.cCircle);
        }
    }

    private Area find(int xpix, int ypix) {
        boolean found = false;
        Area newSelectedArea = null;
        int x = xpix - this.tx;
        int y = ypix - this.ty;
        Iterator<Area> it = this.area2SetMap.keySet().iterator();
        while (it.hasNext() && !found) {
            Area area = it.next();
            if (!area.contains(x, y)) continue;
            newSelectedArea = area;
            found = true;
        }
        if (!found) {
            newSelectedArea = null;
        }
        return newSelectedArea;
    }

    public static interface SetSelectionListener
    extends EventListener {
        public void selectionChanged(SetSelectionEvent var1);
    }

    public static class SetSelectionEvent
    extends EventObject {
        private Set<String> set;

        public SetSelectionEvent(Object source, Set<String> set) {
            super(source);
            this.set = set;
        }

        public Set<String> getSet() {
            return this.set;
        }
    }
}

