/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.SelectionEvent;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.heatmap.SelectionModel;

public abstract class AbstractSelectionModel
implements SelectionModel {
    protected EventListenerList listenerList = new UniqueEventListenerList();
    protected Project project;
    protected int[] selectedIndices = new int[0];
    protected boolean updateModelFromView;
    protected ListSelectionListener viewListSelectionListener;
    protected ListSelectionModel viewSelectionModel;
    private boolean ignoreEvent;

    AbstractSelectionModel(Project project) {
        this.project = project;
        this.viewSelectionModel = new DefaultListSelectionModel(){

            @Override
            public void setValueIsAdjusting(boolean isAdjusting) {
                AbstractSelectionModel.this.ignoreEvent = true;
                super.setValueIsAdjusting(isAdjusting);
                AbstractSelectionModel.this.ignoreEvent = false;
            }
        };
        this.viewListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!AbstractSelectionModel.this.ignoreEvent) {
                    AbstractSelectionModel.this.updateModelFromView = true;
                    AbstractSelectionModel.this.notifyListeners();
                }
            }
        };
        this.viewSelectionModel.addListSelectionListener(this.viewListSelectionListener);
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public SelectionListener[] getListeners() {
        return (SelectionListener[])this.listenerList.getListeners(SelectionListener.class);
    }

    public int getSelectedModelCount() {
        if (this.updateModelFromView) {
            this.updateModelFromView();
        }
        return this.selectedIndices.length;
    }

    @Override
    public int[] getSelectedModelIndices() {
        if (this.updateModelFromView) {
            this.updateModelFromView();
        }
        return this.selectedIndices;
    }

    @Override
    public abstract int[] getSelectedViewIndices();

    @Override
    public int getSelectionCount() {
        int[] selection = this.getSelectedModelIndices();
        return selection == null ? 0 : selection.length;
    }

    @Override
    public ListSelectionModel getViewSelectionModel() {
        return this.viewSelectionModel;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.viewSelectionModel.isSelectionEmpty();
    }

    @Override
    public boolean isViewIndexSelected(int index) {
        return this.viewSelectionModel.isSelectedIndex(index);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    @Override
    public void setSelectedModelIndices(int[] indices) {
        if (indices == null) {
            indices = new int[]{};
        }
        this.selectedIndices = indices;
        this.updateModelFromView = false;
        this.updateViewFromModel(indices);
        this.notifyListeners();
    }

    protected void notifyListeners() {
        Object[] listeners = this.listenerList.getListenerList();
        SelectionEvent e = new SelectionEvent(this.project);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    protected abstract void updateModelFromView();

    protected abstract void updateViewFromModel(int[] var1);

    ListSelectionListener getViewListSelectionListener() {
        return this.viewListSelectionListener;
    }
}

