/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jidesoft.swing.CheckBoxList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEWindow;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.AbstractProjectSortKey;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.SortLevelComponent;
import org.broadinstitute.genee.heatmap.SortOrder;

public abstract class AbstractSortDialog {
    protected HeatMapPanel heatMapPanel;
    protected List<SortLevelComponent> sortComponents = new ArrayList<SortLevelComponent>();
    private GENEEWindow dialog;
    private JPanel panel;
    private boolean sortRows;
    private CheckBoxList groupByList;

    public AbstractSortDialog(HeatMapPanel heatMapPanel, boolean sortRows) {
        this.heatMapPanel = heatMapPanel;
        this.sortRows = sortRows;
        this.panel = this.buildUI();
    }

    public void show() {
        List<ProjectSortKey> items = this.createComboBoxItems();
        if (items.size() == 0) {
            UIUtil.showErrorDialog(UIUtil.getCurrentFrame(), "No sortable columns found.");
            throw new RuntimeException();
        }
        for (SortLevelComponent sortLevelComponent : this.sortComponents) {
            sortLevelComponent.setSortKeys(items);
        }
        final ArrayList<ProjectSortKey> groupByItems = new ArrayList<ProjectSortKey>();
        for (ProjectSortKey item : items) {
            if (item instanceof EmptySortKey) continue;
            groupByItems.add(item);
        }
        this.groupByList.setModel((ListModel)new AbstractListModel(){

            @Override
            public int getSize() {
                return groupByItems.size();
            }

            @Override
            public Object getElementAt(int index) {
                return groupByItems.get(index);
            }
        });
        Project project = Application.getProject();
        List<? extends ProjectSortKey> priorSortKeys = this.sortRows ? project.getRowSortKeys() : project.getColumnSortKeys();
        Object[] groupBy = this.sortRows ? project.getRowGroupBy() : project.getColumnGroupBy();
        this.groupByList.clearCheckBoxListSelection();
        this.groupByList.addCheckBoxListSelectedValues(groupBy);
        for (int i = 0; i < this.sortComponents.size(); ++i) {
            if (i < priorSortKeys.size()) {
                ProjectSortKey sortKey = priorSortKeys.get(i);
                this.sortComponents.get(i).setPropertiesFrom(sortKey);
                continue;
            }
            this.sortComponents.get(i).setPropertiesFrom(null);
        }
        if (this.dialog == null) {
            this.dialog = Application.createDialog("Sort " + (this.sortRows ? "Rows" : "Columns"));
            JPanel p = new JPanel(new BorderLayout());
            JPanel okCancelPanel = UIUtil.buildOKCancelBar(this.dialog, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractSortDialog.this.dialog.setVisible(false);
                    boolean sorted = AbstractSortDialog.this.sortComponents.get(0).isSorted();
                    if (!sorted) {
                        AbstractSortDialog.this.setSortOrder(null);
                    } else {
                        List<ProjectSortKey> sortKeys = AbstractSortDialog.this.getSortKeys();
                        AbstractSortDialog.this.setSortOrder(sortKeys);
                    }
                    Object[] groupBy = AbstractSortDialog.this.groupByList.getCheckBoxListSelectedValues();
                    ProjectSortKey[] keys = new ProjectSortKey[groupBy.length];
                    for (int i = 0; i < keys.length; ++i) {
                        keys[i] = (ProjectSortKey)groupBy[i];
                    }
                    AbstractSortDialog.this.setGroupBy(keys);
                }
            });
            p.add(this.panel);
            p.add((Component)okCancelPanel, "South");
            this.dialog.getContentPane().add(p);
            this.dialog.pack();
            this.dialog.setSize(this.dialog.getWidth() + 50, this.dialog.getHeight());
        }
        this.dialog.setVisible(true);
    }

    protected final JPanel buildUI() {
        FormBuilder sortByBuilder = new FormBuilder();
        this.sortComponents.add(this.createSortLevel(sortByBuilder, true));
        for (int i = 0; i < 8; ++i) {
            sortByBuilder.addSeparator();
            this.sortComponents.add(this.createSortLevel(sortByBuilder, false));
        }
        sortByBuilder.nextRow();
        sortByBuilder.addSeparator();
        FormBuilder groupByBuilder = new FormBuilder();
        groupByBuilder.nextRow();
        groupByBuilder.addFirstColumn(groupByBuilder.addLabel("Group by:"));
        this.groupByList = new CheckBoxList();
        this.groupByList.setVisibleRowCount(10);
        groupByBuilder.add(new JScrollPane((Component)this.groupByList));
        groupByBuilder.nextRow();
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane(sortByBuilder.getPanel());
        sp.setBorder(null);
        panel.add(sp);
        FormBuilder.setToMaxWidth(groupByBuilder, sortByBuilder);
        panel.add((Component)groupByBuilder.getPanel(), "South");
        return panel;
    }

    protected abstract List<ProjectSortKey> createComboBoxItems();

    protected List<ProjectSortKey> getSortKeys() {
        int sortLevelCount = 0;
        for (int j = 0; j < this.sortComponents.size(); ++j) {
            if (!this.sortComponents.get(j).isSorted()) continue;
            ++sortLevelCount;
        }
        ProjectSortKey[] sortKeys = new ProjectSortKey[sortLevelCount];
        int sortLevelIndex = 0;
        for (int j = 0; j < this.sortComponents.size(); ++j) {
            if (!this.sortComponents.get(j).isSorted()) continue;
            SortOrder sortOrder = this.sortComponents.get(j).getSortOrder();
            ProjectSortKey sortKey = this.sortComponents.get(j).getSortKey();
            sortKey.setSortOrder(sortOrder);
            sortKeys[sortLevelIndex] = sortKey;
            ++sortLevelIndex;
        }
        return Arrays.asList(sortKeys);
    }

    protected abstract void setGroupBy(ProjectSortKey[] var1);

    protected abstract void setSortOrder(List<ProjectSortKey> var1);

    private SortLevelComponent createSortLevel(FormBuilder builder, boolean primary) {
        JComboBox sortKeyComboBox = UIUtil.createComboBox();
        builder.nextRow();
        JLabel sortKeyLabel = builder.addLabel(primary ? "Sort by:" : "Then by:");
        builder.addFirstColumn(sortKeyLabel);
        builder.add(sortKeyComboBox);
        builder.nextSmallRow();
        JComboBox sortOrderComboBox = UIUtil.createComboBox((Object[])new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING});
        SortLevelComponent sortLevelComponent = new SortLevelComponent(sortKeyComboBox, sortOrderComboBox);
        builder.addLabel("Order:");
        builder.add(sortOrderComboBox);
        return sortLevelComponent;
    }

    protected static class EmptySortKey
    extends AbstractProjectSortKey {
        public static final EmptySortKey INSTANCE = new EmptySortKey();

        private EmptySortKey() {
            super(SortOrder.UNSORTED);
        }

        @Override
        public Comparable<?> getValue(int index) {
            return null;
        }

        public String toString() {
            return "(none)";
        }
    }
}

