/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.SliderPanel;
import org.broadinstitute.genee.heatmap.HeatMapPanel;

public class ColorBarDisplayOptions {
    private SliderPanel columnCategoriesSliderPanel;
    private HeatMapPanel heatMapPanel;
    private SliderPanel rowCategoriesSliderPanel;
    private JCheckBox showColumnCategoriesGrid;
    private JCheckBox showRowCategoriesGrid;

    public ColorBarDisplayOptions(final HeatMapPanel heatMapPanel, FormBuilder formBuilder) {
        this.heatMapPanel = heatMapPanel;
        formBuilder.addLabel("Column color bar height:");
        this.columnCategoriesSliderPanel = new SliderPanel(heatMapPanel.getColumnCategoryPanel().getSizePerClass(), 1.0f, 60.0f, 1.0f);
        this.columnCategoriesSliderPanel.setLabels(new int[]{1, 10, 20, 30, 40, 50, 60}, 1);
        this.columnCategoriesSliderPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                heatMapPanel.getColumnCategoryPanel().setSizePerClass((int)ColorBarDisplayOptions.this.columnCategoriesSliderPanel.getValue());
            }
        });
        formBuilder.add(this.columnCategoriesSliderPanel);
        this.columnCategoriesSliderPanel.setEnabled(heatMapPanel.getProject().getOriginalDataset().getColumnMetadata().getMetadataCount() > 0);
        formBuilder.nextSmallRow();
        formBuilder.addLabel("Row color bar width:");
        this.rowCategoriesSliderPanel = new SliderPanel(heatMapPanel.getRowCategoryPanel().getSizePerClass(), 1.0f, 60.0f, 1.0f);
        this.rowCategoriesSliderPanel.setLabels(new int[]{1, 10, 20, 30, 40, 50, 60}, 1);
        this.rowCategoriesSliderPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                heatMapPanel.getRowCategoryPanel().setSizePerClass((int)ColorBarDisplayOptions.this.rowCategoriesSliderPanel.getValue());
            }
        });
        formBuilder.add(this.rowCategoriesSliderPanel);
        this.rowCategoriesSliderPanel.setEnabled(heatMapPanel.getProject().getOriginalDataset().getRowMetadata().getMetadataCount() > 0);
        formBuilder.nextSmallRow();
        this.showColumnCategoriesGrid = new JCheckBox("Show column color bar grid", heatMapPanel.getColumnCategoryPanel().isGridVisible());
        formBuilder.addSpanned(this.showColumnCategoriesGrid);
        formBuilder.nextSmallRow();
        this.showRowCategoriesGrid = new JCheckBox("Show row color bar grid", heatMapPanel.getRowCategoryPanel().isGridVisible());
        formBuilder.addSpanned(this.showRowCategoriesGrid);
        this.showColumnCategoriesGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                heatMapPanel.getColumnCategoryPanel().setGridVisible(ColorBarDisplayOptions.this.showColumnCategoriesGrid.isSelected());
                heatMapPanel.getColumnCategoryPanel().repaint();
            }
        });
        this.showRowCategoriesGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                heatMapPanel.getRowCategoryPanel().setGridVisible(ColorBarDisplayOptions.this.showRowCategoriesGrid.isSelected());
                heatMapPanel.getRowCategoryPanel().repaint();
            }
        });
    }

    void configureValues() {
        this.columnCategoriesSliderPanel.setValue(this.heatMapPanel.getColumnCategoryPanel().getSizePerClass(), false);
        this.showColumnCategoriesGrid.setSelected(this.heatMapPanel.getColumnCategoryPanel().isGridVisible());
        this.showRowCategoriesGrid.setSelected(this.heatMapPanel.getRowCategoryPanel().isGridVisible());
    }
}

