/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import org.broadinstitute.genee.heatmap.Grouper;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.table.SortingHelper;

public class ColumnGrouper
implements Grouper {
    @Override
    public float[] group(Project project) {
        ProjectSortKey[] sortKeys = project.getColumnGroupBy();
        Dataset dataset = project.getSortedFilteredDataset();
        float[] sizes = new float[dataset.getColumnCount()];
        if (sortKeys != null && sortKeys.length > 0) {
            int nkeys = sortKeys.length;
            for (int n = 0; n < nkeys; ++n) {
                sortKeys[n].init(project);
            }
            Identifier previous = SortingHelper.createIdentifier(sortKeys, nkeys, project.convertViewColumnIndexToModel(0));
            int cols = dataset.getColumnCount();
            for (int i = 1; i < cols; ++i) {
                int currentIndex = project.convertViewColumnIndexToModel(i);
                Identifier current = SortingHelper.createIdentifier(sortKeys, nkeys, currentIndex);
                if (previous == null) {
                    if (current != null) {
                        sizes[i - 1] = 10.0f;
                    }
                } else if (!((Object)previous).equals(current)) {
                    sizes[i - 1] = 10.0f;
                }
                previous = current;
            }
        }
        return sizes;
    }
}

