/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import org.broadinstitute.genee.heatmap.CurveElement;
import org.broadinstitute.genee.heatmap.CurveElementList;
import org.broadinstitute.genee.io.util.ToStringUtil;
import org.broadinstitute.genee.math.stat.function.UnivariateFloatFunction;

public class DefaultCurveElement
implements CurveElement,
CurveElementList {
    private UnivariateFloatFunction function;
    private float[] x;
    private float[] y;
    private float specialX = Float.NaN;
    private float[] yErrors;

    @Override
    public boolean containsFit() {
        return this.function != null;
    }

    @Override
    public float evaluate(float x) {
        return this.function.evaluate(x);
    }

    @Override
    public CurveElement get(int index) {
        return this;
    }

    public UnivariateFloatFunction getFunction() {
        return this.function;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public float getSpecialX() {
        return this.specialX;
    }

    public float[] getX() {
        return this.x;
    }

    @Override
    public float getX(int i) {
        return this.x[i];
    }

    public float[] getY() {
        return this.y;
    }

    @Override
    public float getY(int i) {
        return this.y[i];
    }

    @Override
    public float getYError(int i) {
        return this.yErrors[i];
    }

    public void setFunction(UnivariateFloatFunction function) {
        this.function = function;
    }

    public void setSpecialX(float specialX) {
        this.specialX = specialX;
    }

    public void setX(float[] x) {
        this.x = x;
    }

    public void setY(float[] y, float[] yErrors) {
        this.y = y;
        this.yErrors = yErrors;
    }

    @Override
    public int size() {
        return this.x.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("x: ");
        sb.append(ToStringUtil.toString(this.x, ", "));
        sb.append("<br>y: ");
        sb.append(ToStringUtil.toString(this.y, ", "));
        return sb.toString();
    }
}

