/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import org.broadinstitute.genee.application.UniqueEventListenerList;
import org.broadinstitute.genee.category.DefaultVectorColorModel;
import org.broadinstitute.genee.category.VectorColorModel;
import org.broadinstitute.genee.clustering.hierarchical.Dendrogram;
import org.broadinstitute.genee.clustering.hierarchical.Node;
import org.broadinstitute.genee.filter.Filter;
import org.broadinstitute.genee.heatmap.AbstractSelectionModel;
import org.broadinstitute.genee.heatmap.ColumnSelectionModel;
import org.broadinstitute.genee.heatmap.DefaultElementSelectionModel;
import org.broadinstitute.genee.heatmap.ElementSelectionModel;
import org.broadinstitute.genee.heatmap.FilterEvent;
import org.broadinstitute.genee.heatmap.FilterListener;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.heatmap.ProjectEvent;
import org.broadinstitute.genee.heatmap.ProjectListener;
import org.broadinstitute.genee.heatmap.ProjectSortKey;
import org.broadinstitute.genee.heatmap.RowSelectionModel;
import org.broadinstitute.genee.heatmap.SelectionListener;
import org.broadinstitute.genee.heatmap.SelectionModel;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.table.ColumnSorter;
import org.broadinstitute.genee.table.ProjectSorter;
import org.broadinstitute.genee.table.RowSorter;

public class DefaultProject
implements Project {
    private VectorColorModel columnCategoryColorModel;
    private Dendrogram columnDendrogram;
    private Map<Integer, Integer> columnModelToView;
    private AbstractSelectionModel columnSelectionModel;
    private ProjectSorter columnSorter = new ColumnSorter();
    private int[] columnSortOrder;
    private Dataset dataset;
    private ElementSelectionModel elementSelectionModel = new DefaultElementSelectionModel();
    private FilterListener filterListener;
    private Filter rowFilter;
    private List<Node> highlightedColumnDendrogramNodes;
    private List<Node> highlightedRowDendrogramNodes;
    private EventListenerList listenerList = new UniqueEventListenerList();
    private TIntHashSet maskedModelColumnIndices;
    private TIntHashSet maskedModelRowIndices;
    private VectorColorModel rowCategoryColorModel;
    private Dendrogram rowDendrogram;
    private Map<Integer, Integer> rowModelToView;
    private AbstractSelectionModel rowSelectionModel;
    private ProjectSorter rowSorter = new RowSorter();
    private int[] rowSortOrder;
    private int[] rowViewOrder;
    private TIntHashSet maskedViewColumnIndices = this.createViewColumnMask();
    private TIntHashSet maskedViewRowIndices = this.createViewRowMask();
    private Comparator<String> rowIdComparator = String.CASE_INSENSITIVE_ORDER;
    private Comparator<String> columnIdComparator = String.CASE_INSENSITIVE_ORDER;
    private DefaultListSelectionModel viewRowCategoriesSelectionModel = new DefaultListSelectionModel();
    private ProjectSortKey[] rowGroupBy = new ProjectSortKey[0];
    private ProjectSortKey[] columnGroupBy = new ProjectSortKey[0];
    private String id = String.valueOf(instanceCounter++);
    private static int instanceCounter = 0;

    public DefaultProject() {
        this(null, null, null, null);
    }

    public DefaultProject(Dataset dataset) {
        this(dataset, null);
    }

    public DefaultProject(Dataset dataset, Dendrogram rowDendrogram, Dendrogram columnDendrogram, Project parentProject) {
        this(dataset, rowDendrogram, columnDendrogram, parentProject, null, null);
    }

    public DefaultProject(Dataset dataset, Dendrogram rowDendrogram, Dendrogram columnDendrogram, VectorColorModel rowCategoryColorModel, VectorColorModel columnCategoryColorModel) {
        this(dataset, rowDendrogram, columnDendrogram, null, rowCategoryColorModel, columnCategoryColorModel);
    }

    public DefaultProject(Dataset dataset, Project parentProject) {
        this(dataset, null, null, parentProject);
    }

    public DefaultProject(Project parentProject) {
        this(null, parentProject);
    }

    private DefaultProject(Dataset dataset, Dendrogram rowDendrogram, Dendrogram columnDendrogram, Project parentProject, VectorColorModel rowCategoryColorModel, VectorColorModel columnCategoryColorModel) {
        if (rowDendrogram != null) {
            this.rowDendrogram = rowDendrogram;
        }
        if (columnDendrogram != null) {
            this.columnDendrogram = columnDendrogram;
        }
        if (dataset != null) {
            this.dataset = dataset;
        }
        this.rowSelectionModel = this.createRowSelectionModel();
        this.columnSelectionModel = this.createColumnSelectionModel();
        if (parentProject != null) {
            this.setParentProject(parentProject);
        } else {
            this.rowCategoryColorModel = rowCategoryColorModel == null ? new DefaultVectorColorModel() : rowCategoryColorModel;
            this.columnCategoryColorModel = columnCategoryColorModel == null ? new DefaultVectorColorModel() : columnCategoryColorModel;
        }
        this.filterListener = new FilterListener(){

            @Override
            public void filterChanged(FilterEvent e) {
                ProjectEvent evt = new ProjectEvent(DefaultProject.this, 7);
                DefaultProject.this.updateRowMappings();
                DefaultProject.this.fireProjectChanged(evt);
            }
        };
    }

    @Override
    public void addColumnSelectionListener(SelectionListener l) {
        this.columnSelectionModel.addSelectionListener(l);
    }

    @Override
    public void addProjectListener(ProjectListener l) {
        this.listenerList.add(ProjectListener.class, l);
    }

    @Override
    public void addToColumnMask(int[] viewIndices) {
        if (this.maskedModelColumnIndices == null) {
            this.maskedModelColumnIndices = new TIntHashSet();
        }
        int length = viewIndices.length;
        for (int i = 0; i < length; ++i) {
            this.maskedModelColumnIndices.add(this.convertViewColumnIndexToModel(viewIndices[i]));
        }
        this.updateColumnViewMaskFromModel();
        this.fireProjectChanged(new ProjectEvent(this, 12));
    }

    @Override
    public void addToRowMask(int[] viewIndices) {
        if (this.maskedModelRowIndices == null) {
            this.maskedModelRowIndices = new TIntHashSet();
        }
        int length = viewIndices.length;
        for (int i = 0; i < length; ++i) {
            int index = this.convertViewRowIndexToModel(viewIndices[i]);
            this.maskedModelRowIndices.add(index);
        }
        this.updateRowViewMaskFromModel();
        this.fireProjectChanged(new ProjectEvent(this, 1));
    }

    @Override
    public void clearColumnMask() {
        this._clearColumnMask(true);
    }

    @Override
    public void clearRowMask() {
        this._clearRowMask(true);
    }

    @Override
    public int convertModelColumnIndexToView(int modelColumnIndex) {
        if (this.columnModelToView != null) {
            Integer index = this.columnModelToView.get(modelColumnIndex);
            return index != null ? index : -1;
        }
        return modelColumnIndex;
    }

    @Override
    public int convertModelRowIndexToView(int modelRowIndex) {
        if (this.rowModelToView != null) {
            Integer index = this.rowModelToView.get(modelRowIndex);
            return index != null ? index : -1;
        }
        return modelRowIndex;
    }

    @Override
    public int convertViewColumnIndexToModel(int viewIndex) {
        return this.columnSortOrder != null ? (viewIndex >= 0 && viewIndex < this.columnSortOrder.length ? this.columnSortOrder[viewIndex] : -1) : viewIndex;
    }

    @Override
    public int convertViewRowIndexToModel(int viewIndex) {
        return this.rowViewOrder != null ? (viewIndex < this.rowViewOrder.length && viewIndex >= 0 ? this.rowViewOrder[viewIndex] : -1) : viewIndex;
    }

    @Override
    public void fireColumnMetadataChanged() {
        this.fireProjectChanged(new ProjectEvent(this, 6));
    }

    @Override
    public void fireRowMetadataChanged() {
        this.fireProjectChanged(new ProjectEvent(this, 5));
    }

    @Override
    public VectorColorModel getColumnColorModel() {
        return this.columnCategoryColorModel;
    }

    @Override
    public Dendrogram getColumnDendrogram() {
        return this.columnDendrogram;
    }

    @Override
    public ProjectSortKey[] getColumnGroupBy() {
        return this.columnGroupBy;
    }

    public Comparator<String> getColumnIdComparator() {
        return this.columnIdComparator;
    }

    @Override
    public SelectionModel getColumnSelectionModel() {
        return this.columnSelectionModel;
    }

    @Override
    public List<? extends ProjectSortKey> getColumnSortKeys() {
        return this.columnSorter.getSortKeys();
    }

    @Override
    public int[] getColumnSortOrder() {
        return this.columnSortOrder;
    }

    @Override
    public ElementSelectionModel getElementSelectionModel() {
        return this.elementSelectionModel;
    }

    @Override
    public List<Node> getHighlightedColumnDendrogramNodes() {
        return this.highlightedColumnDendrogramNodes;
    }

    @Override
    public List<Node> getHighlightedRowDendrogramNodes() {
        return this.highlightedRowDendrogramNodes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int[] getModelColumnIndices(boolean selectionOnly, boolean removeMasked) {
        return this.convertColumnsToView(selectionOnly, removeMasked);
    }

    @Override
    public int[] getModelRowIndices(boolean selectionOnly, boolean removeMasked) {
        return this.convertRowsToView(selectionOnly, removeMasked);
    }

    @Override
    public Dataset getOriginalDataset() {
        return this.dataset;
    }

    @Override
    public VectorColorModel getRowColorModel() {
        return this.rowCategoryColorModel;
    }

    @Override
    public Dendrogram getRowDendrogram() {
        return this.rowDendrogram;
    }

    @Override
    public Filter getRowFilter() {
        return this.rowFilter;
    }

    @Override
    public ProjectSortKey[] getRowGroupBy() {
        return this.rowGroupBy;
    }

    public Comparator<String> getRowIdComparator() {
        return this.rowIdComparator;
    }

    @Override
    public SelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    @Override
    public List<? extends ProjectSortKey> getRowSortKeys() {
        return this.rowSorter.getSortKeys();
    }

    @Override
    public int[] getRowSortOrder() {
        return this.rowSortOrder;
    }

    @Override
    public Dataset getSortedFilteredDataset() {
        return DatasetUtil.sliceView(this.getOriginalDataset(), this.convertRowsToView(false, false), this.convertColumnsToView(false, false));
    }

    @Override
    public int getViewColumnCount() {
        return this.getOriginalDataset() == null ? 0 : this.getSortedFilteredDataset().getColumnCount();
    }

    @Override
    public TIntHashSet getViewColumnMask() {
        return this.maskedViewColumnIndices;
    }

    @Override
    public ListSelectionModel getViewRowCategoriesSelectionModel() {
        return this.viewRowCategoriesSelectionModel;
    }

    @Override
    public int getViewRowCount() {
        return this.rowViewOrder == null ? (this.getOriginalDataset() == null ? 0 : this.getSortedFilteredDataset().getRowCount()) : this.rowViewOrder.length;
    }

    @Override
    public TIntHashSet getViewRowMask() {
        return this.maskedViewRowIndices;
    }

    @Override
    public boolean isColumnSortOrderPreservesDendrogram() {
        return this.columnSorter.isDendrogramValid();
    }

    @Override
    public boolean isRowSortOrderPreservesDendrogram() {
        return this.rowSorter.isDendrogramValid();
    }

    @Override
    public void removeColumnSelectionListener(SelectionListener l) {
        this.columnSelectionModel.removeSelectionListener(l);
    }

    @Override
    public void removeFromColumnMask(int[] viewIndices) {
        int length = viewIndices.length;
        for (int i = 0; i < length; ++i) {
            int modelIndex = this.convertViewColumnIndexToModel(viewIndices[i]);
            this.maskedModelColumnIndices.remove(modelIndex);
        }
        this.updateColumnViewMaskFromModel();
        this.columnSelectionModel.setSelectedModelIndices(new int[0]);
        this.fireProjectChanged(new ProjectEvent(this, 12));
    }

    @Override
    public void removeFromRowMask(int[] viewIndices) {
        int length = viewIndices.length;
        for (int i = 0; i < length; ++i) {
            int modelIndex = this.convertViewRowIndexToModel(viewIndices[i]);
            this.maskedModelRowIndices.remove(modelIndex);
        }
        this.updateRowViewMaskFromModel();
        this.rowSelectionModel.setSelectedModelIndices(new int[0]);
        this.fireProjectChanged(new ProjectEvent(this, 1));
    }

    @Override
    public void removeProjectListener(ProjectListener l) {
        this.listenerList.remove(ProjectListener.class, l);
    }

    public void setColumnCategoryColorModel(VectorColorModel columnCategoryColorModel) {
        this.columnCategoryColorModel = columnCategoryColorModel;
    }

    @Override
    public void setColumnDendrogram(Dendrogram columnDendrogram) {
        this.columnDendrogram = columnDendrogram;
        this.fireProjectChanged(new ProjectEvent(this, 10));
    }

    @Override
    public void setColumnGroupBy(ProjectSortKey[] columnGroupBy) {
        if (columnGroupBy == null) {
            columnGroupBy = new ProjectSortKey[]{};
        }
        if (!Arrays.equals(columnGroupBy, this.columnGroupBy)) {
            this.columnGroupBy = columnGroupBy;
            this.fireProjectChanged(new ProjectEvent(this, 0));
        }
    }

    public void setColumnIdComparator(Comparator<String> columnIdComparator) {
        this.columnIdComparator = columnIdComparator;
    }

    @Override
    public void setColumnSortOrder(List<? extends ProjectSortKey> sortKeys) {
        this.setColumnSortOrder(sortKeys, true);
    }

    @Override
    public void setDataset(Dataset dataset) {
        if (this.dataset != null) {
            dataset.setProperty("project.node", this.dataset.getProperty("project.node"));
        }
        this.dataset = dataset;
        this._clearRowMask(false);
        this._clearColumnMask(false);
        this.getColumnSelectionModel().setSelectedModelIndices(new int[0]);
        this.getRowSelectionModel().setSelectedModelIndices(new int[0]);
        this.setColumnSortOrder(this.getColumnSortKeys(), false);
        this.setRowSortOrder(this.getRowSortKeys(), false);
        this.fireProjectChanged(new ProjectEvent(this, 8));
        this.fireProjectChanged(new ProjectEvent(this, 0));
    }

    @Override
    public void setHighlightedColumnDendrogramNodes(List<Node> nodes) {
        this.highlightedColumnDendrogramNodes = nodes;
        this.fireProjectChanged(new ProjectEvent(this, 10));
    }

    @Override
    public void setHighlightedRowDendrogramNodes(List<Node> nodes) {
        this.highlightedRowDendrogramNodes = nodes;
        this.fireProjectChanged(new ProjectEvent(this, 11));
    }

    public void setParentProject(Project parentProject) {
        if (parentProject == null) {
            throw new NullPointerException();
        }
        this.rowCategoryColorModel = DefaultVectorColorModel.copy(parentProject.getOriginalDataset().getRowMetadata(), parentProject.getRowColorModel());
        this.columnCategoryColorModel = DefaultVectorColorModel.copy(parentProject.getOriginalDataset().getColumnMetadata(), parentProject.getColumnColorModel());
        Dataset dataset = this.getSortedFilteredDataset();
        if (this.columnDendrogram == null && parentProject != null && parentProject.getColumnDendrogram() != null && parentProject.getViewColumnCount() == dataset.getColumnCount() && parentProject.isColumnSortOrderPreservesDendrogram()) {
            this.columnDendrogram = parentProject.getColumnDendrogram();
        }
        if (this.rowDendrogram == null && parentProject != null && parentProject.getRowDendrogram() != null && parentProject.isRowSortOrderPreservesDendrogram() && parentProject.getViewRowCount() == dataset.getRowCount()) {
            this.rowDendrogram = parentProject.getRowDendrogram();
        }
    }

    public void setRowCategoryColorModel(VectorColorModel rowCategoryColorModel) {
        this.rowCategoryColorModel = rowCategoryColorModel;
    }

    @Override
    public void setRowDendrogram(Dendrogram rowDendrogram) {
        this.rowDendrogram = rowDendrogram;
    }

    @Override
    public void setRowFilter(Filter filter) {
        if (this.rowFilter != null) {
            this.rowFilter.removeFilterListener(this.filterListener);
        }
        this.rowFilter = filter;
        if (filter != null) {
            filter.addFilterListener(this.filterListener);
        }
    }

    @Override
    public void setRowGroupBy(ProjectSortKey[] rowGroupBy) {
        if (rowGroupBy == null) {
            rowGroupBy = new ProjectSortKey[]{};
        }
        if (!Arrays.equals(rowGroupBy, this.rowGroupBy)) {
            this.rowGroupBy = rowGroupBy;
            this.fireProjectChanged(new ProjectEvent(this, 8));
        }
    }

    public void setRowIdComparator(Comparator<String> rowIdComparator) {
        this.rowIdComparator = rowIdComparator;
    }

    @Override
    public void setRowSortOrder(List<? extends ProjectSortKey> sortKeys) {
        this.setRowSortOrder(sortKeys, true);
    }

    @Override
    public void setSelectedModelColumnIndices(int[] selectedModelIndices) {
        this.columnSelectionModel.setSelectedModelIndices(selectedModelIndices);
    }

    @Override
    public void setSelectedModelRowIndices(int[] selectedModelIndices) {
        this.rowSelectionModel.setSelectedModelIndices(selectedModelIndices);
    }

    public String toString() {
        return this.getOriginalDataset() != null ? this.getOriginalDataset().getName() : "";
    }

    protected AbstractSelectionModel createColumnSelectionModel() {
        return new ColumnSelectionModel(this);
    }

    protected AbstractSelectionModel createRowSelectionModel() {
        return new RowSelectionModel(this);
    }

    protected TIntHashSet createViewColumnMask() {
        return new TIntHashSet();
    }

    protected TIntHashSet createViewRowMask() {
        return new TIntHashSet();
    }

    protected void setRowSortOrder(List<? extends ProjectSortKey> sortKeys, boolean notify) {
        this.rowSorter.setSortKeys(sortKeys);
        this.rowSortOrder = this.rowSorter.getSortedIndices(this);
        this.updateRowMappings();
        if (notify) {
            this.fireProjectChanged(new ProjectEvent(this, 8));
        }
    }

    private void _clearColumnMask(boolean notify) {
        this.maskedViewColumnIndices.clear();
        this.maskedModelColumnIndices = null;
        if (notify) {
            this.fireProjectChanged(new ProjectEvent(this, 12));
        }
    }

    private void _clearRowMask(boolean notify) {
        this.maskedViewRowIndices.clear();
        this.maskedModelRowIndices = null;
        if (notify) {
            this.fireProjectChanged(new ProjectEvent(this, 1));
        }
    }

    private int[] convertColumnsToView(boolean includeSelectedColumns, boolean excludeMaskedColumns) {
        int[] order = this.columnSortOrder;
        int[] selection = null;
        if (includeSelectedColumns) {
            selection = this.getColumnSelectionModel().getSelectedViewIndices();
        }
        if (excludeMaskedColumns && this.maskedViewColumnIndices != null && this.maskedViewColumnIndices.size() > 0) {
            selection = DefaultProject.removeMaskedIndices(selection, this.maskedViewColumnIndices, order != null ? order.length : this.getOriginalDataset().getColumnCount());
        }
        if (selection != null) {
            int[] newOrder = new int[selection.length];
            int length = newOrder.length;
            for (int i = 0; i < length; ++i) {
                newOrder[i] = order != null ? order[selection[i]] : selection[i];
            }
            order = newOrder;
        }
        return order;
    }

    private int[] convertRowsToView(boolean includeSelectedRows, boolean excludeMaskedRows) {
        int[] order = this.rowViewOrder;
        int[] selection = null;
        if (includeSelectedRows) {
            selection = this.getRowSelectionModel().getSelectedViewIndices();
        }
        if (excludeMaskedRows && this.maskedViewRowIndices != null && this.maskedViewRowIndices.size() > 0) {
            selection = DefaultProject.removeMaskedIndices(selection, this.maskedViewRowIndices, order != null ? order.length : this.getOriginalDataset().getRowCount());
        }
        if (selection != null) {
            int[] newOrder = new int[selection.length];
            int length = newOrder.length;
            for (int i = 0; i < length; ++i) {
                newOrder[i] = order != null ? order[selection[i]] : selection[i];
            }
            order = newOrder;
        }
        return order;
    }

    private void fireProjectChanged(ProjectEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ProjectListener.class) continue;
            ((ProjectListener)listeners[i + 1]).projectChanged(e);
        }
    }

    private void setColumnSortOrder(List<? extends ProjectSortKey> sortKeys, boolean notify) {
        this.columnSorter.setSortKeys(sortKeys);
        this.columnSortOrder = this.columnSorter.getSortedIndices(this);
        if (this.columnSortOrder != null) {
            this.columnModelToView = new HashMap<Integer, Integer>();
            int length = this.columnSortOrder.length;
            for (int i = 0; i < length; ++i) {
                this.columnModelToView.put(this.columnSortOrder[i], i);
            }
        } else {
            this.columnModelToView = null;
        }
        this.updateColumnViewMaskFromModel();
        if (notify) {
            this.fireProjectChanged(new ProjectEvent(this, 0));
        }
    }

    private void updateColumnViewMaskFromModel() {
        if (this.maskedViewColumnIndices != null) {
            this.maskedViewColumnIndices.clear();
        }
        if (this.maskedModelColumnIndices != null) {
            if (this.maskedViewColumnIndices == null) {
                this.maskedViewColumnIndices = new TIntHashSet();
            }
            TIntIterator it = this.maskedModelColumnIndices.iterator();
            while (it.hasNext()) {
                this.maskedViewColumnIndices.add(this.convertModelColumnIndexToView(it.next()));
            }
        }
    }

    private void updateRowMappings() {
        if (this.getOriginalDataset() == null) {
            return;
        }
        Dataset originalDataset = this.getOriginalDataset();
        Dataset sortedDataset = DatasetUtil.sliceView(originalDataset, this.rowSortOrder, this.columnSortOrder);
        this.rowViewOrder = this.rowSortOrder;
        if (this.rowFilter != null && !this.rowFilter.isEmpty() && this.rowFilter.isEnabled()) {
            TIntArrayList acceptIndices = new TIntArrayList();
            this.rowFilter.init(sortedDataset);
            int nrows = sortedDataset.getRowCount();
            for (int i = 0; i < nrows; ++i) {
                if (!this.rowFilter.accept(i)) continue;
                int modelIndex = this.rowSortOrder == null ? i : this.rowSortOrder[i];
                acceptIndices.add(modelIndex);
            }
            this.rowViewOrder = acceptIndices.toArray();
        }
        if (this.rowViewOrder != null) {
            this.rowModelToView = new HashMap<Integer, Integer>();
            int length = this.rowViewOrder.length;
            for (int i = 0; i < length; ++i) {
                this.rowModelToView.put(this.rowViewOrder[i], i);
            }
        } else {
            this.rowModelToView = null;
        }
        this.updateRowViewMaskFromModel();
    }

    private void updateRowViewMaskFromModel() {
        if (this.maskedViewRowIndices != null) {
            this.maskedViewRowIndices.clear();
        }
        if (this.maskedModelRowIndices != null) {
            if (this.maskedViewRowIndices == null) {
                this.maskedViewRowIndices = new TIntHashSet();
            }
            for (int modelIndex : this.maskedModelRowIndices) {
                int viewIndex = this.convertModelRowIndexToView(modelIndex);
                this.maskedViewRowIndices.add(viewIndex);
            }
        }
    }

    private static int[] removeMaskedIndices(int[] viewIndices, TIntHashSet viewMask, int count) {
        TIntArrayList indicesToKeep = new TIntArrayList();
        if (viewIndices != null) {
            for (int viewIndex : viewIndices) {
                if (viewMask.contains(viewIndex)) continue;
                indicesToKeep.add(viewIndex);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (viewMask.contains(i)) continue;
                indicesToKeep.add(i);
            }
        }
        return indicesToKeep.toArray();
    }
}

