/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.broadinstitute.genee.heatmap.ColorSupplier;
import org.broadinstitute.genee.heatmap.WorldCoordinateMapper;

public class DiscreteColorSupplier
implements ColorSupplier {
    private Color[] colors = new Color[]{new Color(69, 0, 173), new Color(39, 0, 209), new Color(107, 88, 239), new Color(136, 136, 255), new Color(199, 193, 255), new Color(213, 213, 255), new Color(255, 192, 229), new Color(255, 137, 137), new Color(255, 112, 128), new Color(255, 90, 90), new Color(239, 64, 64), new Color(214, 12, 0)};
    private float min;
    private float max;
    private float[] fractions = new float[this.colors.length];

    public DiscreteColorSupplier() {
        float step = 1.0f / (float)this.colors.length;
        float fraction = 0.0f;
        for (int i = 0; i < this.colors.length; ++i) {
            this.fractions[i] = fraction;
            fraction += step;
        }
    }

    @Override
    public Color getColor(int rowIndex, int columnIndex, float value) {
        float min = this.min;
        float max = this.max;
        Color[] colors = this.colors;
        if (value <= min) {
            return colors[0];
        }
        if (value >= max) {
            return colors[colors.length - 1];
        }
        float fraction = WorldCoordinateMapper.linearScale(value, min, max, 0.0f, 1.0f);
        return colors[this.getIndexForFraction(fraction)];
    }

    @Override
    public Color[] getColors() {
        return this.colors;
    }

    @Override
    public float[] getFractions() {
        return this.fractions;
    }

    @Override
    public float getMax() {
        return this.max;
    }

    @Override
    public float getMin() {
        return this.min;
    }

    @Override
    public boolean isDiscrete() {
        return true;
    }

    @Override
    public void setMax(float max) {
        this.max = max;
    }

    @Override
    public void setMin(float min) {
        this.min = min;
    }

    @Override
    public void setPaint(float[] fractions, Color[] colors) {
        this.colors = colors;
        this.fractions = fractions;
    }

    private int getIndexForFraction(float f) {
        if (f <= this.fractions[0]) {
            return 0;
        }
        if (f >= this.fractions[this.fractions.length - 1]) {
            return this.fractions.length - 1;
        }
        for (int i = 0; i < this.fractions.length - 1; ++i) {
            float left = this.fractions[i];
            float right = this.fractions[i + 1];
            if (!(f > left) || !(f <= right)) continue;
            return i;
        }
        return this.fractions.length - 1;
    }

    public static float[] createFractions(Color[] colors) {
        float[] fractions = new float[colors.length];
        float step = 1.0f / (float)colors.length;
        float fraction = 0.0f;
        for (int i = 0; i < colors.length; ++i) {
            fractions[i] = fraction;
            fraction += step;
        }
        return fractions;
    }

    public static Color[] createJetColors() {
        return new Color[]{DiscreteColorSupplier.createColor(0.0, 0.0, 0.5625), DiscreteColorSupplier.createColor(0.0, 0.0, 0.625), DiscreteColorSupplier.createColor(0.0, 0.0, 0.6875), DiscreteColorSupplier.createColor(0.0, 0.0, 0.75), DiscreteColorSupplier.createColor(0.0, 0.0, 0.8125), DiscreteColorSupplier.createColor(0.0, 0.0, 0.875), DiscreteColorSupplier.createColor(0.0, 0.0, 0.9375), DiscreteColorSupplier.createColor(0.0, 0.0, 1.0), DiscreteColorSupplier.createColor(0.0, 0.0625, 1.0), DiscreteColorSupplier.createColor(0.0, 0.125, 1.0), DiscreteColorSupplier.createColor(0.0, 0.1875, 1.0), DiscreteColorSupplier.createColor(0.0, 0.25, 1.0), DiscreteColorSupplier.createColor(0.0, 0.3125, 1.0), DiscreteColorSupplier.createColor(0.0, 0.375, 1.0), DiscreteColorSupplier.createColor(0.0, 0.4375, 1.0), DiscreteColorSupplier.createColor(0.0, 0.5, 1.0), DiscreteColorSupplier.createColor(0.0, 0.5625, 1.0), DiscreteColorSupplier.createColor(0.0, 0.625, 1.0), DiscreteColorSupplier.createColor(0.0, 0.6875, 1.0), DiscreteColorSupplier.createColor(0.0, 0.75, 1.0), DiscreteColorSupplier.createColor(0.0, 0.8125, 1.0), DiscreteColorSupplier.createColor(0.0, 0.875, 1.0), DiscreteColorSupplier.createColor(0.0, 0.9375, 1.0), DiscreteColorSupplier.createColor(0.0, 1.0, 1.0), DiscreteColorSupplier.createColor(0.0625, 1.0, 0.9375), DiscreteColorSupplier.createColor(0.125, 1.0, 0.875), DiscreteColorSupplier.createColor(0.1875, 1.0, 0.8125), DiscreteColorSupplier.createColor(0.25, 1.0, 0.75), DiscreteColorSupplier.createColor(0.3125, 1.0, 0.6875), DiscreteColorSupplier.createColor(0.375, 1.0, 0.625), DiscreteColorSupplier.createColor(0.4375, 1.0, 0.5625), DiscreteColorSupplier.createColor(0.5, 1.0, 0.5), DiscreteColorSupplier.createColor(0.5625, 1.0, 0.4375), DiscreteColorSupplier.createColor(0.625, 1.0, 0.375), DiscreteColorSupplier.createColor(0.6875, 1.0, 0.3125), DiscreteColorSupplier.createColor(0.75, 1.0, 0.25), DiscreteColorSupplier.createColor(0.8125, 1.0, 0.1875), DiscreteColorSupplier.createColor(0.875, 1.0, 0.125), DiscreteColorSupplier.createColor(0.9375, 1.0, 0.0625), DiscreteColorSupplier.createColor(1.0, 1.0, 0.0), DiscreteColorSupplier.createColor(1.0, 0.9375, 0.0), DiscreteColorSupplier.createColor(1.0, 0.875, 0.0), DiscreteColorSupplier.createColor(1.0, 0.8125, 0.0), DiscreteColorSupplier.createColor(1.0, 0.75, 0.0), DiscreteColorSupplier.createColor(1.0, 0.6875, 0.0), DiscreteColorSupplier.createColor(1.0, 0.625, 0.0), DiscreteColorSupplier.createColor(1.0, 0.5625, 0.0), DiscreteColorSupplier.createColor(1.0, 0.5, 0.0), DiscreteColorSupplier.createColor(1.0, 0.4375, 0.0), DiscreteColorSupplier.createColor(1.0, 0.375, 0.0), DiscreteColorSupplier.createColor(1.0, 0.3125, 0.0), DiscreteColorSupplier.createColor(1.0, 0.25, 0.0), DiscreteColorSupplier.createColor(1.0, 0.1875, 0.0), DiscreteColorSupplier.createColor(1.0, 0.125, 0.0), DiscreteColorSupplier.createColor(1.0, 0.0625, 0.0), DiscreteColorSupplier.createColor(1.0, 0.0, 0.0), DiscreteColorSupplier.createColor(0.9375, 0.0, 0.0), DiscreteColorSupplier.createColor(0.875, 0.0, 0.0), DiscreteColorSupplier.createColor(0.8125, 0.0, 0.0), DiscreteColorSupplier.createColor(0.75, 0.0, 0.0), DiscreteColorSupplier.createColor(0.6875, 0.0, 0.0), DiscreteColorSupplier.createColor(0.625, 0.0, 0.0), DiscreteColorSupplier.createColor(0.5625, 0.0, 0.0), DiscreteColorSupplier.createColor(0.5, 0.0, 0.0)};
    }

    public static TexturePaint createPaint(int width, float[] fractions, Color[] colors) {
        int imageWidth = width;
        BufferedImage tmp = new BufferedImage(imageWidth, 16, 2);
        Graphics2D tmpGraphics = tmp.createGraphics();
        for (int i = 0; i < fractions.length - 1; ++i) {
            float x = fractions[i] * (float)width;
            float x2 = fractions[i + 1] * (float)width;
            float rectWidth = x2 - x;
            tmpGraphics.setColor(colors[i]);
            tmpGraphics.fill(new Rectangle2D.Float(x, 0.0f, rectWidth, 16.0f));
        }
        float x = fractions[fractions.length - 1] * (float)width;
        float x2 = width;
        float rectWidth = x2 - x;
        tmpGraphics.setColor(colors[colors.length - 1]);
        tmpGraphics.fill(new Rectangle2D.Float(x, 0.0f, rectWidth, 16.0f));
        tmpGraphics.dispose();
        return new TexturePaint(tmp, new Rectangle2D.Float(0.0f, 0.0f, imageWidth, 16.0f));
    }

    public static float getFractionForValue(float value, float min, float max) {
        WorldCoordinateMapper cm = new WorldCoordinateMapper();
        cm.setLeftGutter(0.0f);
        cm.setRightGutter(0.0f);
        cm.setXMax(max);
        cm.setXMin(min);
        cm.setXPixelScale(1.0f);
        return cm.xToPix(value);
    }

    private static Color createColor(double r, double g, double b) {
        return new Color((float)r, (float)g, (float)b);
    }
}

