/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.compound.painter.ImageElement;
import org.broadinstitute.genee.compound.painter.ImageElementPainter;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.ColorBarDisplayOptions;
import org.broadinstitute.genee.heatmap.DefaultElementPainter;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.HeatMapSizeOptions;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.table.HeatMapRowTableModel;

public class DisplayOptionsPanel
extends JPanel {
    private ColorBarDisplayOptions categoryDisplayOptions;
    private TimerTextField columnDendrogramLineThicknessTextField;
    private JLabel columnDendrogramThicknessLabel;
    private JCheckBox drawColumnLeafNodes;
    private JCheckBox drawRowLeafNodes;
    private JButton gridColorButton;
    private HeatMapPanel heatMapPanel;
    private HeatMapSizeOptions heatMapSizeOptions;
    private TimerTextField rowDendrogramLineThicknessTextField;
    private JLabel rowDendrogramThicknessLabel;
    private JCheckBox rowSparklineCheckBox;
    private JCheckBox showRowNumberCheckbox;
    private JCheckBox showGridCheckBox;
    private JCheckBox showImagesCheckBox;
    private JCheckBox showValuesCheckBox;
    private JCheckBox rowProfileCheckBoxFilled;
    private EditColorButton columnDendrogramColor;
    private EditColorButton rowDendrogramColor;
    private TimerTextField columnDendrogramMin;
    private TimerTextField columnDendrogramMax;
    private TimerTextField rowDendrogramMin;
    private TimerTextField rowDendrogramMax;

    public DisplayOptionsPanel(final HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
        FormBuilder formBuilder = new FormBuilder(this);
        formBuilder.addSeparator("Heat Map Settings");
        this.heatMapSizeOptions = new HeatMapSizeOptions(heatMapPanel, formBuilder);
        this.showGridCheckBox = new JCheckBox("Show grid");
        formBuilder.nextRow();
        formBuilder.addFirstColumn(this.showGridCheckBox);
        formBuilder.nextRow();
        this.gridColorButton = new JButton("Grid color\u2026");
        FormBuilder indented1 = new FormBuilder();
        indented1.setIndentedBorder();
        indented1.nextRow();
        indented1.add(this.gridColorButton);
        formBuilder.addFirstColumn(indented1.getPanel());
        this.showRowNumberCheckbox = new JCheckBox("Show row number");
        formBuilder.nextRow();
        formBuilder.addFirstColumn(this.showRowNumberCheckbox);
        this.rowSparklineCheckBox = new JCheckBox("Show row profile sparkline");
        formBuilder.nextRow();
        formBuilder.addFirstColumn(this.rowSparklineCheckBox);
        this.rowProfileCheckBoxFilled = new JCheckBox("Filled", false);
        formBuilder.nextSmallRow();
        formBuilder.addFirstColumn(new FormBuilder().setIndentedBorder().nextRow().addFirstColumn(this.rowProfileCheckBoxFilled).getPanel());
        this.showValuesCheckBox = new JCheckBox("Show values in heat map");
        this.showValuesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                heatMapPanel.setDrawValues(DisplayOptionsPanel.this.showValuesCheckBox.isSelected());
            }
        });
        formBuilder.nextRow();
        formBuilder.addFirstColumn(this.showValuesCheckBox);
        this.showImagesCheckBox = new JCheckBox("Show images in heat map");
        if (Application.isDevVersion()) {
            this.showImagesCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DisplayOptionsPanel.this.showImagesCheckBox.isSelected()) {
                        heatMapPanel.setElementPainter(new ImageElementPainter());
                    } else {
                        heatMapPanel.setElementPainter(new DefaultElementPainter());
                    }
                }
            });
            formBuilder.nextRow();
            formBuilder.addFirstColumn(this.showImagesCheckBox);
            this.showImagesCheckBox.setEnabled(false);
        }
        formBuilder.addSeparator("Color Bar Settings");
        this.categoryDisplayOptions = new ColorBarDisplayOptions(heatMapPanel, formBuilder);
        formBuilder.addSeparator("Dendrogram Settings");
        this.columnDendrogramLineThicknessTextField = new TimerTextField(){

            @Override
            public void update() {
                try {
                    float thickness = ParserHelper.parseFloat(this.getText().trim());
                    if (thickness >= 0.0f && heatMapPanel.getColumnDendrogramPanel().getDendrogramLineThickness() != thickness) {
                        heatMapPanel.getColumnDendrogramPanel().setDendrogramLineThickness(thickness);
                        heatMapPanel.getColumnDendrogramPanel().repaintImage();
                        heatMapPanel.revalidate();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        this.rowDendrogramLineThicknessTextField = new TimerTextField(){

            @Override
            public void update() {
                try {
                    float thickness = ParserHelper.parseFloat(this.getText().trim());
                    if (thickness >= 0.0f && heatMapPanel.getRowDendrogramPanel().getDendrogramLineThickness() != thickness) {
                        heatMapPanel.getRowDendrogramPanel().setDendrogramLineThickness(thickness);
                        heatMapPanel.getRowDendrogramPanel().repaintImage();
                        heatMapPanel.revalidate();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        formBuilder.addLabel("Column dendrogram minimum:");
        this.columnDendrogramMin = new TimerTextField(){

            @Override
            public void update() {
                String text = this.getText().trim();
                heatMapPanel.getColumnDendrogramPanel().setMin(text.equals("") ? Float.NaN : Float.parseFloat(text));
                heatMapPanel.getColumnDendrogramPanel().repaintImage();
            }
        };
        formBuilder.add(this.columnDendrogramMin);
        formBuilder.nextRow();
        formBuilder.addLabel("Column dendrogram maximum:");
        this.columnDendrogramMax = new TimerTextField(){

            @Override
            public void update() {
                String text = this.getText().trim();
                heatMapPanel.getColumnDendrogramPanel().setMax(text.equals("") ? Float.NaN : Float.parseFloat(text));
                heatMapPanel.getColumnDendrogramPanel().repaintImage();
            }
        };
        formBuilder.add(this.columnDendrogramMax);
        formBuilder.nextRow();
        this.columnDendrogramThicknessLabel = formBuilder.addLabel("Column dendrogram thickness:");
        formBuilder.add(this.columnDendrogramLineThicknessTextField);
        this.drawColumnLeafNodes = new JCheckBox("Show column dendrogram leaf nodes", true);
        this.drawColumnLeafNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                heatMapPanel.getColumnDendrogramPanel().setDrawLeafNodes(DisplayOptionsPanel.this.drawColumnLeafNodes.isSelected());
                heatMapPanel.getColumnDendrogramPanel().repaintImage();
            }
        });
        formBuilder.nextRow();
        formBuilder.addSpanned(this.drawColumnLeafNodes);
        formBuilder.nextRow();
        formBuilder.addLabel("Column dendrogram color:");
        this.columnDendrogramColor = new EditColorButton(Color.BLACK);
        formBuilder.add(this.columnDendrogramColor);
        formBuilder.nextRow();
        formBuilder.addLabel("Row dendrogram minimum:");
        this.rowDendrogramMin = new TimerTextField(){

            @Override
            public void update() {
                String text = this.getText().trim();
                heatMapPanel.getRowDendrogramPanel().setMin(text.equals("") ? Float.NaN : Float.parseFloat(text));
                heatMapPanel.getRowDendrogramPanel().repaintImage();
            }
        };
        formBuilder.add(this.rowDendrogramMin);
        formBuilder.nextRow();
        formBuilder.addLabel("Row dendrogram maximum:");
        this.rowDendrogramMax = new TimerTextField(){

            @Override
            public void update() {
                String text = this.getText().trim();
                heatMapPanel.getRowDendrogramPanel().setMax(text.equals("") ? Float.NaN : Float.parseFloat(text));
                heatMapPanel.getRowDendrogramPanel().repaintImage();
            }
        };
        formBuilder.add(this.rowDendrogramMax);
        formBuilder.nextRow();
        this.rowDendrogramThicknessLabel = formBuilder.addLabel("Row dendrogram thickness:");
        formBuilder.add(this.rowDendrogramLineThicknessTextField);
        this.drawRowLeafNodes = new JCheckBox("Show row dendrogram leaf nodes", true);
        this.drawRowLeafNodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                heatMapPanel.getRowDendrogramPanel().setDrawLeafNodes(DisplayOptionsPanel.this.drawRowLeafNodes.isSelected());
                heatMapPanel.getRowDendrogramPanel().repaintImage();
            }
        });
        formBuilder.nextRow();
        formBuilder.addSpanned(this.drawRowLeafNodes);
        formBuilder.nextRow();
        formBuilder.addLabel("Row dendrogram color:");
        this.rowDendrogramColor = new EditColorButton(Color.BLACK);
        formBuilder.add(this.rowDendrogramColor);
        this.addActionListeners();
    }

    private void addActionListeners() {
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == DisplayOptionsPanel.this.rowDendrogramColor) {
                    DisplayOptionsPanel.this.heatMapPanel.getRowDendrogramPanel().setColor(DisplayOptionsPanel.this.rowDendrogramColor.getColor());
                    DisplayOptionsPanel.this.heatMapPanel.getRowDendrogramPanel().repaintImage();
                } else if (e.getSource() == DisplayOptionsPanel.this.columnDendrogramColor) {
                    DisplayOptionsPanel.this.heatMapPanel.getColumnDendrogramPanel().setColor(DisplayOptionsPanel.this.columnDendrogramColor.getColor());
                    DisplayOptionsPanel.this.heatMapPanel.getColumnDendrogramPanel().repaintImage();
                } else if (e.getSource() == DisplayOptionsPanel.this.rowSparklineCheckBox || e.getSource() == DisplayOptionsPanel.this.rowProfileCheckBoxFilled) {
                    boolean showProfile = DisplayOptionsPanel.this.rowSparklineCheckBox.isSelected();
                    DisplayOptionsPanel.this.rowProfileCheckBoxFilled.setEnabled(showProfile);
                    boolean filled = DisplayOptionsPanel.this.rowProfileCheckBoxFilled.isSelected();
                    DisplayOptionsPanel.this.heatMapPanel.setShowRowProfileSparkLines(showProfile, filled);
                } else if (e.getSource() == DisplayOptionsPanel.this.showRowNumberCheckbox) {
                    boolean showRowNumber = DisplayOptionsPanel.this.showRowNumberCheckbox.isSelected();
                    ((HeatMapRowTableModel)DisplayOptionsPanel.this.heatMapPanel.getRowTable().getModel()).setRowNumberVisible(showRowNumber);
                } else if (e.getSource() == DisplayOptionsPanel.this.showGridCheckBox) {
                    boolean showGrid = DisplayOptionsPanel.this.showGridCheckBox.isSelected();
                    DisplayOptionsPanel.this.heatMapPanel.setDrawGrid(showGrid);
                    DisplayOptionsPanel.this.gridColorButton.setEnabled(showGrid);
                } else if (e.getSource() == DisplayOptionsPanel.this.gridColorButton) {
                    Color existingColor = DisplayOptionsPanel.this.heatMapPanel.getGridColor();
                    Color color = UIUtil.showColorDialog(UIUtil.getWindowForComponent(DisplayOptionsPanel.this), "Grid color", existingColor);
                    if (color != null) {
                        DisplayOptionsPanel.this.heatMapPanel.setGridColor(color);
                    }
                }
                DisplayOptionsPanel.this.heatMapPanel.revalidate();
            }
        };
        this.rowSparklineCheckBox.addActionListener(l);
        this.showRowNumberCheckbox.addActionListener(l);
        this.rowProfileCheckBoxFilled.addActionListener(l);
        this.showGridCheckBox.addActionListener(l);
        this.gridColorButton.addActionListener(l);
        this.rowDendrogramColor.addActionListener(l);
        this.columnDendrogramColor.addActionListener(l);
    }

    void configureValues() {
        this.categoryDisplayOptions.configureValues();
        this.heatMapSizeOptions.configureValues();
        this.showValuesCheckBox.setSelected(this.heatMapPanel.isDrawValues());
        this.showGridCheckBox.setSelected(this.heatMapPanel.isDrawGrid());
        this.gridColorButton.setEnabled(this.heatMapPanel.isDrawGrid());
        this.rowSparklineCheckBox.setSelected(this.heatMapPanel.isProfileSparkLinesVisible());
        this.showRowNumberCheckbox.setSelected(((HeatMapRowTableModel)this.heatMapPanel.getRowTable().getModel()).isRowNumberVisible());
        this.rowProfileCheckBoxFilled.setSelected(this.heatMapPanel.isProfileSparkLinesFilled());
        this.rowProfileCheckBoxFilled.setEnabled(this.rowSparklineCheckBox.isSelected());
        this.columnDendrogramMin.setEditable(this.heatMapPanel.getColumnDendrogramPanel() != null);
        this.columnDendrogramMax.setEditable(this.heatMapPanel.getColumnDendrogramPanel() != null);
        this.rowDendrogramMin.setEditable(this.heatMapPanel.getRowDendrogramPanel() != null);
        this.rowDendrogramMax.setEditable(this.heatMapPanel.getRowDendrogramPanel() != null);
        this.rowDendrogramLineThicknessTextField.setEnabled(this.heatMapPanel.getRowDendrogramPanel() != null);
        this.rowDendrogramThicknessLabel.setEnabled(this.heatMapPanel.getRowDendrogramPanel() != null);
        if (this.heatMapPanel.getRowDendrogramPanel() != null) {
            this.rowDendrogramLineThicknessTextField.setText(Formatter.toString(Float.valueOf(this.heatMapPanel.getRowDendrogramPanel().getDendrogramLineThickness())));
            this.rowDendrogramColor.setColor(this.heatMapPanel.getRowDendrogramPanel().getColor());
        }
        this.drawRowLeafNodes.setEnabled(this.heatMapPanel.getRowDendrogramPanel() != null);
        this.drawColumnLeafNodes.setEnabled(this.heatMapPanel.getColumnDendrogramPanel() != null);
        this.columnDendrogramLineThicknessTextField.setEnabled(this.heatMapPanel.getColumnDendrogramPanel() != null);
        this.columnDendrogramThicknessLabel.setEnabled(this.heatMapPanel.getColumnDendrogramPanel() != null);
        if (this.heatMapPanel.getColumnDendrogramPanel() != null) {
            this.columnDendrogramLineThicknessTextField.setText(Formatter.toString(Float.valueOf(this.heatMapPanel.getColumnDendrogramPanel().getDendrogramLineThickness())));
            this.columnDendrogramColor.setColor(this.heatMapPanel.getColumnDendrogramPanel().getColor());
        }
        this.showImagesCheckBox.setEnabled(DatasetUtil.getSeriesIndex(this.heatMapPanel.getProject().getOriginalDataset(), ImageElement.class) >= 0);
        this.showImagesCheckBox.setSelected(this.heatMapPanel.getElementPainter() instanceof ImageElementPainter);
    }
}

