/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPTransferType;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEEFolderNode;
import org.broadinstitute.genee.application.History;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.application.UserUtil;
import org.broadinstitute.genee.gui.BackgroundTask;
import org.broadinstitute.genee.gui.actions.AnnotateAction;
import org.broadinstitute.genee.heatmap.Project;
import org.broadinstitute.genee.io.excel.AddToMetadataContentHandler;
import org.broadinstitute.genee.io.excel.ExcelReader;
import org.broadinstitute.genee.io.matrix.cls.ClsReader;
import org.broadinstitute.genee.io.util.ArchiveUtil;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.ProjectIO;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DefaultClassVector;
import org.broadinstitute.genee.matrix.VectorUtil;

public class ExampleDatasetsMenu
extends JMenu {
    public ExampleDatasetsMenu() {
        super("Open Example Data");
        AbstractAction golub1999 = new AbstractAction("Golub, Slonim et al. [Science 1999]"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.this.openFromFtpSite("Golub, Slonim et al. Science 1999.zip");
            }
        };
        AbstractAction luo2008 = new AbstractAction("Luo, Cheung, Subramanian et al. [PNAS 2008]"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.this.openFromFtpSite("Luo, Cheung, Subramanian et al. PNAS 2008.zip");
            }
        };
        if (UserUtil.isBroadUser()) {
            this.add(new AbstractAction("Project Achilles ATARiS Scores"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExampleDatasetsMenu.this.openFromHttpSite("Achilles ATARiS Scores", "http://www.broadinstitute.org/cancer/software/GENE-E/datasets/Achilles_QC_v2.4.rnai.Gs.gctx");
                }
            });
        }
        this.add(new AbstractAction("ASG001 PC3 24H (LINCS)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.this.openFromHttpSite("ASG001 PC3 24H (LINCS)", "http://www.broadinstitute.org/cancer/software/GENE-E/datasets/ASG001_PC3_24H_X2_B7_DUO52HI53LO_INF_mlr12k_n378x22268.gctx");
            }
        });
        this.add(new AbstractAction("CCLE"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExampleDatasetsMenu.this.openFromHttpSite("CCLE", "http://www.broadinstitute.org/cancer/software/GENE-E/datasets/ccle.gctx");
            }
        });
        this.add(golub1999);
        this.add(luo2008);
    }

    public void openFromHttpSite(final String name, final String gctx) {
        TrackerUtil.trackPageView(name);
        new BackgroundTask<ProjectGENEEResultTreeNode>(name){

            @Override
            protected void succeeded(ProjectGENEEResultTreeNode node) {
                Application.add(new GENEEFolderNode("Example Dataset", node.getAuditTrail().last(), node));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                File tmpFile = null;
                try {
                    tmpFile = File.createTempFile("tmpFile", ".gctx");
                    IOUtil.download(gctx, tmpFile);
                    Project project = ProjectIO.readProject(tmpFile.getCanonicalPath());
                    project.getOriginalDataset().setName(name);
                    ProjectGENEEResultTreeNode projectGENEEResultTreeNode = new ProjectGENEEResultTreeNode(project, new History("Opened " + name));
                    return projectGENEEResultTreeNode;
                }
                finally {
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectGENEEResultTreeNode createNodeFromArchive(String nodeName, String archiveFile) throws IOException {
        File extractToDir = null;
        File tmpArchiveFile = null;
        try {
            ProjectGENEEResultTreeNode node;
            if (!new File(archiveFile).exists()) {
                String archiveName = archiveFile.toLowerCase();
                String extension = ".zip";
                if (archiveName.endsWith(".tar.gz") || archiveName.endsWith(".tgz")) {
                    extension = ".tgz";
                } else if (archiveName.endsWith(".tar.bz2")) {
                    extension = ".tar.bz2";
                }
                tmpArchiveFile = File.createTempFile("archive", extension);
                IOUtil.download(archiveFile, tmpArchiveFile);
                archiveFile = IOUtil.getPath(tmpArchiveFile);
            }
            extractToDir = File.createTempFile("dir", ".tmp");
            extractToDir.delete();
            extractToDir.mkdir();
            ArchiveUtil.extract(new File(archiveFile), extractToDir);
            Project project = null;
            File[] files = new File[]{};
            try {
                files = IOUtil.listFiles(extractToDir, null, null, null, true);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (File f : files) {
                String name = f.getName().toLowerCase();
                if (!name.endsWith(".gct") && !name.endsWith(".gctx")) continue;
                Project tmp = ProjectIO.readProject(f.getCanonicalPath());
                if (tmp != null) {
                    project = tmp;
                }
                f.delete();
            }
            if (project == null) {
                throw new RuntimeException("No dataset found");
            }
            Dataset dataset = project.getOriginalDataset();
            for (File f : files) {
                String filename = f.getName().toLowerCase();
                if (filename.endsWith(".cls")) {
                    DefaultClassVector cls = new ClsReader().read(IOUtil.getPath(f));
                    AnnotateAction.loadClassVector(dataset.getColumnMetadata(), cls);
                } else if (filename.endsWith(".chip")) {
                    new ExcelReader(f.getCanonicalPath(), new AddToMetadataContentHandler(dataset.getRowMetadata(), project.getRowColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getRowMetadata().get(0)), true));
                } else if (filename.endsWith(".xls") || filename.endsWith(".xlsx")) {
                    new ExcelReader(f.getCanonicalPath(), new AddToMetadataContentHandler(dataset.getColumnMetadata(), project.getColumnColorModel(), null, VectorUtil.createStringValueToIndicesMap(dataset.getColumnMetadata().get(0)), false));
                }
                f.delete();
            }
            ProjectGENEEResultTreeNode projectGENEEResultTreeNode = node = new ProjectGENEEResultTreeNode(project, new History("Opened " + nodeName));
            return projectGENEEResultTreeNode;
        }
        finally {
            extractToDir.delete();
            if (tmpArchiveFile != null) {
                tmpArchiveFile.delete();
            }
        }
    }

    public void openFromFtpSite(final String zipFileName) {
        String name = IOUtil.getBaseFileName(zipFileName);
        TrackerUtil.trackPageView(name);
        new BackgroundTask<ProjectGENEEResultTreeNode>(name){

            @Override
            protected void succeeded(ProjectGENEEResultTreeNode node) {
                Application.add(new GENEEFolderNode("Example Dataset", node.getAuditTrail().last(), node));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected ProjectGENEEResultTreeNode doInBackground() throws Exception {
                File tmpFile = null;
                try {
                    tmpFile = ExampleDatasetsMenu.downloadZipFromFtpSite(zipFileName);
                    ProjectGENEEResultTreeNode projectGENEEResultTreeNode = ExampleDatasetsMenu.createNodeFromArchive(zipFileName, IOUtil.getPath(tmpFile));
                    return projectGENEEResultTreeNode;
                }
                finally {
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                }
            }
        }.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File downloadZipFromFtpSite(String filename) {
        FTPClient ftp = null;
        try {
            ftp = new FTPClient();
            ftp.setRemoteHost("gseaftp.broadinstitute.org");
            ftp.connect();
            ftp.login("gs3as3cr3tz", "asdf7hEGw");
            ftp.setType(FTPTransferType.BINARY);
            ftp.chdir("/pub/GENE-E/");
            File file = File.createTempFile("tmp", ".zip");
            FilterOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(file));
                ftp.get((OutputStream)bos, filename);
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
            File file2 = file;
            return file2;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException("Unable to connect to FTP server.");
        }
        finally {
            try {
                ftp.quit();
            }
            catch (Exception e) {}
        }
    }
}

