/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.broadinstitute.genee.gui.IconManager;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.SizesAndPositions;
import org.broadinstitute.genee.io.util.TrackerUtil;

public class FitToSizeAction
extends AbstractAction {
    private HeatMapPanel heatMapPanel;
    private float lastRowSize;
    private float lastColumnSize;
    private boolean fit = true;

    public FitToSizeAction(HeatMapPanel heatMapPanel) {
        super("Fit heat map to current window");
        this.putValue("ShortDescription", "Fit heat map to current window");
        this.putValue("SmallIcon", IconManager.loadIcon("16x16/13691.e_maximize.gif"));
        this.heatMapPanel = heatMapPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TrackerUtil.trackPageView((String)this.getValue("Name"));
        SizesAndPositions rowSizes = this.heatMapPanel.getRowSizesAndPositions();
        SizesAndPositions columnSizes = this.heatMapPanel.getColumnSizesAndPositions();
        if (!this.fit) {
            rowSizes.setSize(this.lastRowSize);
            columnSizes.setSize(this.lastColumnSize);
        } else {
            boolean squareAspect = (e.getModifiers() & 1) != 0;
            Dimension visibleRect = this.heatMapPanel.getVisibleSize();
            visibleRect.height -= 12;
            visibleRect.width -= 12;
            float totalHeight = rowSizes.getSize() + rowSizes.getPosition(rowSizes.getLength() - 1);
            float totalWidth = columnSizes.getSize() + columnSizes.getPosition(columnSizes.getLength() - 1);
            this.lastRowSize = rowSizes.getSize();
            this.lastColumnSize = columnSizes.getSize();
            float rowSize = rowSizes.getSize() * ((float)visibleRect.height / totalHeight);
            float columnSize = columnSizes.getSize() * ((float)visibleRect.width / totalWidth);
            if (squareAspect) {
                float size;
                rowSize = size = Math.min(rowSize, columnSize);
                columnSize = size;
            }
            rowSizes.setSize(rowSize);
            columnSizes.setSize(columnSize);
        }
        this.fit = !this.fit;
        this.heatMapPanel.getElementPanel().setIgnoreColumnSizesAndPositionsEvent(true);
        columnSizes.notifyListeners(4);
        this.heatMapPanel.getElementPanel().setIgnoreColumnSizesAndPositionsEvent(false);
        rowSizes.notifyListeners(4);
    }
}

