/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import org.broadinstitute.genee.gui.Drawable;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.DiscreteColorSupplier;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.IOUtil;

public class HeatMapColorSchemeLegend
extends JComponent
implements Drawable {
    private static final int DEFAULT_IMAGE_WIDTH = 400;
    private static final int DEFAULT_MAX_WIDTH = 500;
    private static final int DEFAULT_MIN_WIDTH_GLOBAL_SCHEME = 200;
    private static final int DEFAULT_MIN_WIDTH_RELATIVE_SCHEME = 120;
    private HeatMapColorScheme colorScheme;
    private boolean scalingStringVisible = true;
    private int fontSize = -1;
    private Dimension customDrawableSize;

    HeatMapColorSchemeLegend(HeatMapColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    @Override
    public void draw(Graphics g, Rectangle clip) {
        float[] fractions = this.colorScheme.getFractions();
        int imageHeight = 10;
        boolean isPaint = imageHeight == 0;
        int fontSize = this.fontSize != -1 ? this.fontSize : 10;
        g.setFont(new Font(UIUtil.getFontName(), 0, fontSize));
        Color[] colors = this.colorScheme.getColors();
        float min = this.colorScheme.getMin();
        float span = this.colorScheme.getMax() - min;
        Graphics2D g2 = (Graphics2D)g;
        g2.addRenderingHints(UIUtil.RENDERING_HINTS);
        g2.setPaint(Color.BLACK);
        FontMetrics fontMetrics = g.getFontMetrics();
        String lastTick = Formatter.format(fractions[fractions.length - 1] * span + min);
        int imageWidth = clip.width - fontMetrics.stringWidth(lastTick) - 1;
        int ascent = fontMetrics.getAscent();
        AffineTransform t = g2.getTransform();
        int topTextY = 1;
        if (this.scalingStringVisible) {
            String scalingString = this.colorScheme.getName();
            int sWidth = fontMetrics.stringWidth(scalingString);
            g2.drawString(scalingString, imageWidth / 2 - sWidth / 2, ascent);
            topTextY = fontMetrics.getHeight();
        }
        g2.translate(0, topTextY);
        g2.setPaint(this.colorScheme.isDiscrete() ? DiscreteColorSupplier.createPaint(imageWidth, fractions, colors) : new LinearGradientPaint(0.0f, 0.0f, imageWidth, 0.0f, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
        g.fillRect(0, 0, imageWidth, imageHeight);
        g2.setPaint(Color.BLACK);
        g.drawRect(0, 0, imageWidth, imageHeight);
        if (!isPaint) {
            g2.translate(0, imageHeight);
        } else {
            g2.translate(0, -topTextY);
        }
        if (this.colorScheme.isRelative() && this.colorScheme.getRowScalingMode() == 2) {
            int xpix = (int)(fractions[0] * (float)imageWidth);
            g.drawString("row min", xpix, ascent);
            xpix = (int)(fractions[fractions.length - 1] * (float)imageWidth);
            if (xpix > imageWidth) {
                xpix = imageWidth;
            }
            g.drawString("row max", xpix - g.getFontMetrics().stringWidth("row max"), ascent);
        } else {
            int[] indices = IOUtil.seqInt(colors.length);
            if (isPaint) {
                indices = new int[]{0, indices.length - 1};
            }
            for (int i = 0; i < indices.length; ++i) {
                int colorIndex = indices[i];
                float value = fractions[colorIndex] * span + min;
                String tick = Formatter.format(value);
                int xpix = (int)(fractions[colorIndex] * (float)imageWidth);
                if (i == indices.length - 1) {
                    xpix = xpix - g2.getFontMetrics().stringWidth(tick) - 1;
                }
                g.drawString(tick, xpix, ascent);
            }
        }
        g2.setTransform(t);
    }

    @Override
    public Dimension getDrawableSize() {
        if (this.customDrawableSize != null) {
            return this.customDrawableSize;
        }
        return new Dimension(400, 50);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension(400, 16);
    }

    public boolean isDrawableSizeSet() {
        return this.customDrawableSize != null;
    }

    public void setCustomDrawableSize(Dimension customDrawableSize) {
        this.customDrawableSize = customDrawableSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.revalidate();
        this.repaint();
    }

    public void setScalingStringVisible(boolean scalingStringVisible) {
        this.scalingStringVisible = scalingStringVisible;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width;
        super.paintComponent(g);
        int n = width = this.isPreferredSizeSet() ? this.getWidth() : this.getVisibleRect().width;
        if (width > 500) {
            width = 500;
        } else if (!this.colorScheme.isRelative() && width < 200) {
            width = 200;
        } else if (this.colorScheme.isRelative() && width < 120) {
            width = 120;
        }
        Rectangle clip = new Rectangle();
        clip.width = width;
        this.draw(g, clip);
    }
}

