/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.broadinstitute.genee.category.QualitativeColorSchemes;
import org.broadinstitute.genee.chart.ConditionalDrawingOptionsPanel;
import org.broadinstitute.genee.gui.ButtonGroupHelper;
import org.broadinstitute.genee.gui.EditColorButton;
import org.broadinstitute.genee.gui.FormBuilder;
import org.broadinstitute.genee.gui.TimerTextField;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.gui.parameters.MetadataComboBoxInputParameter;
import org.broadinstitute.genee.heatmap.DefaultHeatMapColorScheme;
import org.broadinstitute.genee.heatmap.DiscreteColorSupplier;
import org.broadinstitute.genee.heatmap.HeatMapColorScheme;
import org.broadinstitute.genee.heatmap.HeatMapPanel;
import org.broadinstitute.genee.heatmap.LinearGradientChooserPanel;
import org.broadinstitute.genee.io.util.Formatter;
import org.broadinstitute.genee.io.util.ParserHelper;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;

public class HeatMapColorSchemeOptionsPanel
implements ActionListener {
    private static ArrayList<PredefinedColorScheme> PREDEFINED_SCHEMES;
    private JRadioButton customGlobalMaxRadioButton;
    private JRadioButton customGlobalMinRadioButton;
    private JComboBox datasetComboBox;
    private JCheckBox discreteCheckBox;
    private JLabel discreteDetailsLabel;
    private JRadioButton globalColorButton;
    private TimerTextField globalMaxTextField;
    private TimerTextField globalMinTextField;
    private String globalSettings = "Global Settings";
    private LinearGradientChooserPanel gradientChooserPanel;
    private HeatMapPanel heatMapPanel;
    private JCheckBox logScaleCheckBox;
    private EditColorButton missingColorButton;
    private JRadioButton relativeColorButton;
    private TimerTextField rowMaxTextField;
    private TimerTextField rowMinTextField;
    private JRadioButton scaleUsingRowMinMax;
    private boolean showMissingColor = true;
    private boolean showPredefined = true;
    private boolean showRelativeSettings = true;
    private ThumbDataListener thumbDataListener;
    private String title = "Color Settings";
    private JRadioButton useDataset10;
    private JRadioButton useDataset90;
    private JRadioButton useDatasetMax;
    private JRadioButton useDatasetMin;
    private JRadioButton zMADButton;
    private JRadioButton zScoreButton;
    private MetadataComboBoxInputParameter scaleColumnsSeparatelyField;
    private JCheckBox scaleColumnsSeparatelyCheckBox;

    public static void loadPredefinedColorScheme(HeatMapColorScheme s, String shortName) {
        for (PredefinedColorScheme item : PREDEFINED_SCHEMES) {
            if (!shortName.equals(item.shortName)) continue;
            item.load(s);
            break;
        }
    }

    public HeatMapColorSchemeOptionsPanel(HeatMapPanel heatMapPanel) {
        this.heatMapPanel = heatMapPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.relativeColorButton || e.getSource() == this.globalColorButton) {
            boolean relative = e.getSource() == this.relativeColorButton;
            this.heatMapPanel.getColorScheme().setRelative(relative);
            this.enableComponents();
        } else if (e.getSource() == this.missingColorButton) {
            this.heatMapPanel.getColorScheme().setMissingColor(this.missingColorButton.getColor());
        } else if (e.getSource() == this.zScoreButton) {
            this.heatMapPanel.getColorScheme().setRowScalingMode(3);
            this.enableComponents();
        } else if (e.getSource() == this.scaleUsingRowMinMax) {
            this.heatMapPanel.getColorScheme().setRowScalingMode(2);
            this.enableComponents();
        } else if (e.getSource() == this.zMADButton) {
            this.heatMapPanel.getColorScheme().setRowScalingMode(4);
            this.enableComponents();
        } else if (e.getSource() == this.logScaleCheckBox) {
            this.heatMapPanel.getColorScheme().setLogScale(this.logScaleCheckBox.isSelected());
        } else if (e.getSource() == this.discreteCheckBox) {
            this.heatMapPanel.getColorScheme().setDiscrete(this.discreteCheckBox.isSelected());
            this.gradientChooserPanel.setColors(this.heatMapPanel.getColorScheme().isDiscrete(), this.heatMapPanel.getColorScheme().getColors(), this.heatMapPanel.getColorScheme().getFractions());
            this.heatMapPanel.invalidateImage();
            this.discreteDetailsLabel.setVisible(this.discreteCheckBox.isSelected());
        } else if (e.getSource() == this.datasetComboBox) {
            String name = (String)this.datasetComboBox.getSelectedItem();
            this.heatMapPanel.getColorScheme().setDatasetName(name);
        } else if (e.getSource() == this.scaleColumnsSeparatelyCheckBox) {
            this.scaleColumnsSeparatelyField.setEnabled(this.scaleColumnsSeparatelyCheckBox.isEnabled() && this.scaleColumnsSeparatelyCheckBox.isSelected());
            this.heatMapPanel.getColorScheme().setSeparateColorSchemesForColumnMetadataField(this.scaleColumnsSeparatelyField.getParameterValue());
        } else if (e.getSource() == this.scaleColumnsSeparatelyField) {
            this.heatMapPanel.getColorScheme().setSeparateColorSchemesForColumnMetadataField(this.scaleColumnsSeparatelyField.getParameterValue());
        }
        this.gradientChooserPanel.setMinMax(this.heatMapPanel.getColorScheme().getMin(), this.heatMapPanel.getColorScheme().getMax());
        this.heatMapPanel.invalidateImage();
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel(){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                UIUtil.setChildrenEnabledRecursively(this, enabled);
                UIUtil.setChildrenEnabledRecursively(HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel, enabled);
            }
        };
        final FormBuilder formBuilder = new FormBuilder(panel);
        formBuilder.addSeparator("Dataset");
        formBuilder.addLabel("Color by:");
        this.datasetComboBox = UIUtil.createComboBox();
        ConditionalDrawingOptionsPanel.rebuildDatasetCombobox(this.heatMapPanel.getProject(), this.datasetComboBox);
        formBuilder.add(this.datasetComboBox);
        formBuilder.addSeparator(this.title);
        if (this.showRelativeSettings) {
            formBuilder.addLabel("Color scheme:");
            this.relativeColorButton = new JRadioButton("Relative");
            formBuilder.add(this.relativeColorButton);
            this.globalColorButton = new JRadioButton("Global");
            formBuilder.nextSmallRow();
            formBuilder.add(this.globalColorButton);
            ButtonGroup bg1 = new ButtonGroup();
            bg1.add(this.relativeColorButton);
            bg1.add(this.globalColorButton);
        }
        this.gradientChooserPanel = new LinearGradientChooserPanel();
        this.gradientChooserPanel.setColors(this.heatMapPanel.getColorScheme().isDiscrete(), this.heatMapPanel.getColorScheme().getColors(), this.heatMapPanel.getColorScheme().getFractions());
        this.thumbDataListener = new ThumbDataListener(){

            public void positionChanged(ThumbDataEvent e) {
                this.update();
            }

            public void thumbAdded(ThumbDataEvent e) {
                this.update();
            }

            public void thumbRemoved(ThumbDataEvent e) {
                this.update();
            }

            public void update() {
                LinearGradientChooserPanel.FractionColorPair[] pairs = HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.getFractionColorPairs();
                float[] fractions = new float[pairs.length];
                Color[] colors = new Color[pairs.length];
                for (int i = 0; i < fractions.length; ++i) {
                    fractions[i] = pairs[i].getFraction();
                    colors[i] = pairs[i].getColor();
                }
                HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setColors(colors, fractions);
                HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
            }

            public void valueChanged(ThumbDataEvent e) {
                this.update();
            }
        };
        this.gradientChooserPanel.addThumbDataListener(this.thumbDataListener);
        formBuilder.nextRow();
        formBuilder.add(this.gradientChooserPanel);
        formBuilder.nextRow();
        if (this.showMissingColor) {
            this.missingColorButton = new EditColorButton(this.heatMapPanel.getColorScheme().getMissingColor());
            this.missingColorButton.setColor(this.heatMapPanel.getColorScheme().getMissingColor());
            formBuilder.addLabel("Missing color:");
            formBuilder.add(this.missingColorButton);
        }
        formBuilder.nextRow();
        this.logScaleCheckBox = new JCheckBox("Log scale", false);
        formBuilder.addSpanned(this.logScaleCheckBox);
        this.discreteCheckBox = new JCheckBox("Discrete colors", false);
        formBuilder.nextRow();
        formBuilder.addSpanned(this.discreteCheckBox);
        this.discreteDetailsLabel = UIUtil.createSmallLabel("Intervals include right end point and exclude left end point except for the lowest interval");
        this.discreteDetailsLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        formBuilder.nextRowNoSpace();
        formBuilder.addSpanned(this.discreteDetailsLabel);
        if (this.showRelativeSettings) {
            formBuilder.addSeparator("Relative Settings");
            ButtonGroupHelper bg = new ButtonGroupHelper();
            this.zScoreButton = bg.createRadioButton("Subtract row mean, divide by row standard deviation", this.heatMapPanel.getColorScheme().getRowScalingMode() == 3);
            this.zMADButton = bg.createRadioButton("Subtract row median, divide by row median absolute deviation", this.heatMapPanel.getColorScheme().getRowScalingMode() == 3);
            this.scaleUsingRowMinMax = bg.createRadioButton("Row minimum and row maximum", this.heatMapPanel.getColorScheme().getRowScalingMode() == 2);
            this.scaleColumnsSeparatelyCheckBox = new JCheckBox("Scale columns separately by:");
            formBuilder.addFirstColumn(this.scaleColumnsSeparatelyCheckBox);
            this.scaleColumnsSeparatelyField = new MetadataComboBoxInputParameter(false);
            formBuilder.add((Component)((Object)this.scaleColumnsSeparatelyField));
            formBuilder.nextRow();
            formBuilder.addLabel("Color values using:");
            formBuilder.add(this.scaleUsingRowMinMax);
            formBuilder.nextSmallRow();
            formBuilder.add(this.zScoreButton);
            formBuilder.nextSmallRow();
            formBuilder.add(this.zMADButton);
            formBuilder.nextRow();
            formBuilder.addLabel("Row minimum:");
            this.rowMinTextField = new TimerTextField(){

                @Override
                public void update() {
                    try {
                        String text = this.getText().trim();
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setRowNormalizedMin(ParserHelper.parseFloat(text));
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            };
            this.rowMinTextField.setTextNoUpdate(Formatter.format(this.heatMapPanel.getColorScheme().getRowNormalizedMin()));
            formBuilder.add(this.rowMinTextField);
            formBuilder.nextRow();
            formBuilder.addLabel("Row maximum:");
            this.rowMaxTextField = new TimerTextField(){

                @Override
                public void update() {
                    try {
                        String text = this.getText().trim();
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setRowNormalizedMax(ParserHelper.parseFloat(text));
                        HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setMinMax(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMin(), HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMax());
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            };
            formBuilder.add(this.rowMaxTextField);
            this.rowMaxTextField.setTextNoUpdate(Formatter.format(this.heatMapPanel.getColorScheme().getRowNormalizedMax()));
        }
        if (this.globalSettings != null) {
            formBuilder.addSeparator(this.globalSettings);
        }
        ButtonGroupHelper minGlobalButtonGroup = new ButtonGroupHelper();
        this.useDatasetMin = minGlobalButtonGroup.createRadioButton("Dataset minimum", this.heatMapPanel.getColorScheme() == null ? true : this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 0);
        ActionListener minActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorSchemeOptionsPanel.this.globalMinTextField.setEnabled(false);
                if (e.getSource() == HeatMapColorSchemeOptionsPanel.this.useDatasetMin) {
                    HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMinMode(0);
                    HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setMinMax(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMin(), HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMax());
                } else if (e.getSource() == HeatMapColorSchemeOptionsPanel.this.useDataset10) {
                    HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMinMode(1);
                    HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setMinMax(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMin(), HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMax());
                }
                HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
            }
        };
        this.useDataset10 = minGlobalButtonGroup.createRadioButton("Dataset 10th percentile", this.heatMapPanel.getColorScheme() == null ? false : this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 1);
        this.useDatasetMin.addActionListener(minActionListener);
        this.useDataset10.addActionListener(minActionListener);
        this.customGlobalMinRadioButton = minGlobalButtonGroup.createRadioButton("Custom:", this.heatMapPanel.getColorScheme() == null ? false : this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 2);
        this.customGlobalMinRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorSchemeOptionsPanel.this.globalMinTextField.setEnabled(HeatMapColorSchemeOptionsPanel.this.customGlobalMinRadioButton.isSelected());
                if (HeatMapColorSchemeOptionsPanel.this.customGlobalMinRadioButton.isSelected()) {
                    HeatMapColorSchemeOptionsPanel.this.globalMinTextField.update();
                }
            }
        });
        this.globalMinTextField = new TimerTextField(){

            @Override
            public void update() {
                try {
                    String text = HeatMapColorSchemeOptionsPanel.this.globalMinTextField.getText().trim();
                    if (text.equals("")) {
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMinMode(0);
                    } else {
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMinMode(2, ParserHelper.parseFloat(text));
                    }
                    HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setMinMax(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMin(), HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMax());
                    HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        if (this.customGlobalMinRadioButton.isSelected() && this.heatMapPanel.getColorScheme() != null) {
            this.globalMinTextField.setText(Formatter.format(this.heatMapPanel.getColorScheme().getCustomGlobalMin()));
        }
        this.globalMinTextField.setEnabled(this.customGlobalMinRadioButton.isSelected());
        formBuilder.nextRow();
        formBuilder.addLabel("Global minimum:");
        formBuilder.add(this.useDatasetMin);
        formBuilder.nextSmallRow();
        formBuilder.add(this.useDataset10);
        formBuilder.nextSmallRow();
        formBuilder.add(new FormBuilder().nextRow().addFirstColumn(this.customGlobalMinRadioButton).add(this.globalMinTextField).getPanel());
        formBuilder.nextSmallRow();
        ButtonGroupHelper maxGlobalButtonGroup = new ButtonGroupHelper();
        this.customGlobalMaxRadioButton = maxGlobalButtonGroup.createRadioButton("Custom:", this.heatMapPanel.getColorScheme() == null ? false : this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 2);
        this.customGlobalMaxRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorSchemeOptionsPanel.this.globalMaxTextField.setEnabled(HeatMapColorSchemeOptionsPanel.this.customGlobalMaxRadioButton.isSelected());
                if (HeatMapColorSchemeOptionsPanel.this.customGlobalMaxRadioButton.isSelected()) {
                    HeatMapColorSchemeOptionsPanel.this.globalMaxTextField.update();
                }
            }
        });
        this.globalMaxTextField = new TimerTextField(){

            @Override
            public void update() {
                String text = HeatMapColorSchemeOptionsPanel.this.globalMaxTextField.getText().trim();
                if (text.equals("")) {
                    HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMaxMode(0);
                } else {
                    HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMaxMode(2, ParserHelper.parseFloat(text));
                }
                HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setMinMax(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMin(), HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMax());
                HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
            }
        };
        if (this.customGlobalMaxRadioButton.isSelected() && this.heatMapPanel.getColorScheme() != null) {
            this.globalMaxTextField.setText(Formatter.format(this.heatMapPanel.getColorScheme().getCustomGlobalMax()));
        }
        this.globalMaxTextField.setEnabled(this.customGlobalMaxRadioButton.isSelected());
        this.useDatasetMax = maxGlobalButtonGroup.createRadioButton("Dataset maximum", this.heatMapPanel.getColorScheme() == null ? true : this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 0);
        ActionListener maxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatMapColorSchemeOptionsPanel.this.globalMaxTextField.setEnabled(false);
                if (e.getSource() == HeatMapColorSchemeOptionsPanel.this.useDatasetMax) {
                    HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMaxMode(0);
                    HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setMinMax(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMin(), HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMax());
                } else {
                    HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().setGlobalMaxMode(1);
                    HeatMapColorSchemeOptionsPanel.this.gradientChooserPanel.setMinMax(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMin(), HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme().getMax());
                }
                HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
            }
        };
        this.useDatasetMax.addActionListener(maxActionListener);
        this.useDataset90 = maxGlobalButtonGroup.createRadioButton("Dataset 90th percentile", this.heatMapPanel.getColorScheme() == null ? false : this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 1);
        this.useDataset90.addActionListener(maxActionListener);
        formBuilder.nextRow();
        formBuilder.addLabel("Global maximum:");
        formBuilder.add(this.useDatasetMax);
        formBuilder.nextSmallRow();
        formBuilder.add(this.useDataset90);
        formBuilder.nextSmallRow();
        formBuilder.add(new FormBuilder().nextRow().addFirstColumn(this.customGlobalMaxRadioButton).add(this.globalMaxTextField).getPanel());
        if (this.showPredefined) {
            formBuilder.addSeparator("Predefined Color Schemes");
            formBuilder.nextRow();
            final JButton saveBtn = new JButton("Save Current Settings\u2026");
            formBuilder.add(saveBtn);
            formBuilder.nextRow();
            final JComboBox saveColorSchemesComboBox = UIUtil.createComboBox();
            this.populateSavedColorSchemes(saveColorSchemesComboBox);
            formBuilder.addLabel("Predefined Schemes:");
            CellConstraints cc = new CellConstraints();
            JPanel predefPanel = new JPanel((LayoutManager)new FormLayout(UIUtil.createColumnStringForFormLayout("left:p", 3), "p"));
            predefPanel.add((Component)saveColorSchemesComboBox, cc.xy(1, 1));
            final JButton loadBtn = new JButton("Load");
            final JButton deleteBtn = new JButton("Delete");
            ActionListener btnListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == saveBtn) {
                        String name = UIUtil.showInputDialog(formBuilder.getPanel(), "Please enter a name", "");
                        if (name != null) {
                            DefaultHeatMapColorScheme.save(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme(), name);
                            saveColorSchemesComboBox.addItem(name);
                        }
                        HeatMapColorSchemeOptionsPanel.this.populateSavedColorSchemes(saveColorSchemesComboBox);
                    } else if (e.getSource() == loadBtn) {
                        if (saveColorSchemesComboBox.getSelectedIndex() < PREDEFINED_SCHEMES.size()) {
                            ((PredefinedColorScheme)PREDEFINED_SCHEMES.get(saveColorSchemesComboBox.getSelectedIndex())).load(HeatMapColorSchemeOptionsPanel.this.heatMapPanel.getColorScheme());
                        } else {
                            HeatMapColorScheme cs = DefaultHeatMapColorScheme.load((String)saveColorSchemesComboBox.getSelectedItem());
                            HeatMapColorSchemeOptionsPanel.this.heatMapPanel.setColorScheme(cs);
                        }
                        HeatMapColorSchemeOptionsPanel.this.heatMapPanel.invalidateImage();
                    } else if (e.getSource() == deleteBtn) {
                        Preferences prefs = Preferences.userNodeForPackage(HeatMapColorScheme.class);
                        Preferences node = prefs.node("color.scheme");
                        String name = (String)saveColorSchemesComboBox.getSelectedItem();
                        node = node.node(name);
                        try {
                            node.removeNode();
                            saveColorSchemesComboBox.removeItem(name);
                        }
                        catch (BackingStoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                    loadBtn.setEnabled(saveColorSchemesComboBox.getItemCount() > 0);
                    deleteBtn.setEnabled(saveColorSchemesComboBox.getSelectedIndex() > PREDEFINED_SCHEMES.size());
                    HeatMapColorSchemeOptionsPanel.this.configureValues();
                }
            };
            saveColorSchemesComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    deleteBtn.setEnabled(saveColorSchemesComboBox.getSelectedIndex() >= PREDEFINED_SCHEMES.size());
                }
            });
            loadBtn.setEnabled(saveColorSchemesComboBox.getItemCount() > 0);
            deleteBtn.setEnabled(false);
            loadBtn.addActionListener(btnListener);
            deleteBtn.addActionListener(btnListener);
            saveBtn.addActionListener(btnListener);
            predefPanel.add((Component)loadBtn, cc.xy(3, 1));
            predefPanel.add((Component)deleteBtn, cc.xy(5, 1));
            formBuilder.add(predefPanel);
        }
        if (this.heatMapPanel.getColorScheme() != null) {
            this.gradientChooserPanel.setMinMax(this.heatMapPanel.getColorScheme().getMin(), this.heatMapPanel.getColorScheme().getMax());
        }
        if (this.showRelativeSettings && this.heatMapPanel.getColorScheme() != null) {
            this.relativeColorButton.setSelected(this.heatMapPanel.getColorScheme().isRelative());
            this.globalColorButton.setSelected(!this.heatMapPanel.getColorScheme().isRelative());
            this.relativeColorButton.addActionListener(this);
            this.globalColorButton.addActionListener(this);
            this.scaleColumnsSeparatelyCheckBox.addActionListener(this);
            this.scaleColumnsSeparatelyField.addActionListener(this);
            this.zScoreButton.addActionListener(this);
            this.scaleUsingRowMinMax.addActionListener(this);
            this.zMADButton.addActionListener(this);
        }
        if (this.showMissingColor) {
            this.missingColorButton.addActionListener(this);
        }
        this.logScaleCheckBox.addActionListener(this);
        this.datasetComboBox.addActionListener(this);
        this.discreteCheckBox.addActionListener(this);
        this.enableComponents();
        return formBuilder.getPanel();
    }

    public void setGlobalSettings(String globalSettings) {
        this.globalSettings = globalSettings;
    }

    public void setShowMissingColor(boolean showMissingColor) {
        this.showMissingColor = showMissingColor;
    }

    public void setShowPredefined(boolean showPredefined) {
        this.showPredefined = showPredefined;
    }

    public void setShowRelativeSettings(boolean showRelativeSettings) {
        this.showRelativeSettings = showRelativeSettings;
    }

    void configureValues() {
        this.gradientChooserPanel.removeThumbDataListener(this.thumbDataListener);
        if (this.heatMapPanel.getColorScheme() != null) {
            this.scaleColumnsSeparatelyCheckBox.setSelected(this.heatMapPanel.getColorScheme().getSeparateColorSchemesForColumnMetadataField() != null);
            this.scaleColumnsSeparatelyField.init(this.heatMapPanel.getProject());
            this.scaleColumnsSeparatelyField.setEnabled(this.scaleColumnsSeparatelyCheckBox.isSelected());
            this.scaleColumnsSeparatelyField.setSelectedItem(this.heatMapPanel.getColorScheme().getSeparateColorSchemesForColumnMetadataField());
            this.globalColorButton.setSelected(!this.heatMapPanel.getColorScheme().isRelative());
            this.gradientChooserPanel.setMinMax(this.heatMapPanel.getColorScheme().getMin(), this.heatMapPanel.getColorScheme().getMax());
            this.gradientChooserPanel.setColors(this.heatMapPanel.getColorScheme().isDiscrete(), this.heatMapPanel.getColorScheme().getColors(), this.heatMapPanel.getColorScheme().getFractions());
            this.datasetComboBox.removeActionListener(this);
            ConditionalDrawingOptionsPanel.rebuildDatasetCombobox(this.heatMapPanel.getProject(), this.datasetComboBox);
            this.datasetComboBox.setSelectedItem(this.heatMapPanel.getColorScheme().getDatasetName());
            this.datasetComboBox.addActionListener(this);
            this.relativeColorButton.setSelected(this.heatMapPanel.getColorScheme().isRelative());
            this.rowMaxTextField.setTextNoUpdate(Formatter.format(this.heatMapPanel.getColorScheme().getRowNormalizedMax()));
            this.rowMinTextField.setTextNoUpdate(Formatter.format(this.heatMapPanel.getColorScheme().getRowNormalizedMin()));
            this.scaleUsingRowMinMax.setSelected(this.heatMapPanel.getColorScheme().getRowScalingMode() == 2);
            this.zScoreButton.setSelected(this.heatMapPanel.getColorScheme().getRowScalingMode() == 3);
            this.zMADButton.setSelected(this.heatMapPanel.getColorScheme().getRowScalingMode() == 4);
            if (this.showMissingColor) {
                this.missingColorButton.setColor(this.heatMapPanel.getColorScheme().getMissingColor());
            }
            this.useDataset10.setSelected(this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 1);
            this.useDataset90.setSelected(this.heatMapPanel.getColorScheme().getMaxGlobalScalingMode() == 1);
            this.useDatasetMin.setSelected(this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 0);
            this.useDatasetMax.setSelected(this.heatMapPanel.getColorScheme().getMaxGlobalScalingMode() == 0);
            this.customGlobalMinRadioButton.setSelected(this.heatMapPanel.getColorScheme().getMinGlobalScalingMode() == 2);
            this.customGlobalMaxRadioButton.setSelected(this.heatMapPanel.getColorScheme().getMaxGlobalScalingMode() == 2);
            this.logScaleCheckBox.setSelected(this.heatMapPanel.getColorScheme().isLogScale());
            this.discreteCheckBox.setSelected(this.heatMapPanel.getColorScheme().isDiscrete());
            this.discreteDetailsLabel.setVisible(this.discreteCheckBox.isSelected());
            if (this.customGlobalMinRadioButton.isSelected()) {
                this.globalMinTextField.setTextNoUpdate(Formatter.format(this.heatMapPanel.getColorScheme().getCustomGlobalMin()));
            }
            if (this.customGlobalMaxRadioButton.isSelected()) {
                this.globalMaxTextField.setTextNoUpdate(Formatter.format(this.heatMapPanel.getColorScheme().getCustomGlobalMax()));
            }
            this.enableComponents();
        }
        this.gradientChooserPanel.addThumbDataListener(this.thumbDataListener);
    }

    private void enableComponents() {
        if (this.heatMapPanel.getColorScheme() != null) {
            if (this.showRelativeSettings) {
                this.zScoreButton.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
                this.scaleUsingRowMinMax.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
                this.zMADButton.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
                this.rowMinTextField.setEnabled(this.heatMapPanel.getColorScheme().getRowScalingMode() != 2 && this.heatMapPanel.getColorScheme().isRelative());
                this.rowMaxTextField.setEnabled(this.rowMinTextField.isEnabled());
                this.scaleColumnsSeparatelyCheckBox.setEnabled(this.heatMapPanel.getColorScheme().isRelative());
                this.scaleColumnsSeparatelyField.setEnabled(this.scaleColumnsSeparatelyCheckBox.isEnabled() && this.scaleColumnsSeparatelyCheckBox.isSelected());
            }
            this.globalMinTextField.setEnabled(this.customGlobalMinRadioButton.isSelected() && !this.heatMapPanel.getColorScheme().isRelative());
            this.customGlobalMinRadioButton.setEnabled(!this.heatMapPanel.getColorScheme().isRelative());
            this.customGlobalMaxRadioButton.setEnabled(!this.heatMapPanel.getColorScheme().isRelative());
            this.globalMaxTextField.setEnabled(this.customGlobalMaxRadioButton.isSelected() && !this.heatMapPanel.getColorScheme().isRelative());
            this.useDatasetMin.setEnabled(!this.heatMapPanel.getColorScheme().isRelative());
            this.useDataset10.setEnabled(!this.heatMapPanel.getColorScheme().isRelative());
            this.useDatasetMax.setEnabled(!this.heatMapPanel.getColorScheme().isRelative());
            this.useDataset90.setEnabled(!this.heatMapPanel.getColorScheme().isRelative());
        } else {
            this.globalMinTextField.setEnabled(false);
            this.customGlobalMinRadioButton.setEnabled(false);
            this.customGlobalMaxRadioButton.setEnabled(false);
            this.globalMaxTextField.setEnabled(false);
            this.useDatasetMin.setEnabled(false);
            this.useDataset10.setEnabled(false);
            this.useDatasetMax.setEnabled(false);
            this.useDataset90.setEnabled(false);
        }
    }

    private void populateSavedColorSchemes(JComboBox saveColorSchemesComboBox) {
        saveColorSchemesComboBox.removeAllItems();
        for (PredefinedColorScheme item : PREDEFINED_SCHEMES) {
            saveColorSchemesComboBox.addItem(item.longName);
        }
        try {
            String[] keys;
            Preferences prefs = Preferences.userNodeForPackage(HeatMapColorScheme.class);
            Preferences node = prefs.node("color.scheme");
            for (String key : keys = node.childrenNames()) {
                saveColorSchemesComboBox.addItem(key);
            }
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
    }

    private static void createPredefinedColorSchemes() {
        PREDEFINED_SCHEMES = new ArrayList();
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("non-ratio", "Default color scheme for non-ratio data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setRelative(true);
                cs.setRowScalingMode(2);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("ratio", "Default color scheme for ratio data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setGlobalMaxMode(2, 3.0f);
                cs.setGlobalMinMode(2, -3.0f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("cn", "Default color scheme for copy number data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setGlobalMaxMode(2, 1.5f);
                cs.setGlobalMinMode(2, -1.5f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.RED});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("z-score", "Default color scheme for z-scored data"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setDiscrete(false);
                cs.setGlobalMaxMode(2, 10.0f);
                cs.setGlobalMinMode(2, -10.0f);
                cs.setColors(new Color[]{Color.BLUE, Color.WHITE, Color.WHITE, Color.RED}, new float[]{0.0f, 0.4f, 0.6f, 1.0f});
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("jet", "Jet color scheme"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setGlobalMaxMode(0);
                cs.setGlobalMinMode(0);
                cs.setDiscrete(true);
                Color[] colors = DiscreteColorSupplier.createJetColors();
                float[] fractions = DiscreteColorSupplier.createFractions(colors);
                cs.setColors(colors, fractions);
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("binary", "Binary scheme"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setGlobalMaxMode(2, 1.0f);
                cs.setGlobalMinMode(2, 0.0f);
                cs.setDiscrete(true);
                Color[] colors = new Color[]{Color.WHITE, QualitativeColorSchemes.getTenColor(0)};
                float[] fractions = DiscreteColorSupplier.createFractions(colors);
                cs.setColors(colors, fractions);
            }
        });
        PREDEFINED_SCHEMES.add(new PredefinedColorScheme("synergy", "Synergy scheme"){

            @Override
            public void load(HeatMapColorScheme cs) {
                cs.setGlobalMinMode(2, 0.2f);
                cs.setGlobalMaxMode(2, 0.7f);
                cs.setColors(new Color[]{Color.WHITE, Color.RED}, new float[]{0.0f, 1.0f});
            }
        });
    }

    static {
        HeatMapColorSchemeOptionsPanel.createPredefinedColorSchemes();
    }

    private static abstract class PredefinedColorScheme {
        private String longName;
        private String shortName;

        public PredefinedColorScheme(String shortName, String longName) {
            this.shortName = shortName;
            this.longName = longName;
        }

        public abstract void load(HeatMapColorScheme var1);
    }
}

