/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.GENEEResultNodeGroup;
import org.broadinstitute.genee.matrix.Dataset;
import org.broadinstitute.genee.matrix.DatasetAdapter;
import org.broadinstitute.genee.matrix.DatasetUtil;
import org.broadinstitute.genee.matrix.Identifier;
import org.broadinstitute.genee.matrix.MetadataUtil;
import org.broadinstitute.genee.matrix.VectorUtil;

public class LinkProjects {
    public void link(ProjectGENEEResultTreeNode childNode, String[] childRowFieldToMatchOn, String[] childColumnFieldToMatchOn, ProjectGENEEResultTreeNode ownerNode, String[] ownerRowFieldToMatchOn, String[] ownerColumnFieldToMatchOn) {
        HashSet<ProjectGENEEResultTreeNode> nodes;
        Map<Identifier, Integer> ownerRowNameToIndex = null;
        Map<Identifier, Integer> ownerColumnNameToIndex = null;
        try {
            ownerRowNameToIndex = VectorUtil.createValuesToIndexMap(MetadataUtil.getVectors(ownerNode.getProject().getOriginalDataset().getRowMetadata(), ownerRowFieldToMatchOn));
            ownerColumnNameToIndex = VectorUtil.createValuesToIndexMap(MetadataUtil.getVectors(ownerNode.getProject().getOriginalDataset().getColumnMetadata(), ownerColumnFieldToMatchOn));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        Reorder childReorder = new Reorder(childNode.getProject().getOriginalDataset(), ownerRowNameToIndex, ownerColumnNameToIndex, childRowFieldToMatchOn, childColumnFieldToMatchOn);
        if (!childReorder.linkRows || !childReorder.linkColumns) {
            UIUtil.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow(), "Unable to link to " + ownerNode.toString() + ".");
            return;
        }
        GENEEResultNodeGroup ownerGroup = ownerNode.getGroup();
        if (ownerGroup == null) {
            ownerGroup = new GENEEResultNodeGroup();
            ownerNode.setGroup(ownerGroup);
        }
        ownerGroup.setParentNode(ownerNode);
        GENEEResultNodeGroup childGroup = childNode.getGroup();
        if (childGroup != null) {
            nodes = new HashSet<ProjectGENEEResultTreeNode>(childGroup.getChildNodes());
            if (childGroup.getParentNode() != null) {
                nodes.add(childGroup.getParentNode());
            }
            for (ProjectGENEEResultTreeNode n : childGroup.getChildNodes()) {
                n.setGroup(ownerGroup);
                Reorder reorder = new Reorder(n.getProject().getOriginalDataset(), ownerRowNameToIndex, ownerColumnNameToIndex, childRowFieldToMatchOn, childColumnFieldToMatchOn);
                if (!reorder.linkRows || !reorder.linkColumns) continue;
                Dataset childDataset = reorder.getReorderedDataset();
                n.getProject().setDataset(childDataset);
                ownerGroup.addChild(n);
            }
            childGroup.dispose();
        }
        childNode.setGroup(ownerGroup);
        childNode.getProject().setDataset(childReorder.getReorderedDataset());
        ownerGroup.addChild(childNode);
        nodes = new HashSet<ProjectGENEEResultTreeNode>(ownerGroup.getChildNodes());
        nodes.add(ownerGroup.getParentNode());
        if (ownerNode.getProject().getOriginalDataset() instanceof LinkedDataset) {
            ownerNode.getProject().setDataset(((DatasetAdapter)ownerNode.getProject().getOriginalDataset()).getDataset());
        }
        for (ProjectGENEEResultTreeNode node : nodes) {
            if (node == null || node.getProject() == null) continue;
            Dataset dataset = node.getProject().getOriginalDataset();
            dataset = dataset instanceof LinkedDataset ? ((DatasetAdapter)dataset).getDataset() : dataset;
            LinkedDataset linkedDataset = new LinkedDataset(dataset);
            for (ProjectGENEEResultTreeNode node2 : nodes) {
                if (node2 == null || node2 == node) continue;
                Dataset d2 = node2.getProject().getOriginalDataset();
                d2 = d2 instanceof LinkedDataset ? ((DatasetAdapter)d2).getDataset() : d2;
                linkedDataset.add(d2);
            }
            node.getProject().setDataset(linkedDataset);
        }
    }

    private static class Reorder {
        private Dataset childDataset;
        private boolean linkRows = true;
        private boolean linkColumns = true;

        private Reorder(Dataset childDataset, Map<Identifier, Integer> ownerRowNameToIndex, Map<Identifier, Integer> ownerColumnNameToIndex, String[] childRowFieldToMatchOn, String[] childColumnFieldToMatchOn) {
            childDataset = childDataset instanceof LinkedDataset ? ((DatasetAdapter)childDataset).getDataset() : childDataset;
            int[] rowOrder = null;
            try {
                boolean inOrder = true;
                rowOrder = new int[childDataset.getRowCount()];
                int rows = childDataset.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    Identifier id = VectorUtil.createIdentifier(childDataset.getRowMetadata(), childRowFieldToMatchOn, i);
                    Integer index = ownerRowNameToIndex.get(id);
                    if (index == null) {
                        this.linkRows = false;
                        rowOrder = null;
                        break;
                    }
                    rowOrder[i] = index;
                    inOrder = inOrder && index == i;
                }
                if (inOrder) {
                    rowOrder = null;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                this.linkRows = false;
                rowOrder = null;
            }
            int[] columnOrder = null;
            if (this.linkColumns) {
                try {
                    columnOrder = new int[childDataset.getColumnCount()];
                    boolean inOrder = true;
                    int cols = childDataset.getColumnCount();
                    for (int j = 0; j < cols; ++j) {
                        Identifier id = VectorUtil.createIdentifier(childDataset.getColumnMetadata(), childColumnFieldToMatchOn, j);
                        Integer index = ownerColumnNameToIndex.get(id);
                        if (index == null) {
                            this.linkColumns = false;
                            columnOrder = null;
                            break;
                        }
                        columnOrder[j] = index;
                        inOrder = inOrder && index == j;
                    }
                    if (inOrder) {
                        columnOrder = null;
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    this.linkColumns = false;
                    columnOrder = null;
                }
            }
            if (this.linkRows || this.linkColumns) {
                childDataset = DatasetUtil.sliceView(childDataset, rowOrder, columnOrder);
            }
            this.childDataset = childDataset;
        }

        public Dataset getReorderedDataset() {
            return this.childDataset;
        }
    }

    private static class LinkedDataset
    extends DatasetAdapter {
        private List<Dataset> seriesDatasets = new ArrayList<Dataset>();

        public LinkedDataset(Dataset sourceDataset) {
            super(sourceDataset);
        }

        public void add(Dataset dataset) {
            this.seriesDatasets.add(dataset);
        }

        @Override
        public Object getObjectValue(int rowIndex, int columnIndex, int series) {
            return series >= super.getSeriesCount() ? Float.valueOf(this.seriesDatasets.get(series - super.getSeriesCount()).getValue(rowIndex, columnIndex)) : super.getObjectValue(rowIndex, columnIndex, series);
        }

        @Override
        public float getValue(int rowIndex, int columnIndex, int series) {
            return series >= super.getSeriesCount() ? this.seriesDatasets.get(series - super.getSeriesCount()).getValue(rowIndex, columnIndex) : super.getValue(rowIndex, columnIndex, series);
        }

        @Override
        public Class<?> getSeriesClass(int series) {
            return series >= super.getSeriesCount() ? Float.class : super.getSeriesClass(series);
        }

        @Override
        public int getSeriesCount() {
            return super.getSeriesCount() + this.seriesDatasets.size();
        }

        @Override
        public String getSeriesName(int series) {
            return series >= super.getSeriesCount() ? this.seriesDatasets.get(series - super.getSeriesCount()).getName() : super.getSeriesName(series);
        }
    }
}

