/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.combobox.CheckBoxListExComboBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.TreeNode;
import org.broadinstitute.genee.application.Application;
import org.broadinstitute.genee.application.GENEETreeNode;
import org.broadinstitute.genee.application.ProjectGENEEResultTreeNode;
import org.broadinstitute.genee.gui.BreadthFirstEnumeration;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.heatmap.LinkProjects;
import org.broadinstitute.genee.io.util.IOUtil;
import org.broadinstitute.genee.io.util.TrackerUtil;
import org.broadinstitute.genee.matrix.MetadataUtil;

public class LinkToMenu
extends JMenu
implements MenuListener {
    private WeakReference<ProjectGENEEResultTreeNode> sourceNodeWeakRef;

    public LinkToMenu(boolean dynamic) {
        super("Link to");
        if (dynamic) {
            this.addMenuListener(this);
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        GENEETreeNode node = Application.getWindowManager().getNode();
        ProjectGENEEResultTreeNode tnode = (ProjectGENEEResultTreeNode)(node instanceof ProjectGENEEResultTreeNode ? node : null);
        this.sourceNodeWeakRef = tnode == null ? null : new WeakReference<ProjectGENEEResultTreeNode>(tnode);
        this.rebuildMenu();
    }

    public void setParentNode(ProjectGENEEResultTreeNode node) {
        this.sourceNodeWeakRef = node == null ? null : new WeakReference<ProjectGENEEResultTreeNode>(node);
        this.rebuildMenu();
    }

    private ProjectGENEEResultTreeNode getSourceNode() {
        return (ProjectGENEEResultTreeNode)this.sourceNodeWeakRef.get();
    }

    private void rebuildMenu() {
        this.removeAll();
        ProjectGENEEResultTreeNode sourceNode = this.getSourceNode();
        if (sourceNode != null) {
            TreeNode root = Application.getNavigator().getRoot();
            BreadthFirstEnumeration e = new BreadthFirstEnumeration(root);
            int rows = sourceNode.getProject().getOriginalDataset().getRowCount();
            int cols = sourceNode.getProject().getOriginalDataset().getColumnCount();
            while (e.hasMoreElements()) {
                TreeNode next = e.nextElement();
                if (!(next instanceof ProjectGENEEResultTreeNode)) continue;
                final ProjectGENEEResultTreeNode childDocument = (ProjectGENEEResultTreeNode)next;
                int childRowCount = childDocument.getProject().getOriginalDataset().getRowCount();
                int childColumnCount = childDocument.getProject().getOriginalDataset().getColumnCount();
                if (childDocument == sourceNode || rows != childRowCount || cols != childColumnCount) continue;
                JMenuItem menuItem = new JMenuItem(childDocument.toString());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrackerUtil.trackPageView("Link To");
                        CheckBoxListExComboBox rowSource = new CheckBoxListExComboBox(MetadataUtil.getNames(childDocument.getProject().getOriginalDataset().getRowMetadata()).toArray());
                        CheckBoxListExComboBox columnSource = new CheckBoxListExComboBox(MetadataUtil.getNames(childDocument.getProject().getOriginalDataset().getColumnMetadata()).toArray());
                        ProjectGENEEResultTreeNode sourceNode = LinkToMenu.this.getSourceNode();
                        CheckBoxListExComboBox rowDest = new CheckBoxListExComboBox(MetadataUtil.getNames(sourceNode.getProject().getOriginalDataset().getRowMetadata()).toArray());
                        CheckBoxListExComboBox columnDest = new CheckBoxListExComboBox(MetadataUtil.getNames(sourceNode.getProject().getOriginalDataset().getColumnMetadata()).toArray());
                        if (rowSource.getItemCount() > 1 || columnSource.getItemCount() > 1 || rowDest.getItemCount() > 1 || columnDest.getItemCount() > 1) {
                            JPanel panel = new JPanel((LayoutManager)new FormLayout("p, 6px, p, 6px, p", "p, 8px, p, 8px, p"));
                            CellConstraints cc = new CellConstraints();
                            panel.add((Component)new JLabel(sourceNode.toString()), cc.xy(3, 1));
                            panel.add((Component)new JLabel(childDocument.toString()), cc.xy(5, 1));
                            panel.add((Component)new JLabel("Match row annotations on:"), cc.xy(1, 3));
                            panel.add((Component)rowSource, cc.xy(3, 3));
                            panel.add((Component)rowDest, cc.xy(5, 3));
                            panel.add((Component)new JLabel("Match column annotations on:"), cc.xy(1, 5));
                            panel.add((Component)columnSource, cc.xy(3, 5));
                            panel.add((Component)columnDest, cc.xy(5, 5));
                            if (UIUtil.showOkCancelDialog(UIUtil.getCurrentFrame(), panel, "Link")) {
                                String[] rowSourceSelection = IOUtil.toStringArray(rowSource.getSelectedObjects());
                                String[] columnSourceSelection = IOUtil.toStringArray(columnSource.getSelectedObjects());
                                String[] rowDestSelection = IOUtil.toStringArray(rowDest.getSelectedObjects());
                                String[] columnDestSelection = IOUtil.toStringArray(columnDest.getSelectedObjects());
                                new LinkProjects().link(childDocument, rowDestSelection, columnDestSelection, sourceNode, rowSourceSelection, columnSourceSelection);
                            } else {
                                return;
                            }
                        }
                    }
                });
                this.add(menuItem);
            }
        }
        this.revalidate();
    }
}

