/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import org.broadinstitute.genee.gui.UIUtil;
import org.broadinstitute.genee.matrix.Dataset;

public class MiniProfilePlot {
    private int bottomGutter = 1;
    private boolean filled = true;
    private GeneralPath generalPath = new GeneralPath();
    private int height;
    private int width;
    private int topGutter = 1;
    private float ymax;
    private float ymin;
    private float yPixPerUnit;

    private void _draw(Graphics2D g, Dataset dataset, int rowIndex) {
        float w = this.width / (dataset.getColumnCount() - 1);
        this.generalPath.reset();
        float xpix = 0.0f;
        float yminPix = this.yToPix(this.ymin);
        this.generalPath.moveTo(xpix, yminPix);
        int size = dataset.getColumnCount();
        for (int index = 0; index < size; ++index) {
            float ypix = this.yToPix(dataset.getValue(rowIndex, index));
            this.generalPath.lineTo(xpix += w, ypix);
        }
        if (this.filled) {
            float zero = this.yToPix(0.0f);
            this.generalPath.lineTo(xpix, zero);
            this.generalPath.lineTo(0.0f, zero);
            g.fill(this.generalPath);
        } else {
            g.draw(this.generalPath);
        }
    }

    public void draw(Graphics2D g, Dataset dataset, int rowIndex, Color color) {
        Color oldColor = g.getColor();
        this.ymax = -3.4028235E38f;
        this.ymin = Float.MAX_VALUE;
        int columns = dataset.getColumnCount();
        for (int j = 0; j < columns; ++j) {
            float d = dataset.getValue(rowIndex, j);
            if (Float.isNaN(d)) continue;
            this.ymax = d > this.ymax ? d : this.ymax;
            this.ymin = d < this.ymin ? d : this.ymin;
        }
        if (this.filled && this.ymin > 0.0f) {
            this.ymin = 0.0f;
        }
        this.yPixPerUnit = (float)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / (this.ymax - this.ymin);
        g.addRenderingHints(UIUtil.RENDERING_HINTS);
        g.setColor(color);
        this._draw(g, dataset, rowIndex);
        g.setColor(oldColor);
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    private float yToPix(float y) {
        float pix = -this.yPixPerUnit * y + (this.ymax * this.yPixPerUnit + (float)this.topGutter);
        return pix;
    }
}

