/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.genee.heatmap;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.image.BufferedImage;
import org.broadinstitute.genee.heatmap.ColorSupplier;

public class MultiGradientColorSupplier
implements ColorSupplier {
    private BufferedImage bi;
    private LinearGradientPaint paint;
    private float max;
    private float min;

    public MultiGradientColorSupplier() {
        this.setPaint(new float[]{0.0f, 0.5f, 1.0f}, new Color[]{Color.BLUE, Color.WHITE, Color.RED});
    }

    @Override
    public Color getColor(int row, int column, float value) {
        int colorIndex = 0;
        float min = this.min;
        float max = this.max;
        if (value <= min) {
            colorIndex = 0;
        } else if (value >= max) {
            colorIndex = 255;
        } else {
            float unit = 255.0f / (max - min);
            colorIndex = (int)Math.floor(unit * value + -min * unit);
        }
        try {
            return new Color(this.bi.getRGB(colorIndex, 0));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RuntimeException(colorIndex + " out of bounds. Min: " + min + ", max: " + max + ", value: " + value);
        }
    }

    @Override
    public Color[] getColors() {
        return this.paint.getColors();
    }

    @Override
    public float[] getFractions() {
        return this.paint.getFractions();
    }

    @Override
    public float getMax() {
        return this.max;
    }

    @Override
    public float getMin() {
        return this.min;
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public void setMax(float max) {
        this.max = max;
    }

    @Override
    public void setMin(float min) {
        this.min = min;
    }

    @Override
    public void setPaint(float[] fractions, Color[] colors) {
        if (colors.length < 2) {
            return;
        }
        for (int i = 1; i < fractions.length; ++i) {
            if (fractions[i] != fractions[i - 1]) continue;
            int n = i;
            fractions[n] = fractions[n] + 1.0E-42f;
        }
        this.paint = new LinearGradientPaint(0.0f, 0.0f, 256.0f, 0.0f, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        this.bi = new BufferedImage(256, 1, 5);
        Graphics2D g = this.bi.createGraphics();
        g.setPaint(this.paint);
        g.fillRect(0, 0, this.bi.getWidth(), this.bi.getHeight());
        g.dispose();
    }
}

